/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.evidence.EvidenceService;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceAuditException;
import java.io.File;

public class EvidenceAuditExtractFromZip
extends ActionHandler {
    private static final String EVIDENCE_AUDIT_EXTRACT_ZIP_FILE = "EVIDENCE_AUDIT_EXTRACT_ZIP_FILE";
    private final EvidenceService evidenceService;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceAuditExtractFromZip.class);

    @VisibleForTesting
    EvidenceAuditExtractFromZip(EvidenceService evidenceService) {
        this.evidenceService = evidenceService;
    }

    public EvidenceAuditExtractFromZip() {
        this(new EvidenceService());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(EVIDENCE_AUDIT_EXTRACT_ZIP_FILE);
        String secureDataFileName = param.getObjectName();
        File file = null;
        try {
            file = this.evidenceService.downloadAndExtractDataFromStorage(secureDataFileName, "data.txt", "zip", true);
            handlerIO.transferFileToWorkspace("zip" + File.separator + secureDataFileName, file, true, false);
            itemStatus.increment(StatusCode.OK);
            return new ItemStatus(EVIDENCE_AUDIT_EXTRACT_ZIP_FILE).setItemsStatus(EVIDENCE_AUDIT_EXTRACT_ZIP_FILE, itemStatus);
        }
        catch (EvidenceAuditException e) {
            LOGGER.error((Throwable)((Object)e));
            return itemStatus.increment(StatusCode.FATAL);
        }
    }
}

