/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.EvidenceAuditReportEntry;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.audit.exception.AuditException;
import fr.gouv.vitam.worker.core.plugin.evidence.EvidenceService;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceStatus;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditParameters;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportObject;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EvidenceAuditDatabaseCheck
extends ActionHandler {
    private static final String EVIDENCE_AUDIT_CHECK_DATABASE = "EVIDENCE_AUDIT_CHECK_DATABASE";
    private static final String METADA_TYPE = "metadaType";
    private static final String DATA = "data";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceAuditDatabaseCheck.class);
    private static final String REPORTS = "reports";
    private static final int STRATEGIES_IN_RANK = 0;
    private final EvidenceService evidenceService;
    private final EvidenceAuditReportService evidenceAuditReportService;

    @VisibleForTesting
    EvidenceAuditDatabaseCheck(EvidenceService evidenceService, EvidenceAuditReportService evidenceAuditReportService) {
        this.evidenceService = evidenceService;
        this.evidenceAuditReportService = evidenceAuditReportService;
    }

    public EvidenceAuditDatabaseCheck() {
        this(new EvidenceService(), new EvidenceAuditReportService());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(EVIDENCE_AUDIT_CHECK_DATABASE);
        String objectToAuditId = param.getObjectName();
        try {
            File file = handlerIO.getFileFromWorkspace("Object/" + objectToAuditId);
            JsonNode objectIdToAudit = JsonHandler.getFromFile((File)file);
            MetadataType metadataType = MetadataType.valueOf((String)objectIdToAudit.get(METADA_TYPE).textValue());
            List<StorageStrategy> storageStrategies = this.loadStorageStrategies(handlerIO);
            EvidenceAuditParameters parameters = this.evidenceService.evidenceAuditsChecks(objectToAuditId, metadataType, storageStrategies);
            File newLocalFile = handlerIO.getNewLocalFile(objectToAuditId + ".tmp");
            JsonHandler.writeAsFile((Object)parameters, (File)newLocalFile);
            handlerIO.transferFileToWorkspace("data/" + objectToAuditId, newLocalFile, true, false);
            if (parameters.getEvidenceStatus().equals((Object)EvidenceStatus.FATAL)) {
                itemStatus.increment(StatusCode.FATAL);
                ObjectNode infoNode = JsonHandler.createObjectNode();
                infoNode.put("Message", "Fatal Technical error " + parameters.getAuditMessage());
                itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                this.evidenceAuditReportService.cleanupReport(param.getContainerName());
                return new ItemStatus(EVIDENCE_AUDIT_CHECK_DATABASE).setItemsStatus(EVIDENCE_AUDIT_CHECK_DATABASE, itemStatus);
            }
            if (parameters.getEvidenceStatus().equals((Object)EvidenceStatus.KO) || parameters.getEvidenceStatus().equals((Object)EvidenceStatus.WARN)) {
                EvidenceAuditReportLine evidenceAuditReportLine = null;
                evidenceAuditReportLine = new EvidenceAuditReportLine(objectToAuditId);
                evidenceAuditReportLine.setEvidenceStatus(parameters.getEvidenceStatus());
                evidenceAuditReportLine.setMessage(parameters.getAuditMessage());
                evidenceAuditReportLine.setStrategyId(parameters.getMdOptimisticStorageInfo().getStrategy());
                JsonHandler.writeAsFile((Object)evidenceAuditReportLine, (File)file);
                handlerIO.transferFileToWorkspace("reports/" + objectToAuditId + ".report.json", file, true, false);
                if (!param.getWorkflowIdentifier().equals("RECTIFICATION_AUDIT")) {
                    this.addReportEntry(param.getContainerName(), this.createEvidenceReportEntry(parameters, evidenceAuditReportLine));
                }
            }
            itemStatus.increment(StatusCode.OK);
            return new ItemStatus(EVIDENCE_AUDIT_CHECK_DATABASE).setItemsStatus(EVIDENCE_AUDIT_CHECK_DATABASE, itemStatus);
        }
        catch (VitamException | IOException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(EVIDENCE_AUDIT_CHECK_DATABASE).setItemsStatus(EVIDENCE_AUDIT_CHECK_DATABASE, itemStatus);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(e.getStatusCode());
            return new ItemStatus(EVIDENCE_AUDIT_CHECK_DATABASE).setItemsStatus(EVIDENCE_AUDIT_CHECK_DATABASE, itemStatus);
        }
    }

    private void addReportEntry(String processId, EvidenceAuditReportEntry entry) throws ProcessingStatusException {
        this.evidenceAuditReportService.appendEntries(processId, Arrays.asList(entry));
    }

    private EvidenceAuditReportEntry createEvidenceReportEntry(EvidenceAuditParameters parameters, EvidenceAuditReportLine evidenceAuditReportLine) {
        ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject> ListvidEvidenceAuditBatchReport = this.createEvidenceBatchFromEvidenceWorker(evidenceAuditReportLine);
        return new EvidenceAuditReportEntry(parameters.getId(), parameters.getEvidenceStatus().name(), parameters.getAuditMessage(), parameters.getMetadataType().name(), ListvidEvidenceAuditBatchReport, evidenceAuditReportLine.getSecuredHash(), evidenceAuditReportLine.getStrategyId(), evidenceAuditReportLine.getOffersHashes(), parameters.getAuditMessage());
    }

    private ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject> createEvidenceBatchFromEvidenceWorker(EvidenceAuditReportLine evidenceAuditReportLine) {
        ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject> list = new ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject>();
        if (evidenceAuditReportLine.getObjectsReports() != null) {
            for (EvidenceAuditReportObject objects : evidenceAuditReportLine.getObjectsReports()) {
                list.add(new fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject(objects.getIdentifier(), objects.getEvidenceStatus().name(), objects.getMessage(), objects.getObjectType(), objects.getSecuredHash(), objects.getStrategyId(), objects.getOffersHashes()));
            }
            return list;
        }
        return list;
    }

    private List<StorageStrategy> loadStorageStrategies(HandlerIO handler) throws AuditException {
        try {
            return (List)JsonHandler.getFromFileAsTypeReference((File)((File)handler.getInput(0)), (TypeReference)new TypeReference<List<StorageStrategy>>(){});
        }
        catch (InvalidParseOperationException e) {
            throw new AuditException(StatusCode.FATAL, "Could not load storage strategies datas", e);
        }
    }
}

