/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.StoreMetaDataObjectGroupActionPlugin;
import fr.gouv.vitam.worker.core.plugin.StoreMetaDataUnitActionPlugin;
import fr.gouv.vitam.worker.core.plugin.evidence.DataRectificationService;
import fr.gouv.vitam.worker.core.plugin.evidence.IdentifierType;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DataRectificationStep
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DataRectificationStep.class);
    private static final String CORRECTIVE_AUDIT = "CORRECTIVE_AUDIT";
    private static final String CORRECT = "correct" + File.separator;
    private static final String ALTER = "alter";
    private final StoreMetaDataObjectGroupActionPlugin storeMetaDataObjectGroupActionPlugin;
    private final StoreMetaDataUnitActionPlugin storeMetaDataUnitActionPlugin;
    private final DataRectificationService dataRectificationService;

    @VisibleForTesting
    public DataRectificationStep(DataRectificationService dataRectificationService, StoreMetaDataObjectGroupActionPlugin storeMetaDataObjectGroupActionPlugin, StoreMetaDataUnitActionPlugin storeMetaDataUnitActionPlugin) {
        this.dataRectificationService = dataRectificationService;
        this.storeMetaDataObjectGroupActionPlugin = storeMetaDataObjectGroupActionPlugin;
        this.storeMetaDataUnitActionPlugin = storeMetaDataUnitActionPlugin;
    }

    public DataRectificationStep() {
        this(new DataRectificationService(), new StoreMetaDataObjectGroupActionPlugin(), new StoreMetaDataUnitActionPlugin());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(CORRECTIVE_AUDIT);
        try {
            ArrayList<IdentifierType> identifierTypes = new ArrayList<IdentifierType>();
            File file = handler.getFileFromWorkspace(ALTER + File.separator + param.getObjectName());
            EvidenceAuditReportLine evidenceAuditReportLine = (EvidenceAuditReportLine)JsonHandler.getFromFile((File)file, EvidenceAuditReportLine.class);
            if (evidenceAuditReportLine.getObjectType().equals((Object)MetadataType.OBJECTGROUP)) {
                List<IdentifierType> objectGroups = this.dataRectificationService.correctObjectGroups(evidenceAuditReportLine, param.getContainerName());
                identifierTypes.addAll(objectGroups);
            }
            Optional<IdentifierType> identifierType = Optional.empty();
            if (evidenceAuditReportLine.getObjectType().equals((Object)MetadataType.UNIT)) {
                identifierType = this.dataRectificationService.correctUnits(evidenceAuditReportLine, param.getContainerName());
            }
            identifierType.ifPresent(identifierTypes::add);
            file = handler.getNewLocalFile(param.getObjectName());
            if (!identifierTypes.isEmpty()) {
                JsonHandler.writeAsFile(identifierTypes, (File)file);
                handler.transferFileToWorkspace(CORRECT + param.getObjectName() + ".report.json", file, true, false);
                for (IdentifierType type : identifierTypes) {
                    if (type.getType().equals(DataCategory.OBJECTGROUP.name()) || type.getType().equals(DataCategory.OBJECT.name())) {
                        this.storeMetaDataObjectGroupActionPlugin.storeDocumentsWithLfc(param, handler, Collections.singletonList(type.getId()));
                    }
                    if (!type.getType().equals(DataCategory.UNIT.name())) continue;
                    this.storeMetaDataUnitActionPlugin.storeDocumentsWithLfc(param, handler, Collections.singletonList(type.getId()));
                }
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (VitamException | IOException e) {
            LOGGER.error(e);
            return itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(CORRECTIVE_AUDIT).setItemsStatus(CORRECTIVE_AUDIT, itemStatus);
    }
}

