/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.core.plugin.evidence.DataRectificationHelper;
import fr.gouv.vitam.worker.core.plugin.evidence.IdentifierType;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceStatus;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DataRectificationService {
    private final StorageClientFactory storageClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private static final String OBJECT_CORRECTIVE_AUDIT = "OBJECT_CORRECTIVE_AUDIT";
    private static final String UNIT_CORRECTIVE_AUDIT = "UNIT_CORRECTIVE_AUDIT";
    private static final String OBJECT_GROUP_CORRECTIVE_AUDIT = "OBJECT_GROUP_CORRECTIVE_AUDIT";

    @VisibleForTesting
    DataRectificationService(StorageClientFactory storageClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory) {
        this.storageClientFactory = storageClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
    }

    DataRectificationService() {
        this(StorageClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance());
    }

    public Optional<IdentifierType> correctUnits(EvidenceAuditReportLine line, String containerName) throws InvalidParseOperationException, StorageServerClientException, LogbookClientNotFoundException, LogbookClientServerException, LogbookClientBadRequestException, InvalidGuidOperationException, StorageUnavailableDataFromAsyncOfferClientException {
        String securedHash = line.getSecuredHash();
        ArrayList<String> goodOffers = new ArrayList<String>();
        ArrayList<String> badOffers = new ArrayList<String>();
        if (!DataRectificationHelper.canDoCorrection(line.getOffersHashes(), securedHash, goodOffers, badOffers)) {
            return Optional.empty();
        }
        String message = String.format("offer '%s'  has been corrected from offer %s ", badOffers.get(0), goodOffers.get(0));
        this.storageClientFactory.getClient().copyObjectFromOfferToOffer(line.getIdentifier() + ".json", DataCategory.UNIT, (String)goodOffers.get(0), (String)badOffers.get(0), line.getStrategyId());
        this.updateLifecycleUnit(containerName, line.getIdentifier(), UNIT_CORRECTIVE_AUDIT, message);
        return Optional.of(new IdentifierType(line.getIdentifier(), DataCategory.UNIT.name()));
    }

    public List<IdentifierType> correctObjectGroups(EvidenceAuditReportLine line, String containerName) throws InvalidParseOperationException, StorageServerClientException, LogbookClientNotFoundException, LogbookClientServerException, LogbookClientBadRequestException, InvalidGuidOperationException, StorageUnavailableDataFromAsyncOfferClientException {
        String securedHash = line.getSecuredHash();
        ArrayList<IdentifierType> listCorrections = new ArrayList<IdentifierType>();
        ArrayList<String> goodOffers = new ArrayList<String>();
        ArrayList<String> badOffers = new ArrayList<String>();
        if (DataRectificationHelper.canDoCorrection(line.getOffersHashes(), securedHash, goodOffers, badOffers)) {
            String message = String.format("offer '%s'  has been corrected from offer %s ", badOffers.get(0), goodOffers.get(0));
            this.storageClientFactory.getClient().copyObjectFromOfferToOffer(line.getIdentifier() + ".json", DataCategory.OBJECTGROUP, (String)goodOffers.get(0), (String)badOffers.get(0), line.getStrategyId());
            this.updateLifecycleObject(containerName, line.getIdentifier(), OBJECT_GROUP_CORRECTIVE_AUDIT, message);
            listCorrections.add(new IdentifierType(line.getIdentifier(), DataCategory.OBJECTGROUP.name()));
        }
        for (EvidenceAuditReportObject object : line.getObjectsReports()) {
            goodOffers.clear();
            badOffers.clear();
            securedHash = object.getSecuredHash();
            if (object.getEvidenceStatus() == EvidenceStatus.OK || !DataRectificationHelper.canDoCorrection(object.getOffersHashes(), securedHash, goodOffers, badOffers)) continue;
            String message = String.format("offer '%s'  has been corrected from offer %s  for object id %s ", badOffers.get(0), goodOffers.get(0), object.getIdentifier());
            this.storageClientFactory.getClient().copyObjectFromOfferToOffer(object.getIdentifier(), DataCategory.OBJECT, (String)goodOffers.get(0), (String)badOffers.get(0), object.getStrategyId());
            this.updateLifecycleObject(containerName, line.getIdentifier(), OBJECT_CORRECTIVE_AUDIT, message);
            listCorrections.add(new IdentifierType(line.getIdentifier(), DataCategory.OBJECT.name()));
        }
        return listCorrections;
    }

    private void updateLifecycleObject(String containerName, String identifier, String detail, String message) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException, InvalidGuidOperationException {
        LogbookTypeProcess eventTypeProcess = LogbookTypeProcess.UPDATE;
        GUID updateGuid = GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter());
        StatusCode logbookOutcome = StatusCode.OK;
        LogbookLifeCycleObjectGroupParameters parameters = LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters((GUID)updateGuid, (String)VitamLogbookMessages.getEventTypeLfc((String)detail), (GUID)GUIDReader.getGUID((String)containerName), (LogbookTypeProcess)eventTypeProcess, (StatusCode)logbookOutcome, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)detail, (StatusCode)logbookOutcome), (String)VitamLogbookMessages.getCodeLfc((String)detail, (StatusCode)logbookOutcome), (GUID)GUIDReader.getGUID((String)identifier));
        ObjectNode object = JsonHandler.createObjectNode();
        object.put("Information", message);
        String wellFormedJson = JsonHandler.unprettyPrint((Object)object);
        parameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        this.logbookLifeCyclesClientFactory.getClient().update((LogbookLifeCycleParameters)parameters, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
    }

    private void updateLifecycleUnit(String containerName, String identifier, String detail, String message) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException, InvalidGuidOperationException {
        LogbookTypeProcess eventTypeProcess = LogbookTypeProcess.UPDATE;
        GUID updateGuid = GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter());
        StatusCode logbookOutcome = StatusCode.OK;
        LogbookLifeCycleUnitParameters parameters = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)updateGuid, (String)VitamLogbookMessages.getEventTypeLfc((String)detail), (GUID)GUIDReader.getGUID((String)containerName), (LogbookTypeProcess)eventTypeProcess, (StatusCode)logbookOutcome, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)detail, (StatusCode)logbookOutcome), (String)VitamLogbookMessages.getCodeLfc((String)detail, (StatusCode)logbookOutcome), (GUID)GUIDReader.getGUID((String)identifier));
        ObjectNode object = JsonHandler.createObjectNode();
        object.put("Information", message);
        String wellFormedJson = JsonHandler.unprettyPrint((Object)object);
        parameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        this.logbookLifeCyclesClientFactory.getClient().update((LogbookLifeCycleParameters)parameters, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
    }
}

