/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.ProcessingRetryAsyncException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.common.CheckResourceAvailability;
import fr.gouv.vitam.worker.core.plugin.evidence.DataRectificationHelper;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceStatus;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportObject;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DataRectificationCheckResourceAvailability
extends CheckResourceAvailability {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DataRectificationCheckResourceAvailability.class);
    public static final String PLUGIN_NAME = "CORRECTIVE_AUDIT_CHECK_RESOURCE_AVAILABILITY";
    private static final String ALTER = "alter";

    public DataRectificationCheckResourceAvailability() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public DataRectificationCheckResourceAvailability(StorageClientFactory storage) {
        super(storage);
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            Map<DataCategory, Map<AccessRequestContext, List<String>>> entriesByCategories = this.extractResources(workerParameters, handler);
            this.checkResourcesAvailabilityByTypes(entriesByCategories);
            return IntStream.range(0, workerParameters.getObjectNameList().size()).mapToObj(index -> PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of(String.format("%s executed", PLUGIN_NAME)))).collect(Collectors.toList());
        }
        catch (ProcessingRetryAsyncException prae) {
            LOGGER.info("Some resources where not available");
            throw prae;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private Map<DataCategory, Map<AccessRequestContext, List<String>>> extractResources(WorkerParameters workerParameters, HandlerIO handler) throws IOException, InvalidParseOperationException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        HashMap<DataCategory, Map<AccessRequestContext, List<String>>> entries = new HashMap<DataCategory, Map<AccessRequestContext, List<String>>>();
        HashMap entriesObjectGroup = new HashMap();
        HashMap entriesObject = new HashMap();
        HashMap entriesUnit = new HashMap();
        for (String objectId : workerParameters.getObjectNameList()) {
            File file = handler.getFileFromWorkspace(ALTER + File.separator + objectId);
            EvidenceAuditReportLine line = (EvidenceAuditReportLine)JsonHandler.getFromFile((File)file, EvidenceAuditReportLine.class);
            if (line.getObjectType().equals((Object)MetadataType.OBJECTGROUP)) {
                this.extractMetadata(line).ifPresent(pair -> entriesObjectGroup.computeIfAbsent((AccessRequestContext)pair.getLeft(), x -> new ArrayList()).add((String)pair.getRight()));
                Map<AccessRequestContext, List<String>> objectExtracted = this.extractObjects(line);
                objectExtracted.keySet().forEach(context -> entriesObject.computeIfAbsent(context, x -> new ArrayList()).addAll((Collection)objectExtracted.get(context)));
            }
            if (!line.getObjectType().equals((Object)MetadataType.UNIT)) continue;
            this.extractMetadata(line).ifPresent(pair -> entriesUnit.computeIfAbsent((AccessRequestContext)pair.getLeft(), x -> new ArrayList()).add((String)pair.getRight()));
        }
        entries.put(DataCategory.OBJECTGROUP, entriesObjectGroup);
        entries.put(DataCategory.OBJECT, entriesObject);
        entries.put(DataCategory.UNIT, entriesUnit);
        return entries;
    }

    private Optional<Pair<AccessRequestContext, String>> extractMetadata(EvidenceAuditReportLine line) {
        ArrayList<String> goodOffers = new ArrayList<String>();
        ArrayList<String> badOffers = new ArrayList<String>();
        if (DataRectificationHelper.canDoCorrection(line.getOffersHashes(), line.getSecuredHash(), goodOffers, badOffers)) {
            return Optional.of(new ImmutablePair((Object)new AccessRequestContext(line.getStrategyId(), (String)goodOffers.get(0)), (Object)(line.getIdentifier() + ".json")));
        }
        return Optional.empty();
    }

    private Map<AccessRequestContext, List<String>> extractObjects(EvidenceAuditReportLine line) {
        HashMap<AccessRequestContext, List<String>> entriesObject = new HashMap<AccessRequestContext, List<String>>();
        for (EvidenceAuditReportObject object : line.getObjectsReports()) {
            ArrayList<String> goodOffers = new ArrayList<String>();
            ArrayList<String> badOffers = new ArrayList<String>();
            if (object.getEvidenceStatus() == EvidenceStatus.OK || !DataRectificationHelper.canDoCorrection(object.getOffersHashes(), object.getSecuredHash(), goodOffers, badOffers)) continue;
            entriesObject.computeIfAbsent(new AccessRequestContext(object.getStrategyId(), (String)goodOffers.get(0)), x -> new ArrayList()).add(object.getIdentifier());
        }
        return entriesObject;
    }
}

