/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.functional.administration.common.exception.BackupServiceException;
import fr.gouv.vitam.functional.administration.core.backup.BackupService;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class DataCorrectionFinalize
extends ActionHandler {
    private static final String CORRECTION_FINALIZE = "CORRECTION_FINALIZE";
    private final BackupService backupService;

    @VisibleForTesting
    DataCorrectionFinalize(BackupService backupService) {
        this.backupService = backupService;
    }

    public DataCorrectionFinalize() {
        this(new BackupService());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(CORRECTION_FINALIZE);
        try {
            String reportFileName = handlerIO.getContainerName() + ".json";
            this.generateReportToWorkspace(param, handlerIO, reportFileName);
            this.saveToOffers(handlerIO, reportFileName);
        }
        catch (InvalidParseOperationException | BackupServiceException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingException(e);
        }
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(CORRECTION_FINALIZE).setItemsStatus(CORRECTION_FINALIZE, itemStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReportToWorkspace(WorkerParameters param, HandlerIO handlerIO, String reportFileName) throws ProcessingException, IOException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException, InvalidParseOperationException {
        if (handlerIO.isExistingFileInWorkspace(reportFileName)) {
            return;
        }
        File reportFile = handlerIO.getNewLocalFile(reportFileName);
        try {
            List uriListObjectsWorkspace = handlerIO.getUriList(handlerIO.getContainerName(), param.getObjectName());
            try (FileOutputStream fileOutputStream = new FileOutputStream(reportFile);
                 BufferedOutputStream buffOut = new BufferedOutputStream(fileOutputStream);){
                for (URI uri : uriListObjectsWorkspace) {
                    File file = handlerIO.getFileFromWorkspace(param.getObjectName() + "/" + uri.getPath());
                    ArrayList reportLine = (ArrayList)JsonHandler.getFromFile((File)file, ArrayList.class);
                    buffOut.write(JsonHandler.unprettyPrint((Object)reportLine).getBytes());
                    buffOut.write(System.lineSeparator().getBytes());
                }
            }
            handlerIO.transferAtomicFileToWorkspace(reportFileName, reportFile);
        }
        finally {
            FileUtils.deleteQuietly((File)reportFile);
        }
    }

    private void saveToOffers(HandlerIO handlerIO, String reportFileName) throws BackupServiceException {
        this.backupService.storeIntoOffers(handlerIO.getContainerName(), reportFileName, DataCategory.REPORT, reportFileName, VitamConfiguration.getDefaultStrategy());
    }
}

