/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.elimination;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.rules.InheritedRuleCategoryResponseModel;
import fr.gouv.vitam.common.model.rules.UnitInheritedRulesResponseModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationAnalysisService;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationAnalysisResult;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationEventDetails;
import fr.gouv.vitam.worker.core.utils.HoldRuleUtils;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class EliminationUtils {
    private static final String REQUEST_JSON = "request.json";
    private static final String INVALID_REQUEST = "Invalid request";
    private static final String COULD_NOT_LOAD_REQUEST_FROM_WORKSPACE = "Could not load request from workspace";

    private EliminationUtils() {
    }

    public static EliminationAnalysisResult computeEliminationAnalysisForUnitWithInheritedRules(JsonNode unit, EliminationAnalysisService eliminationAnalysisService, WorkerParameters param, LocalDate expirationDate) throws ProcessingStatusException {
        InheritedRuleCategoryResponseModel inheritedEliminatedRuleCategory = EliminationUtils.parseAppraisalRuleCategory(unit);
        InheritedRuleCategoryResponseModel inheritedHoldRuleCategory = HoldRuleUtils.parseHoldRuleCategory(unit);
        String originatingAgency = unit.has(VitamFieldsHelper.originatingAgency()) ? unit.get(VitamFieldsHelper.originatingAgency()).asText() : null;
        String unitId = unit.get(VitamFieldsHelper.id()).asText();
        UnitType unitType = UnitType.valueOf((String)unit.get(VitamFieldsHelper.unitType()).asText());
        return eliminationAnalysisService.analyzeElimination(unitId, unitType, param.getRequestId(), inheritedEliminatedRuleCategory.getRules(), inheritedEliminatedRuleCategory.getProperties(), inheritedHoldRuleCategory.getRules(), expirationDate, originatingAgency);
    }

    private static InheritedRuleCategoryResponseModel parseAppraisalRuleCategory(JsonNode unit) throws ProcessingStatusException {
        try {
            JsonNode inheritedRules = unit.get("InheritedRules");
            UnitInheritedRulesResponseModel unitInheritedRulesResponseModel = (UnitInheritedRulesResponseModel)JsonHandler.getFromJsonNode((JsonNode)inheritedRules, UnitInheritedRulesResponseModel.class);
            return (InheritedRuleCategoryResponseModel)unitInheritedRulesResponseModel.getRuleCategories().get("AppraisalRule");
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not parse unit information", e);
        }
    }

    public static EliminationRequestBody loadRequestJsonFromWorkspace(HandlerIO handler) throws ProcessingStatusException {
        try {
            return (EliminationRequestBody)JsonHandler.getFromInputStream((InputStream)handler.getInputStreamFromWorkspace(REQUEST_JSON), EliminationRequestBody.class);
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, COULD_NOT_LOAD_REQUEST_FROM_WORKSPACE, e);
        }
        catch (InvalidParseOperationException e) {
            EliminationEventDetails eventDetails = new EliminationEventDetails().setError(INVALID_REQUEST);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, INVALID_REQUEST, e);
        }
    }

    public static List<String> getReportExtraFields() {
        return Objects.requireNonNullElse((List)VitamConfiguration.getEliminationReportExtraFields().get(VitamThreadUtils.getVitamSession().getTenantId()), Collections.emptyList());
    }
}

