/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.elimination;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationUtils;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationEventDetails;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public abstract class EliminationCheckDistributionThresholdBase
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);
    private final MetaDataClientFactory metaDataClientFactory;

    EliminationCheckDistributionThresholdBase(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ItemStatus checkThreshold(HandlerIO handler, long defaultThreshold, String action) {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            long threshold;
            EliminationRequestBody eliminationRequestBody = EliminationUtils.loadRequestJsonFromWorkspace(handler);
            JsonNode dslRequest = eliminationRequestBody.getDslRequest();
            SelectParserMultiple selectParser = new SelectParserMultiple();
            selectParser.parse(dslRequest);
            SelectMultiQuery request = selectParser.getRequest();
            request.setLimitFilter(0L, 1L);
            request.trackTotalHits(true);
            request.resetUsageProjection();
            request.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            JsonNode response = client.selectUnits((JsonNode)request.getFinalSelect());
            RequestResponseOK responseOK = RequestResponseOK.getFromJsonNode((JsonNode)response);
            long total = responseOK.getHits().getTotal();
            Long requestThreshold = request.getThreshold();
            long l = threshold = requestThreshold != null ? requestThreshold : defaultThreshold;
            if (total > threshold) {
                EliminationEventDetails eventDetails = new EliminationEventDetails().setError("Too many units found. Threshold=" + threshold + ", found=" + total);
                ItemStatus itemStatus = PluginHelper.buildItemStatus(action, StatusCode.KO, eventDetails);
                return itemStatus;
            }
            if (total > defaultThreshold) {
                EliminationEventDetails eventDetails = new EliminationEventDetails().setWarning("Unit count exceeds default threshold. Default threshold=" + defaultThreshold + ", found=" + total);
                ItemStatus itemStatus = PluginHelper.buildItemStatus(action, StatusCode.WARNING, eventDetails);
                return itemStatus;
            }
            ItemStatus itemStatus = PluginHelper.buildItemStatus(action, StatusCode.OK, null);
            return itemStatus;
        }
        catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            LOGGER.error(e);
            EliminationEventDetails eventDetails = new EliminationEventDetails().setError("An error occurred during elimination distribution check");
            return PluginHelper.buildItemStatus(action, StatusCode.FATAL, eventDetails);
        }
        catch (ProcessingStatusException e) {
            return PluginHelper.buildItemStatus(action, e.getStatusCode(), e.getEventDetails());
        }
    }
}

