/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.elimination;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.PushAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationAnalysisResult;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public class EliminationAnalysisUnitIndexationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EliminationAnalysisUnitIndexationPlugin.class);
    private static final String ELIMINATION_ANALYSIS_UNIT_INDEXATION = "ELIMINATION_ANALYSIS_UNIT_INDEXATION";
    private final MetaDataClientFactory metaDataClientFactory;

    public EliminationAnalysisUnitIndexationPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    EliminationAnalysisUnitIndexationPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            EliminationAnalysisResult eliminationAnalysisResult = this.getUnitEliminationAnalysisResult(param);
            String unitId = param.getObjectName();
            this.indexUnit(unitId, eliminationAnalysisResult);
            LOGGER.info("Elimination analysis unit indexation succeeded");
            return PluginHelper.buildItemStatus(ELIMINATION_ANALYSIS_UNIT_INDEXATION, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Elimination analysis unit indexation failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(ELIMINATION_ANALYSIS_UNIT_INDEXATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    private void indexUnit(String unitId, EliminationAnalysisResult eliminationAnalysisResult) throws ProcessingStatusException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
            updateMultiQuery.addActions(new Action[]{new PushAction(VitamFieldsHelper.elimination(), JsonHandler.toJsonNode((Object)eliminationAnalysisResult))});
            client.updateUnitById((JsonNode)updateMultiQuery.getFinalUpdateById(), unitId);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not index unit " + unitId, e);
        }
    }

    private EliminationAnalysisResult getUnitEliminationAnalysisResult(WorkerParameters params) throws ProcessingStatusException {
        try {
            return (EliminationAnalysisResult)JsonHandler.getFromJsonNode((JsonNode)params.getObjectMetadata(), EliminationAnalysisResult.class);
        }
        catch (Exception e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not retrieve unit elimination analysis information", e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return ELIMINATION_ANALYSIS_UNIT_INDEXATION;
    }
}

