/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.elimination;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.VitamConstants;
import fr.gouv.vitam.common.model.rules.BaseInheritedResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedPropertyResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleResponseModel;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationAnalysisResult;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationAnalysisStatusForOriginatingAgency;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationExtendedInfo;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationExtendedInfoAccessLinkInconsistency;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationExtendedInfoAccessLinkInconsistencyDetails;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationExtendedInfoFinalActionInconsistency;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationExtendedInfoHoldRule;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationExtendedInfoHoldRuleDetails;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationExtendedInfoKeepAccessSp;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationGlobalStatus;
import fr.gouv.vitam.worker.core.utils.HoldRuleUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class EliminationAnalysisService {
    public EliminationAnalysisResult analyzeElimination(String unitId, UnitType unitType, String operationId, List<InheritedRuleResponseModel> appraisalRules, List<InheritedPropertyResponseModel> appraisalProperties, List<InheritedRuleResponseModel> holdRules, LocalDate expirationDate, String sp) {
        if (unitType.equals((Object)UnitType.HOLDING_UNIT)) {
            return new EliminationAnalysisResult(operationId, EliminationGlobalStatus.DESTROY, Collections.emptySet(), Collections.emptySet(), Collections.emptyList());
        }
        Set<String> activeHoldRules = this.listActiveHoldRuleIds(unitId, holdRules, expirationDate);
        Map<String, EliminationAnalysisStatusForOriginatingAgency> statusByOriginatingAgency = this.analyzeAppraisalFinalActionByOriginatingAgency(appraisalRules, appraisalProperties, expirationDate);
        Set<String> destroyableOriginatingAgencies = this.filterByTargetStatus(statusByOriginatingAgency, EliminationAnalysisStatusForOriginatingAgency.DESTROY);
        Set<String> nonDestroyableOriginatingAgencies = this.filterByTargetStatus(statusByOriginatingAgency, EliminationAnalysisStatusForOriginatingAgency.KEEP);
        Set<String> conflictOnOriginatingAgencies = this.filterByTargetStatus(statusByOriginatingAgency, EliminationAnalysisStatusForOriginatingAgency.FINAL_ACTION_INCONSISTENCY);
        EliminationGlobalStatus globalStatus = this.getGlobalStatus(destroyableOriginatingAgencies, nonDestroyableOriginatingAgencies, conflictOnOriginatingAgencies, activeHoldRules);
        ArrayList<EliminationExtendedInfo> extendedInfo = new ArrayList<EliminationExtendedInfo>();
        if (globalStatus != EliminationGlobalStatus.KEEP) {
            if (!conflictOnOriginatingAgencies.isEmpty()) {
                extendedInfo.add(new EliminationExtendedInfoFinalActionInconsistency(conflictOnOriginatingAgencies));
            }
            if (this.shouldKeepAccessToOriginatingAgency(sp, destroyableOriginatingAgencies, nonDestroyableOriginatingAgencies)) {
                extendedInfo.add(new EliminationExtendedInfoKeepAccessSp());
            }
            List<EliminationExtendedInfoAccessLinkInconsistencyDetails> accessLinkInconsistencies = this.analyzeAppraisalAccessLinkInconsistencies(appraisalRules, appraisalProperties, expirationDate);
            for (EliminationExtendedInfoAccessLinkInconsistencyDetails accessLinkInconsistency : accessLinkInconsistencies) {
                extendedInfo.add(new EliminationExtendedInfoAccessLinkInconsistency(accessLinkInconsistency));
            }
            if (!activeHoldRules.isEmpty()) {
                extendedInfo.add(new EliminationExtendedInfoHoldRule(new EliminationExtendedInfoHoldRuleDetails(activeHoldRules)));
            }
        }
        return new EliminationAnalysisResult(operationId, globalStatus, destroyableOriginatingAgencies, nonDestroyableOriginatingAgencies, extendedInfo);
    }

    private Set<String> listActiveHoldRuleIds(String unitId, List<InheritedRuleResponseModel> holdRules, LocalDate expirationDate) {
        return HoldRuleUtils.listActiveHoldRules(unitId, holdRules, expirationDate).stream().map(InheritedRuleResponseModel::getRuleId).collect(Collectors.toSet());
    }

    private EliminationGlobalStatus getGlobalStatus(Set<String> destroyableOriginatingAgencies, Set<String> nonDestroyableOriginatingAgencies, Set<String> conflictOnOriginatingAgencies, Set<String> activeHoldRules) {
        if (!conflictOnOriginatingAgencies.isEmpty()) {
            return EliminationGlobalStatus.CONFLICT;
        }
        if (destroyableOriginatingAgencies.isEmpty()) {
            return EliminationGlobalStatus.KEEP;
        }
        if (!activeHoldRules.isEmpty()) {
            return EliminationGlobalStatus.CONFLICT;
        }
        if (nonDestroyableOriginatingAgencies.isEmpty()) {
            return EliminationGlobalStatus.DESTROY;
        }
        return EliminationGlobalStatus.CONFLICT;
    }

    private boolean shouldKeepAccessToOriginatingAgency(String sp, Set<String> destroyableOriginatingAgencies, Set<String> nonDestroyableOriginatingAgencies) {
        return sp != null && destroyableOriginatingAgencies.contains(sp) && !nonDestroyableOriginatingAgencies.isEmpty();
    }

    private Map<String, EliminationAnalysisStatusForOriginatingAgency> analyzeAppraisalFinalActionByOriginatingAgency(Collection<InheritedRuleResponseModel> appraisalRules, Collection<InheritedPropertyResponseModel> appraisalProperties, LocalDate expirationDate) {
        Set originatingAgencies = Stream.concat(appraisalRules.stream(), appraisalProperties.stream()).map(BaseInheritedResponseModel::getOriginatingAgency).filter(Objects::nonNull).collect(Collectors.toSet());
        HashMap<String, EliminationAnalysisStatusForOriginatingAgency> statusForOriginatingAgency = new HashMap<String, EliminationAnalysisStatusForOriginatingAgency>();
        for (String originatingAgency : originatingAgencies) {
            List<InheritedRuleResponseModel> originatingAgencyRules = this.filterByOriginatingAgency(appraisalRules, originatingAgency);
            List<InheritedPropertyResponseModel> originatingAgencyProperties = this.filterByOriginatingAgency(appraisalProperties, originatingAgency);
            boolean destroyableForOriginatingAgency = this.isAppraisalDestroyable(originatingAgencyRules, originatingAgencyProperties, expirationDate);
            boolean conflictForOriginatingAgency = this.isAppraisalFinalActionConflict(originatingAgencyRules, originatingAgencyProperties, expirationDate, destroyableForOriginatingAgency);
            EliminationAnalysisStatusForOriginatingAgency status = EliminationAnalysisStatusForOriginatingAgency.getValue(destroyableForOriginatingAgency, conflictForOriginatingAgency);
            statusForOriginatingAgency.put(originatingAgency, status);
        }
        return statusForOriginatingAgency;
    }

    private List<EliminationExtendedInfoAccessLinkInconsistencyDetails> analyzeAppraisalAccessLinkInconsistencies(List<InheritedRuleResponseModel> appraisalRules, List<InheritedPropertyResponseModel> appraisalProperties, LocalDate expirationDate) {
        ArrayList<EliminationExtendedInfoAccessLinkInconsistencyDetails> accessLinkInconsistencies = new ArrayList<EliminationExtendedInfoAccessLinkInconsistencyDetails>();
        MultiValuedMap<String, InheritedRuleResponseModel> rulesByDirectParentId = this.groupByDirectParentId(appraisalRules);
        MultiValuedMap<String, InheritedPropertyResponseModel> propertiesByDirectParentId = this.groupByDirectParentId(appraisalProperties);
        for (String parentId : SetUtils.union((Set)rulesByDirectParentId.keySet(), (Set)propertiesByDirectParentId.keySet())) {
            Map<String, EliminationAnalysisStatusForOriginatingAgency> destroyableForParentId = this.analyzeAppraisalFinalActionByOriginatingAgency(rulesByDirectParentId.get((Object)parentId), propertiesByDirectParentId.get((Object)parentId), expirationDate);
            Set<String> destroyableOriginatingAgencies = this.filterByTargetStatus(destroyableForParentId, EliminationAnalysisStatusForOriginatingAgency.DESTROY);
            Set<String> nonDestroyableOriginatingAgencies = this.filterByTargetStatus(destroyableForParentId, EliminationAnalysisStatusForOriginatingAgency.KEEP);
            if (destroyableOriginatingAgencies.isEmpty() || nonDestroyableOriginatingAgencies.isEmpty()) continue;
            accessLinkInconsistencies.add(new EliminationExtendedInfoAccessLinkInconsistencyDetails(parentId, destroyableOriginatingAgencies, nonDestroyableOriginatingAgencies));
        }
        return accessLinkInconsistencies;
    }

    private <T extends BaseInheritedResponseModel> List<T> filterByOriginatingAgency(Collection<T> inheritedEntries, String originatingAgency) {
        return inheritedEntries.stream().filter(entry -> originatingAgency.equals(entry.getOriginatingAgency())).collect(Collectors.toList());
    }

    private <T extends BaseInheritedResponseModel> MultiValuedMap<String, T> groupByDirectParentId(List<T> inheritedEntries) {
        HashSetValuedHashMap response = new HashSetValuedHashMap();
        for (BaseInheritedResponseModel entry : inheritedEntries) {
            for (List path : entry.getPaths()) {
                if (path.size() < 2) continue;
                String directParentId = (String)path.get(1);
                response.put((Object)directParentId, (Object)entry);
            }
        }
        return response;
    }

    private Set<String> filterByTargetStatus(Map<String, EliminationAnalysisStatusForOriginatingAgency> statusForOriginatingAgency, EliminationAnalysisStatusForOriginatingAgency targetStatus) {
        return statusForOriginatingAgency.entrySet().stream().filter(entry -> targetStatus.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private boolean isAppraisalFinalActionConflict(List<InheritedRuleResponseModel> appraisalRules, List<InheritedPropertyResponseModel> appraisalProperties, LocalDate expirationDate, Boolean isDestroyableForOriginatingAgency) {
        if (isDestroyableForOriginatingAgency.booleanValue()) {
            return false;
        }
        List destroyIds = appraisalProperties.stream().filter(p -> "FinalAction".equals(p.getPropertyName())).filter(p -> VitamConstants.AppraisalRuleFinalAction.DESTROY.equals((Object)VitamConstants.AppraisalRuleFinalAction.fromValue((String)p.getPropertyValue().toString()))).map(BaseInheritedResponseModel::getUnitId).collect(Collectors.toList());
        if (destroyIds.isEmpty()) {
            return false;
        }
        return this.areAppraisalRuleEndDatesReached(appraisalRules, expirationDate);
    }

    private boolean isAppraisalDestroyable(List<InheritedRuleResponseModel> appraisalRules, List<InheritedPropertyResponseModel> appraisalProperties, LocalDate expirationDate) {
        if (!this.isAppraisalRuleFinalActionDestroy(appraisalProperties)) {
            return false;
        }
        return this.areAppraisalRuleEndDatesReached(appraisalRules, expirationDate);
    }

    private boolean isAppraisalRuleFinalActionDestroy(List<InheritedPropertyResponseModel> appraisalProperties) {
        List finalActions = appraisalProperties.stream().filter(p -> "FinalAction".equals(p.getPropertyName())).map(p -> (String)p.getPropertyValue()).map(VitamConstants.AppraisalRuleFinalAction::fromValue).collect(Collectors.toList());
        if (finalActions.isEmpty()) {
            return false;
        }
        return !finalActions.stream().anyMatch(arg_0 -> VitamConstants.AppraisalRuleFinalAction.KEEP.equals(arg_0));
    }

    private boolean areAppraisalRuleEndDatesReached(List<InheritedRuleResponseModel> appraisalRules, LocalDate expirationDate) {
        List endDates = appraisalRules.stream().map(InheritedRuleResponseModel::getEndDate).map(LocalDateUtil::parseDate).collect(Collectors.toList());
        if (endDates.isEmpty()) {
            return false;
        }
        if (endDates.stream().anyMatch(Objects::isNull)) {
            return false;
        }
        return !endDates.stream().anyMatch(expirationDate::isBefore);
    }
}

