/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.elimination;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationAnalysisService;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationUtils;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationAnalysisResult;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationEventDetails;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationGlobalStatus;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import org.apache.commons.io.FileUtils;

public class EliminationAnalysisPreparationHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EliminationAnalysisPreparationHandler.class);
    private static final String ELIMINATION_ANALYSIS_PREPARATION = "ELIMINATION_ANALYSIS_PREPARATION";
    private static final String COULD_NOT_PARSE_DATE_FROM_REQUEST = "Could not not parse date from request";
    private static final String COULD_NOT_PARSE_DSL_REQUEST = "Could not parse DSL request";
    private static final String UNITS_JSONL_FILE = "units.jsonl";
    private final MetaDataClientFactory metaDataClientFactory;
    private final EliminationAnalysisService eliminationAnalysisService;

    public EliminationAnalysisPreparationHandler() {
        this(MetaDataClientFactory.getInstance(), new EliminationAnalysisService());
    }

    @VisibleForTesting
    EliminationAnalysisPreparationHandler(MetaDataClientFactory metaDataClientFactory, EliminationAnalysisService eliminationAnalysisService) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.eliminationAnalysisService = eliminationAnalysisService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            EliminationRequestBody eliminationRequestBody = EliminationUtils.loadRequestJsonFromWorkspace(handler);
            this.process(eliminationRequestBody, param, handler);
            LOGGER.info("Elimination analysis preparation succeeded");
            EliminationEventDetails eventDetails = new EliminationEventDetails().setExpirationDate(eliminationRequestBody.getDate());
            return PluginHelper.buildItemStatus(ELIMINATION_ANALYSIS_PREPARATION, StatusCode.OK, eventDetails);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Elimination analysis preparation failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(ELIMINATION_ANALYSIS_PREPARATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    private void process(EliminationRequestBody eliminationRequestBody, WorkerParameters param, HandlerIO handler) throws ProcessingStatusException {
        LocalDate expirationDate = this.getExpirationDate(eliminationRequestBody);
        SelectMultiQuery request = this.getRequest(eliminationRequestBody.getDslRequest());
        File unitDistributionFile = null;
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            ScrollSpliterator<JsonNode> unitScrollSpliterator = ScrollSpliteratorHelper.getUnitWithInheritedRulesScrollSpliterator(request, client);
            SpliteratorIterator unitIterator = new SpliteratorIterator(unitScrollSpliterator);
            unitDistributionFile = handler.getNewLocalFile(UNITS_JSONL_FILE);
            try (JsonLineWriter unitWriter = new JsonLineWriter((OutputStream)new FileOutputStream(unitDistributionFile));){
                while (unitIterator.hasNext()) {
                    JsonNode unit = (JsonNode)unitIterator.next();
                    String unitId = unit.get(VitamFieldsHelper.id()).asText();
                    EliminationAnalysisResult eliminationAnalysisResult = EliminationUtils.computeEliminationAnalysisForUnitWithInheritedRules(unit, this.eliminationAnalysisService, param, expirationDate);
                    if (eliminationAnalysisResult.getGlobalStatus() == EliminationGlobalStatus.KEEP) continue;
                    JsonLineModel entry = new JsonLineModel(unitId, null, JsonHandler.toJsonNode((Object)eliminationAnalysisResult));
                    unitWriter.addEntry(entry);
                }
            }
            handler.transferFileToWorkspace(UNITS_JSONL_FILE, unitDistributionFile, true, false);
        }
        catch (InvalidParseOperationException | ProcessingException | IOException e) {
            try {
                throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate unit and/or object group distributions", e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(unitDistributionFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)unitDistributionFile);
    }

    private LocalDate getExpirationDate(EliminationRequestBody eliminationRequestBody) throws ProcessingStatusException {
        LocalDate expirationDate;
        try {
            expirationDate = LocalDate.parse(eliminationRequestBody.getDate());
        }
        catch (DateTimeParseException e) {
            EliminationEventDetails eventDetails = new EliminationEventDetails().setError(COULD_NOT_PARSE_DATE_FROM_REQUEST);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, COULD_NOT_PARSE_DATE_FROM_REQUEST, e);
        }
        return expirationDate;
    }

    private SelectMultiQuery getRequest(JsonNode dslRequest) throws ProcessingStatusException {
        try {
            SelectParserMultiple selectParser = new SelectParserMultiple();
            selectParser.parse(dslRequest);
            SelectMultiQuery request = selectParser.getRequest();
            request.resetUsageProjection();
            request.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.originatingAgency(), VitamFieldsHelper.unitType()});
            return request;
        }
        catch (InvalidParseOperationException e) {
            EliminationEventDetails eventDetails = new EliminationEventDetails().setError(COULD_NOT_PARSE_DSL_REQUEST);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, COULD_NOT_PARSE_DSL_REQUEST, e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return ELIMINATION_ANALYSIS_PREPARATION;
    }
}

