/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.elimination;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.EliminationActionUnitReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.utils.BufferedConsumer;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationAnalysisService;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationUtils;
import fr.gouv.vitam.worker.core.plugin.elimination.model.EliminationEventDetails;
import fr.gouv.vitam.worker.core.plugin.elimination.report.EliminationActionReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;

public class EliminationActionUnitPreparationHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EliminationActionUnitPreparationHandler.class);
    private static final String ELIMINATION_ACTION_UNIT_PREPARATION = "ELIMINATION_ACTION_UNIT_PREPARATION";
    static final String DATE_REQUEST_IN_FUTURE = "The elimination date cannot be after current date";
    private static final String COULD_NOT_PARSE_DATE_FROM_REQUEST = "Could not not parse date from request";
    private static final String COULD_NOT_PARSE_DSL_REQUEST = "Could not parse DSL request";
    static final String REQUEST_JSON = "request.json";
    static final String UNITS_TO_DELETE_FILE = "units_to_delete.jsonl";
    public static final String PERSISTENT_IDENTIFIER = "PersistentIdentifier";
    private final MetaDataClientFactory metaDataClientFactory;
    private final EliminationAnalysisService eliminationAnalysisService;
    private final EliminationActionReportService eliminationActionReportService;

    public EliminationActionUnitPreparationHandler() {
        this(MetaDataClientFactory.getInstance(), new EliminationAnalysisService(), new EliminationActionReportService());
    }

    @VisibleForTesting
    EliminationActionUnitPreparationHandler(MetaDataClientFactory metaDataClientFactory, EliminationAnalysisService eliminationAnalysisService, EliminationActionReportService eliminationActionReportService) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.eliminationAnalysisService = eliminationAnalysisService;
        this.eliminationActionReportService = eliminationActionReportService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            EliminationRequestBody eliminationRequestBody = EliminationUtils.loadRequestJsonFromWorkspace(handler);
            ItemStatus itemStatus = this.process(eliminationRequestBody, param, handler);
            LOGGER.info("Elimination action unit preparation succeeded");
            return itemStatus;
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Elimination action unit preparation failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(ELIMINATION_ACTION_UNIT_PREPARATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    /*
     * Exception decompiling
     */
    private ItemStatus process(EliminationRequestBody eliminationRequestBody, WorkerParameters param, HandlerIO handler) throws ProcessingStatusException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [30[UNCONDITIONALDOLOOP]], but top level block is 33[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BufferedConsumer<EliminationActionUnitReportEntry> createReportAppender(String processId) {
        return new BufferedConsumer(VitamConfiguration.getBatchSize(), entries -> {
            try {
                this.eliminationActionReportService.appendEntries(processId, entries);
            }
            catch (ProcessingStatusException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String getField(JsonNode unit, String field) {
        return unit.has(field) ? unit.get(field).asText() : null;
    }

    private LocalDate getAndValidateExpirationDate(EliminationRequestBody eliminationRequestBody) throws ProcessingStatusException {
        LocalDate expirationDate;
        try {
            expirationDate = LocalDate.parse(eliminationRequestBody.getDate());
        }
        catch (DateTimeParseException e) {
            EliminationEventDetails eventDetails = new EliminationEventDetails().setError(COULD_NOT_PARSE_DATE_FROM_REQUEST);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, COULD_NOT_PARSE_DATE_FROM_REQUEST, e);
        }
        LocalDate today = LocalDate.now();
        if (expirationDate.isAfter(today)) {
            EliminationEventDetails eventDetails = new EliminationEventDetails().setExpirationDate(eliminationRequestBody.getDate()).setError(DATE_REQUEST_IN_FUTURE);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, "The elimination date cannot be after current date " + expirationDate);
        }
        return expirationDate;
    }

    private SelectMultiQuery getRequest(JsonNode dslRequest) throws ProcessingStatusException {
        try {
            SelectParserMultiple selectParser = new SelectParserMultiple();
            selectParser.parse(dslRequest);
            SelectMultiQuery request = selectParser.getRequest();
            request.resetOrderByFilter();
            request.addOrderByDescFilter(new String[]{VitamFieldsHelper.max()});
            request.resetUsageProjection();
            request.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.object(), VitamFieldsHelper.initialOperation(), VitamFieldsHelper.originatingAgency(), VitamFieldsHelper.max(), VitamFieldsHelper.storage(), VitamFieldsHelper.unitType()});
            request.addUsedProjection(new String[]{PERSISTENT_IDENTIFIER});
            request.addUsedProjection((String[])EliminationUtils.getReportExtraFields().toArray(String[]::new));
            return request;
        }
        catch (InvalidParseOperationException e) {
            EliminationEventDetails eventDetails = new EliminationEventDetails().setError(COULD_NOT_PARSE_DSL_REQUEST);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, COULD_NOT_PARSE_DSL_REQUEST, e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return ELIMINATION_ACTION_UNIT_PREPARATION;
    }
}

