/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.elimination;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.report.EliminationActionReportService;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public class EliminationActionFinalizationHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EliminationActionFinalizationHandler.class);
    private static final String ELIMINATION_ACTION_FINALIZATION = "ELIMINATION_ACTION_FINALIZATION";
    private final EliminationActionReportService eliminationActionReportService;
    private final PurgeReportService purgeReportService;

    public EliminationActionFinalizationHandler() {
        this(new EliminationActionReportService(), new PurgeReportService());
    }

    @VisibleForTesting
    EliminationActionFinalizationHandler(EliminationActionReportService eliminationActionReportService, PurgeReportService purgeReportService) {
        this.eliminationActionReportService = eliminationActionReportService;
        this.purgeReportService = purgeReportService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.eliminationActionReportService.cleanupReport(param.getContainerName());
            this.purgeReportService.cleanupReport(param.getContainerName());
            LOGGER.info("Elimination action finalization succeeded");
            return PluginHelper.buildItemStatus(ELIMINATION_ACTION_FINALIZATION, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Elimination action finalization failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(ELIMINATION_ACTION_FINALIZATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return ELIMINATION_ACTION_FINALIZATION;
    }
}

