/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.dip;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.common.CompressInformation;

public class StoreExports
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StoreExports.class);
    private static final String STORE_DIP = "STORE_DIP";
    private static final String TRANSFER_DIP = "TRANSFER_DIP";
    static final String ARCHIVE_TRANSFER = "ARCHIVE_TRANSFER";
    static final String CONTENT = "Content";
    static final String DIP_CONTAINER = "DIP";
    public static final String TRANSFER_CONTAINER = "TRANSFER";
    private static final String JSONL_EXTENSION = ".jsonl";
    private static final String DIGEST = "SystemMessageDigest";
    private static final String DIGEST_TYPE = "SystemAlgorithm";
    private final StorageClientFactory storageClientFactory;

    public StoreExports() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    StoreExports(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) throws ProcessingException {
        String statusAction;
        String container;
        if (this.isTransferWorkflow(params)) {
            container = TRANSFER_CONTAINER;
            statusAction = TRANSFER_DIP;
        } else {
            container = DIP_CONTAINER;
            statusAction = STORE_DIP;
        }
        ItemStatus itemStatus = new ItemStatus(statusAction);
        try {
            String tenantFolder = Integer.toString(VitamThreadUtils.getVitamSession().getTenantId());
            String zipFileName = params.getContainerName();
            if (this.isTransferWorkflow(params) && handler.isExistingFileInWorkspace(params.getContainerName() + JSONL_EXTENSION)) {
                this.storeReportToOffers(params.getContainerName());
            }
            try (WorkspaceClient workspaceClient = handler.getWorkspaceClientFactory().getClient();){
                if (workspaceClient.isExistingObject(handler.getContainerName(), "manifest.xml")) {
                    this.zipWorkspace(workspaceClient, handler.getContainerName(), tenantFolder, zipFileName, container);
                    ObjectNode eventDetailDataNode = JsonHandler.createObjectNode();
                    eventDetailDataNode.put(DIGEST, this.computeObjectDigest(handler, container, tenantFolder, zipFileName));
                    eventDetailDataNode.put(DIGEST_TYPE, VitamConfiguration.getDefaultDigestType().getName());
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)eventDetailDataNode));
                }
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException | ContentAddressableStorageException e) {
            throw new ProcessingException(e);
        }
        return new ItemStatus(statusAction).setItemsStatus(statusAction, itemStatus);
    }

    private boolean isTransferWorkflow(WorkerParameters params) {
        return params.getWorkflowIdentifier().equals(ARCHIVE_TRANSFER);
    }

    private void storeReportToOffers(String container) throws StorageAlreadyExistsClientException, StorageNotFoundClientException, StorageServerClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(container);
            description.setWorkspaceObjectURI(container + JSONL_EXTENSION);
            storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.REPORT, container + JSONL_EXTENSION, description);
        }
    }

    private void zipWorkspace(WorkspaceClient workspaceClient, String operationId, String outputDir, String outputFile, String container) throws ContentAddressableStorageException {
        LOGGER.debug("Try to compress into workspace...");
        workspaceClient.createFolder(operationId, CONTENT);
        workspaceClient.createContainer(container);
        workspaceClient.createFolder(container, outputDir);
        CompressInformation compressInformation = new CompressInformation();
        compressInformation.getFiles().add("manifest.xml");
        compressInformation.getFiles().add(CONTENT);
        compressInformation.setOutputFile(outputDir + "/" + outputFile);
        compressInformation.setOutputContainer(container);
        workspaceClient.compress(operationId, compressInformation);
    }

    private String computeObjectDigest(HandlerIO handler, String container, String tenantFolder, String fileName) throws ContentAddressableStorageException {
        LOGGER.debug("Compute object digest from workspace...");
        try (WorkspaceClient workspaceClient = handler.getWorkspaceClientFactory().getClient();){
            String string = workspaceClient.computeObjectDigest(container, tenantFolder + "/" + fileName, VitamConfiguration.getDefaultDigestType());
            return string;
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

