/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.dip;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.accesslog.AccessLogInfoModel;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.core.Response;

public class PutBinaryOnWorkspace
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PutBinaryOnWorkspace.class);
    private static final String PUT_BINARY_ON_WORKSPACE = "PUT_BINARY_ON_WORKSPACE";
    static final int GUID_TO_INFO_RANK = 0;
    public static final int NUMBER_OF_RETRY = 3;
    private final StorageClientFactory storageClientFactory;

    public PutBinaryOnWorkspace() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    PutBinaryOnWorkspace(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        Map guidToPath;
        ItemStatus itemStatus = new ItemStatus(PUT_BINARY_ON_WORKSPACE);
        try (FileInputStream inputStream = new FileInputStream((File)handler.getInput(0));){
            guidToPath = JsonHandler.getMapFromInputStream((InputStream)inputStream);
        }
        catch (InvalidParseOperationException | IOException e) {
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(PUT_BINARY_ON_WORKSPACE).setItemsStatus(PUT_BINARY_ON_WORKSPACE, itemStatus);
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.transferFile(param, handler, guidToPath);
                itemStatus.increment(StatusCode.OK);
                return new ItemStatus(PUT_BINARY_ON_WORKSPACE).setItemsStatus(PUT_BINARY_ON_WORKSPACE, itemStatus);
            }
            catch (ProcessingException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException e) {
                LOGGER.error(String.format("unable to transfer file from offer to workspace, retry: %d", i), e);
                continue;
            }
        }
        itemStatus.increment(StatusCode.FATAL);
        return new ItemStatus(PUT_BINARY_ON_WORKSPACE).setItemsStatus(PUT_BINARY_ON_WORKSPACE, itemStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferFile(WorkerParameters param, HandlerIO handler, Map<String, Object> guidToInfo) throws ProcessingException, StorageNotFoundException, StorageServerClientException, StorageUnavailableDataFromAsyncOfferClientException {
        Response response = null;
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            Map objectInfo = (Map)guidToInfo.get(param.getObjectName());
            String strategyId = (String)objectInfo.get("strategyId");
            Boolean mustLog = Boolean.valueOf((String)param.getMapParameters().get(WorkerParameterName.mustLogAccessOnObject));
            AccessLogInfoModel logInfo = AccessLogUtils.getInfoFromWorkerInfo((Map)objectInfo, (VitamSession)VitamThreadUtils.getVitamSession(), (Boolean)mustLog);
            response = storageClient.getContainerAsync(strategyId, param.getObjectName(), DataCategory.OBJECT, logInfo);
            handler.transferInputStreamToWorkspace((String)objectInfo.get("FILE_NAME"), (InputStream)response.getEntity(), null, false);
        }
        catch (Throwable throwable) {
            StreamUtils.consumeAnyEntityAndClose(response);
            throw throwable;
        }
        StreamUtils.consumeAnyEntityAndClose((Response)response);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

