/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.dip;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.ProcessingRetryAsyncException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.common.CheckResourceAvailability;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ExportCheckResourceAvailability
extends CheckResourceAvailability {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ExportCheckResourceAvailability.class);
    public static final String PLUGIN_NAME = "EXPORT_CHECK_RESOURCE_AVAILABILITY";
    static final int GUID_TO_INFO_RANK = 0;

    public ExportCheckResourceAvailability() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public ExportCheckResourceAvailability(StorageClientFactory storage) {
        super(storage);
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            Map<AccessRequestContext, List<String>> entries = this.extractResources(workerParameters, handler);
            this.checkResourcesAvailability(entries, DataCategory.OBJECT);
            return IntStream.range(0, workerParameters.getObjectNameList().size()).mapToObj(index -> PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of(String.format("%s executed", PLUGIN_NAME)))).collect(Collectors.toList());
        }
        catch (ProcessingRetryAsyncException prae) {
            LOGGER.info("Some resources where not available");
            throw prae;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private Map<AccessRequestContext, List<String>> extractResources(WorkerParameters workerParameters, HandlerIO handler) throws IOException, InvalidParseOperationException {
        handler.setCurrentObjectId((String)workerParameters.getObjectNameList().get(0));
        try (FileInputStream inputStream = new FileInputStream((File)handler.getInput(0));){
            Map guidToInfo = JsonHandler.getMapFromInputStream((InputStream)inputStream);
            HashMap<AccessRequestContext, List> entries = new HashMap<AccessRequestContext, List>();
            for (String objectId : workerParameters.getObjectNameList()) {
                Map objectInfo = (Map)guidToInfo.get(objectId);
                String strategyId = (String)objectInfo.get("strategyId");
                entries.computeIfAbsent(new AccessRequestContext(strategyId, null), x -> new ArrayList()).add(objectId);
            }
            HashMap<AccessRequestContext, List> hashMap = entries;
            return hashMap;
        }
    }
}

