/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.dip;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterable;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.collection.CloseableIteratorUtils;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.ExportException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.dip.BinarySizePlatformThreshold;
import fr.gouv.vitam.common.model.dip.BinarySizeTenantThreshold;
import fr.gouv.vitam.common.model.dip.QualifierVersion;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.dip.ArchiveUnitExportGraphModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateManifest
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CreateManifest.class);
    static final int MANIFEST_XML_RANK = 0;
    static final int GUID_TO_INFO_RANK = 1;
    static final int BINARIES_RANK = 2;
    static final int REPORT = 3;
    public static final String PLUGIN_NAME = "CREATE_MANIFEST";
    private static final int DEFAULT_MAX_ELEMENT_IN_QUERY = 1000;
    private static final String REASON_FIELD = "Reason";
    private static final String JSONL_EXTENSION = ".jsonl";
    public static final String UNITS_JSONL_FILE = "units.jsonl";
    private final int maxElementsInQuery;
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory = LogbookLifeCyclesClientFactory.getInstance();
    private final ObjectMapper objectMapper;

    public CreateManifest() {
        this(MetaDataClientFactory.getInstance(), 1000);
    }

    @VisibleForTesting
    CreateManifest(MetaDataClientFactory metaDataClientFactory) {
        this(metaDataClientFactory, 1000);
    }

    @VisibleForTesting
    CreateManifest(MetaDataClientFactory metaDataClientFactory, int maxElementsInQuery) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.objectMapper = VitamObjectMapper.getDeserializationObjectMapper();
        this.maxElementsInQuery = maxElementsInQuery;
    }

    /*
     * Exception decompiling
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File exportUnits(HandlerIO handlerIO, ExportRequest exportRequest, MetaDataClient client) throws IOException, InvalidParseOperationException, ProcessingStatusException {
        File unitsJsonl = handlerIO.getNewLocalFile(UNITS_JSONL_FILE);
        try (JsonLineWriter unitsJsonlWriter = new JsonLineWriter((OutputStream)new FileOutputStream(unitsJsonl));){
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(exportRequest.getDslRequest());
            SelectMultiQuery request = parser.getRequest();
            request.resetUsedProjection();
            ScrollSpliterator<JsonNode> unitsToExportScrollSpliterator = ScrollSpliteratorHelper.createUnitScrollSplitIterator(client, request);
            this.checkEmptinessSelectedUnits(unitsToExportScrollSpliterator.estimateSize());
            for (JsonNode unit : unitsToExportScrollSpliterator) {
                unitsJsonlWriter.addEntry((Object)unit);
            }
        }
        return unitsJsonl;
    }

    private <T> CloseableIterable<T> listUnits(File unitsJsonl, TypeReference<T> typeReference) throws IOException {
        return CloseableIteratorUtils.toCloseableIterable((CloseableIterator)new JsonLineGenericIterator((InputStream)new FileInputStream(unitsJsonl), typeReference));
    }

    private void keepOnlySelectedQualifiers(ObjectGroupResponse objectGroup, Map<DataObjectVersionType, Set<QualifierVersion>> dataObjectVersions, AccessContractModel accessContract, boolean exportWithoutObjects) {
        List qualifiers = objectGroup.getQualifiers();
        if (Boolean.FALSE.equals(accessContract.isEveryDataObjectVersion())) {
            qualifiers.removeIf(qualifier -> !accessContract.getDataObjectVersion().contains(qualifier.getQualifier()));
        }
        if (exportWithoutObjects) {
            qualifiers.clear();
        } else if (!dataObjectVersions.isEmpty()) {
            qualifiers.removeIf(qualifier -> !dataObjectVersions.containsKey(DataObjectVersionType.fromName((String)qualifier.getQualifier())));
            qualifiers.forEach(qualifier -> {
                List versionsToExport = dataObjectVersions.getOrDefault(DataObjectVersionType.fromName((String)qualifier.getQualifier()), Collections.emptySet()).stream().flatMap(version -> this.getVersions((QualifiersModel)qualifier, (QualifierVersion)version).stream()).distinct().sorted(Comparator.comparing(VersionsModel::getVersion)).collect(Collectors.toList());
                qualifier.setVersions(versionsToExport);
            });
        }
    }

    private List<VersionsModel> getVersions(QualifiersModel qualifier, QualifierVersion wantedVersion) {
        switch (wantedVersion) {
            case FIRST: {
                return this.getFirstVersion(qualifier).map(List::of).orElse(Collections.emptyList());
            }
            case LAST: {
                return this.getLastVersion(qualifier).map(List::of).orElse(Collections.emptyList());
            }
            case ALL: {
                return qualifier.getVersions();
            }
        }
        return Collections.emptyList();
    }

    private AccessContractModel getAccessContractModel(AdminManagementClient adminManagementClient) throws ProcessingException {
        AccessContractModel accessContractModel = VitamThreadUtils.getVitamSession().getContract();
        if (accessContractModel == null) {
            Select accessContractSelect = new Select();
            try {
                CompareQuery query = QueryHelper.eq((String)"Identifier", (String)VitamThreadUtils.getVitamSession().getContractId());
                accessContractSelect.setQuery((Query)query);
                accessContractModel = (AccessContractModel)((RequestResponseOK)adminManagementClient.findAccessContracts((JsonNode)accessContractSelect.getFinalSelect())).getResults().get(0);
            }
            catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientServerException e) {
                throw new ProcessingException(e.getMessage(), e.getCause());
            }
        }
        return accessContractModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkSize(ItemStatus itemStatus, long exportSize, long threshold, int tenant) throws ExportException {
        if (exportSize > threshold) {
            throw new ExportException(String.format("export size exceeds threshold. \n Export Size = [%d]\n Threshold = [%d]", exportSize, threshold));
        }
        Optional<BinarySizeTenantThreshold> first = VitamConfiguration.getBinarySizeTenantThreshold().stream().filter(e -> e.getTenant() == tenant).findFirst();
        if (first.isPresent()) {
            if (exportSize <= first.get().getThreshold()) return;
            if (!first.get().isAuthorized()) throw new ExportException(String.format("export size exceeds tenant threshold. \n Export Size = [%d]\n Tenant Threshold = [%d]", exportSize, threshold));
            this.updateItemStatus(itemStatus, exportSize, threshold, "export size exceeds tenant threshold.\n Export Size = [%d]\n Tenant Threshold = [%d]");
            return;
        } else {
            if (exportSize <= VitamConfiguration.getBinarySizePlatformThreshold().getThreshold()) return;
            this.updateItemStatus(itemStatus, exportSize, threshold, "export size exceeds platform threshold.\n Export Size = [%d]\n Platform Threshold = [%d]");
        }
    }

    private void updateItemStatus(ItemStatus itemStatus, long exportSize, long threshold, String s) {
        itemStatus.increment(StatusCode.WARNING);
        ObjectNode infoNode = JsonHandler.createObjectNode();
        infoNode.put(REASON_FIELD, String.format(s, exportSize, threshold));
        String evDetData = JsonHandler.unprettyPrint((Object)infoNode);
        itemStatus.setEvDetailData(evDetData);
    }

    private long retrieveRelevantThreshold(Long threshold, int tenant) {
        if (threshold != null) {
            return threshold;
        }
        return VitamConfiguration.getBinarySizeTenantThreshold().stream().filter(e -> e.getTenant() == tenant).findFirst().map(BinarySizePlatformThreshold::getThreshold).orElseGet(() -> VitamConfiguration.getBinarySizePlatformThreshold().getThreshold());
    }

    private Optional<VersionsModel> getLastVersion(QualifiersModel qualifier) {
        return qualifier.getVersions().stream().max(Comparator.comparing(VersionsModel::getVersion));
    }

    private Optional<VersionsModel> getFirstVersion(QualifiersModel qualifier) {
        return qualifier.getVersions().stream().min(Comparator.comparing(VersionsModel::getVersion));
    }

    private void checkEmptinessSelectedUnits(long total) throws ProcessingStatusException {
        if (total == 0L) {
            ObjectNode infoNode = JsonHandler.createObjectNode();
            infoNode.put(REASON_FIELD, "the DSL query has no result");
            throw new ProcessingStatusException(StatusCode.KO, infoNode, "Empty result list");
        }
    }

    private void prepareGraphCreation(ListMultimap<String, String> unitIdToChildUnitIds, Set<String> originatingAgencies, Map<String, String> unitIdToObjectGroupId, ArchiveUnitExportGraphModel unit, String sedaVersionToExport) throws ExportException {
        if (!SupportedSedaVersions.isSedaVersionsCompatible((String)unit.getSedaVersion(), (String)sedaVersionToExport)) {
            String errorMsg = "Incompatible seda version to export (" + sedaVersionToExport + ") for unit : " + unit.getId();
            throw new ExportException(errorMsg);
        }
        for (String parentUnitId : unit.getParentUnitIds()) {
            unitIdToChildUnitIds.put((Object)parentUnitId, (Object)unit.getId());
        }
        if (unit.getOriginatingAgency() != null) {
            originatingAgencies.add(unit.getOriginatingAgency());
        }
        if (unit.getObjectGroupId() != null) {
            unitIdToObjectGroupId.put(unit.getId(), unit.getObjectGroupId());
        }
    }

    private void storeBinaryInformationOnWorkspace(HandlerIO handlerIO, Map<String, JsonNode> maps) throws ProcessingException {
        File guidToInfo = handlerIO.getNewLocalFile(handlerIO.getOutput(1).getPath());
        File binaryListFile = handlerIO.getNewLocalFile(handlerIO.getOutput(2).getPath());
        try {
            JsonHandler.writeAsFile(maps, (File)guidToInfo);
            JsonHandler.writeAsFile(maps.keySet(), (File)binaryListFile);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException((Throwable)e);
        }
        handlerIO.addOutputResult(1, (Object)guidToInfo, true, false);
        handlerIO.addOutputResult(2, (Object)binaryListFile, true, false);
    }

    private ObjectNode getUpdateQuery(List<String> opts) throws InvalidParseOperationException, InvalidCreateOperationException {
        HashMap<String, JsonNode> action = new HashMap<String, JsonNode>();
        UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
        action.put(VitamFieldsHelper.opts(), JsonHandler.toJsonNode(opts));
        SetAction setOPTS = new SetAction(action);
        updateMultiQuery.addActions(new Action[]{setOPTS});
        return updateMultiQuery.getFinalUpdateById();
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    private static /* synthetic */ JsonNode lambda$execute$5(JsonNode node) {
        return node.get(0);
    }

    private static /* synthetic */ JsonNode lambda$execute$4(JsonNode r) {
        return r.get("$results");
    }

    private static /* synthetic */ boolean lambda$execute$3(Set exportedObjectGroupIds, Map.Entry entry) {
        return exportedObjectGroupIds.contains(entry.getValue());
    }

    private static /* synthetic */ String[] lambda$execute$2(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ void lambda$execute$1(ArrayListMultimap list1, ArrayListMultimap list2) {
        list1.putAll((Multimap)list2);
    }

    private static /* synthetic */ void lambda$execute$0(ArrayListMultimap map, Map.Entry entry) {
        map.put((Object)((String)entry.getValue()), (Object)((String)entry.getKey()));
    }
}

