/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.deleteGotVersions.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.ObjectGroupToDeleteReportEntry;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.StoreMetaDataObjectGroupActionPlugin;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.List;

public class DeleteGotVersionsStoreMetadataAndLfcPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DeleteGotVersionsStoreMetadataAndLfcPlugin.class);
    private static final String PLUGIN_NAME = "STORE_METADATA_AND_LFC_WORKSPACE";
    private final StoreMetaDataObjectGroupActionPlugin storeMetaDataObjectGroupActionPlugin;

    public DeleteGotVersionsStoreMetadataAndLfcPlugin() {
        this(new StoreMetaDataObjectGroupActionPlugin());
    }

    @VisibleForTesting
    public DeleteGotVersionsStoreMetadataAndLfcPlugin(StoreMetaDataObjectGroupActionPlugin storeMetaDataObjectGroupActionPlugin) {
        this.storeMetaDataObjectGroupActionPlugin = storeMetaDataObjectGroupActionPlugin;
    }

    public List<ItemStatus> executeList(WorkerParameters params, HandlerIO handler) {
        LOGGER.debug("Starting DeleteGotVersionsStoragePlugin... ");
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        List gotIds = params.getObjectNameList();
        List objectGroupToDeleteReportEntriesNodes = params.getObjectMetadataList();
        ArrayList<String> gotsToStore = new ArrayList<String>();
        try {
            for (int i = 0; i < objectGroupToDeleteReportEntriesNodes.size(); ++i) {
                StatusCode statusCode = StatusCode.OK;
                List objectGroupToDeleteReportEntries = (List)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)objectGroupToDeleteReportEntriesNodes.get(i)), (TypeReference)new TypeReference<List<ObjectGroupToDeleteReportEntry>>(){});
                if (objectGroupToDeleteReportEntries.stream().anyMatch(elmt -> elmt.getStatus().equals((Object)StatusCode.WARNING))) {
                    statusCode = StatusCode.WARNING;
                }
                if (objectGroupToDeleteReportEntries.stream().anyMatch(elmt -> elmt.getStatus().equals((Object)StatusCode.OK))) {
                    gotsToStore.add((String)gotIds.get(i));
                }
                itemStatuses.add(PluginHelper.buildItemStatus(PLUGIN_NAME, statusCode));
            }
            this.storeMetaDataObjectGroupActionPlugin.storeDocumentsWithLfc(params, handler, gotsToStore);
        }
        catch (VitamException e) {
            String errorMsg = "No objectGroupToDelete entries found for Object group in distribution file.";
            ObjectNode error = JsonHandler.createObjectNode().put("error", "No objectGroupToDelete entries found for Object group in distribution file.");
            itemStatuses.add(PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error));
        }
        return itemStatuses;
    }
}

