/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.deleteGotVersions.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.ObjectGroupToDeleteReportEntry;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.VersionsModelCustomized;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DeleteGotVersionsStoragePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DeleteGotVersionsStoragePlugin.class);
    private static final String PLUGIN_NAME = "DELETE_GOT_VERSIONS_STORAGE";
    private static final String PHYSICAL_MASTER = "PhysicalMaster";
    private final StorageClientFactory storageClientFactory;

    public DeleteGotVersionsStoragePlugin() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public DeleteGotVersionsStoragePlugin(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters param, HandlerIO handler) {
        LOGGER.debug("Starting DeleteGotVersionsStoragePlugin... ");
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        List gotIds = param.getObjectNameList();
        List objectGroupToDeleteReportEntriesNodes = param.getObjectMetadataList();
        for (int i = 0; i < objectGroupToDeleteReportEntriesNodes.size(); ++i) {
            try {
                List objectGroupToDeleteReportEntries = (List)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)objectGroupToDeleteReportEntriesNodes.get(i)), (TypeReference)new TypeReference<List<ObjectGroupToDeleteReportEntry>>(){});
                itemStatuses.add(this.processDeleteGotVersionsStorage(objectGroupToDeleteReportEntries));
                continue;
            }
            catch (InvalidParseOperationException e) {
                String errorMsg = String.format("No objectGroupToDelete entries found for Object group %s in distirubution file.", gotIds.get(i));
                ObjectNode error = JsonHandler.createObjectNode().put("error", errorMsg);
                itemStatuses.add(PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error));
            }
        }
        return itemStatuses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemStatus processDeleteGotVersionsStorage(List<ObjectGroupToDeleteReportEntry> objectGroupToDeleteReportEntries) {
        StatusCode statusCode = StatusCode.OK;
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            List versionsToDelete222;
            if (objectGroupToDeleteReportEntries.stream().anyMatch(elmt -> elmt.getStatus().equals((Object)StatusCode.WARNING))) {
                statusCode = StatusCode.WARNING;
            }
            if ((versionsToDelete222 = objectGroupToDeleteReportEntries.stream().filter(elmt -> elmt.getStatus().equals((Object)StatusCode.OK)).map(ObjectGroupToDeleteReportEntry::getDeletedVersions).flatMap(Collection::stream).collect(Collectors.toList())).isEmpty()) {
                ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.WARNING);
                return itemStatus;
            }
            for (VersionsModelCustomized versionToDelete : versionsToDelete222) {
                if (versionToDelete.getDataObjectVersion().startsWith(PHYSICAL_MASTER)) continue;
                storageClient.delete(versionToDelete.getStrategyId(), DataCategory.OBJECT, versionToDelete.getId());
            }
            ItemStatus throwable = PluginHelper.buildItemStatus(PLUGIN_NAME, statusCode);
            return throwable;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Delete got versions from Offer failed with status [%s]", StatusCode.FATAL), (Throwable)e);
            ObjectNode error = JsonHandler.createObjectNode().put("error", e.getMessage());
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error);
        }
    }
}

