/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.deleteGotVersions.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.batch.report.model.entry.DeleteGotVersionsReportEntry;
import fr.gouv.vitam.batch.report.model.entry.ObjectGroupToDeleteReportEntry;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DeleteGotVersionsRequest;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModelCustomized;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.deleteGotVersions.handlers.UnitsByGotModel;
import fr.gouv.vitam.worker.core.plugin.deleteGotVersions.services.DeleteGotVersionsReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DeleteGotVersionsPreparationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DeleteGotVersionsPreparationPlugin.class);
    private static final String PLUGIN_NAME = "DELETE_GOT_VERSIONS_PREPARATION";
    public static final String FIRST_BINARY_MASTER = DataObjectVersionType.BINARY_MASTER.getName() + "_1";
    public static final String FIRST_PHYSICAL_MASTER = DataObjectVersionType.PHYSICAL_MASTER.getName() + "_1";
    public static final String DISTRIBUTION_FILE_OG = "distributionFileOG.jsonl";
    private final MetaDataClientFactory metaDataClientFactory;
    private final DeleteGotVersionsReportService reportService;

    public DeleteGotVersionsPreparationPlugin() {
        this(MetaDataClientFactory.getInstance(), new DeleteGotVersionsReportService());
    }

    @VisibleForTesting
    public DeleteGotVersionsPreparationPlugin(MetaDataClientFactory metaDataClientFactory, DeleteGotVersionsReportService reportService) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.reportService = reportService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            DeleteGotVersionsRequest deleteGotVersionsRequest222 = this.loadRequest(handler);
            Pair<StatusCode, String> requestValidation = this.validateRequest(deleteGotVersionsRequest222);
            if (((StatusCode)requestValidation.getLeft()).isGreaterOrEqualToWarn()) {
                ObjectNode errorNode = JsonHandler.createObjectNode();
                errorNode.put("error", (String)requestValidation.getRight());
                ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, (StatusCode)requestValidation.getLeft(), errorNode);
                return itemStatus;
            }
            InputStream unitsByGotInputStream = PluginHelper.createUnitsByGotFile(metaDataClient, deleteGotVersionsRequest222, handler);
            this.createObjectGroupDistributionFile(handler, deleteGotVersionsRequest222, param, unitsByGotInputStream, metaDataClient);
            ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK);
            return itemStatus;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Delete got versions preparation failed with status [%s]", StatusCode.FATAL), (Throwable)e);
            ObjectNode error = JsonHandler.createObjectNode().put("error", e.getMessage());
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error);
        }
    }

    private void createObjectGroupDistributionFile(HandlerIO handler, DeleteGotVersionsRequest deleteGotVersionsRequest, WorkerParameters param, InputStream unitsByGotInputStream, MetaDataClient metaDataClient) throws VitamException, ProcessingStatusException, IOException {
        File objectGroupsIdsFile = handler.getNewLocalFile("object_groups_to_update.jsonl");
        try (FileOutputStream outputStream = new FileOutputStream(objectGroupsIdsFile);
             JsonLineGenericIterator jsonLineIterator = new JsonLineGenericIterator(unitsByGotInputStream, (TypeReference)new TypeReference<JsonNode>(){});
             JsonLineWriter writer = new JsonLineWriter((OutputStream)outputStream);){
            UnmodifiableIterator jsonLineIteratorPartition = Iterators.partition((Iterator)jsonLineIterator, (int)VitamConfiguration.getBatchSize());
            while (jsonLineIteratorPartition.hasNext()) {
                List unitsByGot = JsonHandler.getFromJsonNodeList((List)((List)jsonLineIteratorPartition.next()), (TypeReference)new TypeReference<UnitsByGotModel>(){});
                Map<String, Set> unitsByGotConvertedMap = unitsByGot.stream().collect(Collectors.toMap(UnitsByGotModel::getGotId, UnitsByGotModel::getUnitIds));
                String[] gotIds = (String[])unitsByGot.stream().map(UnitsByGotModel::getGotId).toArray(String[]::new);
                Map<String, ObjectGroupResponse> objectGroupRowsPartition = PluginHelper.getObjectGroups(gotIds, metaDataClient);
                if (objectGroupRowsPartition == null || objectGroupRowsPartition.isEmpty()) {
                    throw new IllegalStateException("No objects Group found in database!");
                }
                HashMap<Pair<String, Set<String>>, List<ObjectGroupToDeleteReportEntry>> objectGroupRowsForReport = new HashMap<Pair<String, Set<String>>, List<ObjectGroupToDeleteReportEntry>>();
                objectGroupRowsPartition.forEach((gotId, objectGroupResponse) -> {
                    List<ObjectGroupToDeleteReportEntry> gotWIthDetailsForDistribution = this.generateGotWithDetails((ObjectGroupResponse)objectGroupResponse, deleteGotVersionsRequest);
                    objectGroupRowsForReport.put(Pair.of((Object)gotId, (Object)((Set)unitsByGotConvertedMap.get(gotId))), gotWIthDetailsForDistribution);
                    try {
                        JsonLineModel jsonLineModel = new JsonLineModel(gotId, null, JsonHandler.toJsonNode(gotWIthDetailsForDistribution));
                        writer.addEntry(jsonLineModel);
                    }
                    catch (InvalidParseOperationException | IOException e) {
                        throw new RuntimeException("Problem occured when writing data to distribution file", e);
                    }
                });
                this.createReport(param, objectGroupRowsForReport);
            }
        }
        handler.transferFileToWorkspace(DISTRIBUTION_FILE_OG, objectGroupsIdsFile, true, false);
    }

    private void createReport(WorkerParameters param, Map<Pair<String, Set<String>>, List<ObjectGroupToDeleteReportEntry>> objectGroupRawsGlobal) throws ProcessingStatusException {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        ArrayList<DeleteGotVersionsReportEntry> deleteGotVersionsReportEntries = new ArrayList<DeleteGotVersionsReportEntry>();
        for (Map.Entry<Pair<String, Set<String>>, List<ObjectGroupToDeleteReportEntry>> entry : objectGroupRawsGlobal.entrySet()) {
            deleteGotVersionsReportEntries.add(new DeleteGotVersionsReportEntry((String)entry.getKey().getLeft(), param.getRequestId(), tenantId.intValue(), LocalDateUtil.nowFormatted(), (String)entry.getKey().getLeft(), (Set)entry.getKey().getRight(), entry.getValue(), null));
        }
        if (!deleteGotVersionsReportEntries.isEmpty()) {
            this.reportService.appendEntries(param.getContainerName(), deleteGotVersionsReportEntries);
        }
    }

    public List<ObjectGroupToDeleteReportEntry> generateGotWithDetails(ObjectGroupResponse objectGroup, DeleteGotVersionsRequest deleteGotVersionsRequest) {
        ArrayList<ObjectGroupToDeleteReportEntry> objectGroupReportEntries = new ArrayList<ObjectGroupToDeleteReportEntry>();
        List qualifiers = objectGroup.getQualifiers();
        Optional<QualifiersModel> optionalQualifierToUpdate = qualifiers.stream().filter(elmt -> elmt.getQualifier().equals(deleteGotVersionsRequest.getUsageName())).findFirst();
        if (optionalQualifierToUpdate.isEmpty()) {
            String errorMsg = String.format("No qualifier of Object group matches with %s usage", deleteGotVersionsRequest.getUsageName());
            objectGroupReportEntries.add(new ObjectGroupToDeleteReportEntry(StatusCode.KO, errorMsg, null));
            return objectGroupReportEntries;
        }
        QualifiersModel qualifierToUpdate = optionalQualifierToUpdate.get();
        if (qualifierToUpdate.getVersions() == null || qualifierToUpdate.getVersions().isEmpty()) {
            String errorMsg = String.format("No versions associated to the qualifier of Object group for the %s usage", deleteGotVersionsRequest.getUsageName());
            objectGroupReportEntries.add(new ObjectGroupToDeleteReportEntry(StatusCode.KO, errorMsg, null));
            return objectGroupReportEntries;
        }
        ArrayList<VersionsModelCustomized> deletedVersions = new ArrayList<VersionsModelCustomized>();
        for (Integer version : deleteGotVersionsRequest.getSpecificVersions()) {
            ObjectGroupToDeleteReportEntry objectGroupToDeleteReportEntry;
            String msgError;
            Optional<VersionsModel> specificVersionModel = qualifierToUpdate.getVersions().stream().filter(elmt -> elmt.getDataObjectVersion().equals(deleteGotVersionsRequest.getUsageName() + "_" + version)).findFirst();
            if (deleteGotVersionsRequest.getUsageName().equals(DataObjectVersionType.PHYSICAL_MASTER.getName()) && !(msgError = this.checkPhysicalCase(qualifiers, deleteGotVersionsRequest, version)).isEmpty()) {
                objectGroupToDeleteReportEntry = new ObjectGroupToDeleteReportEntry(StatusCode.WARNING, msgError, null);
                objectGroupReportEntries.add(objectGroupToDeleteReportEntry);
                continue;
            }
            if (specificVersionModel.isEmpty()) {
                ObjectGroupToDeleteReportEntry objectGroupToDeleteReportEntry2 = new ObjectGroupToDeleteReportEntry(StatusCode.WARNING, String.format("Qualifier with this specific version %s is inexistant!", version), null);
                objectGroupReportEntries.add(objectGroupToDeleteReportEntry2);
                continue;
            }
            VersionsModel versionModelToDelete = specificVersionModel.get();
            if (this.checkForbiddenVersion(versionModelToDelete)) {
                objectGroupToDeleteReportEntry = new ObjectGroupToDeleteReportEntry(StatusCode.WARNING, String.format("Qualifier with forbidden version %s has been detected!", version), null);
                objectGroupReportEntries.add(objectGroupToDeleteReportEntry);
                continue;
            }
            if (!versionModelToDelete.getDataObjectVersion().equals(FIRST_PHYSICAL_MASTER) && this.checkLastUsageVersion(deleteGotVersionsRequest.getUsageName(), qualifierToUpdate, version)) {
                objectGroupToDeleteReportEntry = new ObjectGroupToDeleteReportEntry(StatusCode.WARNING, String.format("The last version of %s usage cannot be deleted.", deleteGotVersionsRequest.getUsageName()), null);
                objectGroupReportEntries.add(objectGroupToDeleteReportEntry);
                continue;
            }
            deletedVersions.add(this.customizeVersionModel(versionModelToDelete, objectGroup.getOpi()));
        }
        if (!deletedVersions.isEmpty()) {
            ObjectGroupToDeleteReportEntry objectGroupToDeleteReportEntry = new ObjectGroupToDeleteReportEntry(StatusCode.OK, null, deletedVersions);
            objectGroupReportEntries.add(objectGroupToDeleteReportEntry);
        }
        return objectGroupReportEntries;
    }

    private VersionsModelCustomized customizeVersionModel(VersionsModel versionModelToDelete, String opIngest) {
        VersionsModelCustomized versionsModelCustomized = new VersionsModelCustomized();
        versionsModelCustomized.setId(versionModelToDelete.getId());
        versionsModelCustomized.setOpIngest(opIngest);
        versionsModelCustomized.setOpCurrent(versionModelToDelete.getOpi());
        versionsModelCustomized.setSize(versionModelToDelete.getSize());
        versionsModelCustomized.setDataObjectVersion(versionModelToDelete.getDataObjectVersion());
        if (versionModelToDelete.getStorage() != null) {
            versionsModelCustomized.setStrategyId(versionModelToDelete.getStorage().getStrategyId());
        }
        versionsModelCustomized.setPersistentIdentifier(versionModelToDelete.getPersistentIdentifier());
        return versionsModelCustomized;
    }

    private boolean checkLastUsageVersion(String usageName, QualifiersModel qualifierToUpdate, Integer version) {
        qualifierToUpdate.getVersions().sort(Comparator.comparingInt(this::extractVersionFromVersionModel));
        VersionsModel lastVersion = (VersionsModel)Iterables.getLast((Iterable)qualifierToUpdate.getVersions());
        return lastVersion.getDataObjectVersion().equals(usageName + "_" + version);
    }

    private int extractVersionFromVersionModel(VersionsModel objectVersion) {
        return Integer.parseInt(objectVersion.getDataObjectVersion().split("_")[1]);
    }

    private String checkPhysicalCase(List<QualifiersModel> qualifiers, DeleteGotVersionsRequest deleteGotVersionsRequest, int version) {
        String USAGE_NAME = deleteGotVersionsRequest.getUsageName();
        String BINARY_MASTER_NAME = DataObjectVersionType.BINARY_MASTER.getName();
        String QUALIFIER_REQUIRED_ERROR_MSG = "Qualifier %s required for removing that %s usage";
        String VERSION_REQUIRED_ERROR_MSG = "Qualifier %s with version %d required for removing that %s usage";
        if (version == 1) {
            Optional<QualifiersModel> optionalQualifierToUpdate = qualifiers.stream().filter(qualifier -> qualifier.getQualifier().equals(BINARY_MASTER_NAME)).findFirst();
            if (optionalQualifierToUpdate.isEmpty()) {
                return String.format("Qualifier %s required for removing that %s usage", BINARY_MASTER_NAME, USAGE_NAME);
            }
            QualifiersModel binaryMasterQualifier = optionalQualifierToUpdate.get();
            Optional<VersionsModel> optionalBinaryMasterVersion = binaryMasterQualifier.getVersions().stream().filter(versionModel -> versionModel.getDataObjectVersion().equals(FIRST_BINARY_MASTER)).findFirst();
            if (optionalBinaryMasterVersion.isEmpty()) {
                return String.format("Qualifier %s with version %d required for removing that %s usage", BINARY_MASTER_NAME, 1, USAGE_NAME);
            }
        }
        return "";
    }

    private boolean checkForbiddenVersion(VersionsModel specificVersionMode) {
        return FIRST_BINARY_MASTER.equals(specificVersionMode.getDataObjectVersion());
    }

    private Pair<StatusCode, String> validateRequest(DeleteGotVersionsRequest deleteGotVersionsRequest) {
        if (Arrays.stream(DataObjectVersionType.values()).noneMatch(elmt -> elmt.getName().equals(deleteGotVersionsRequest.getUsageName()))) {
            return Pair.of((Object)StatusCode.KO, (Object)"Usage name is unknown.");
        }
        if (deleteGotVersionsRequest.getSpecificVersions() == null || deleteGotVersionsRequest.getSpecificVersions().isEmpty()) {
            return Pair.of((Object)StatusCode.KO, (Object)"Specific versions list is empty.");
        }
        if (this.isVersionsDuplicated(deleteGotVersionsRequest)) {
            return Pair.of((Object)StatusCode.KO, (Object)"Duplicated versions are detected.");
        }
        return Pair.of((Object)StatusCode.OK, null);
    }

    private boolean isVersionsDuplicated(DeleteGotVersionsRequest deleteGotVersionsRequest) {
        return deleteGotVersionsRequest.getSpecificVersions().stream().distinct().count() != (long)deleteGotVersionsRequest.getSpecificVersions().size();
    }

    private DeleteGotVersionsRequest loadRequest(HandlerIO handler) throws ProcessingException, InvalidParseOperationException {
        JsonNode inputRequest = handler.getJsonFromWorkspace("deleteGotVersionsRequest");
        return (DeleteGotVersionsRequest)JsonHandler.getFromJsonNode((JsonNode)inputRequest, DeleteGotVersionsRequest.class);
    }
}

