/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.deleteGotVersions.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DeleteGotVersionsRequest;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.deleteGotVersions.services.DeleteGotVersionsReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DeleteGotVersionsFinalizationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DeleteGotVersionsFinalizationPlugin.class);
    private static final String DELETE_GOT_VERSIONS_FINALIZATION = "DELETE_GOT_VERSIONS_FINALIZATION";
    private final DeleteGotVersionsReportService deleteGotVersionsReportService;
    private final LogbookOperationsClient logbookOperationsClient;

    public DeleteGotVersionsFinalizationPlugin() {
        this(new DeleteGotVersionsReportService(), LogbookOperationsClientFactory.getInstance().getClient());
    }

    @VisibleForTesting
    public DeleteGotVersionsFinalizationPlugin(DeleteGotVersionsReportService deleteGotVersionsReportService, LogbookOperationsClient logbookOperationsClient) {
        this.deleteGotVersionsReportService = deleteGotVersionsReportService;
        this.logbookOperationsClient = logbookOperationsClient;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.storeReportToWorkspace(param, handler);
            this.storeReportToOffers(param.getContainerName());
            this.cleanupReport(param.getRequestId());
            return PluginHelper.buildItemStatus(DELETE_GOT_VERSIONS_FINALIZATION, StatusCode.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error on finalization", (Throwable)e);
            ObjectNode eventDetails = JsonHandler.createObjectNode();
            eventDetails.put("error", e.getMessage());
            return PluginHelper.buildItemStatus(DELETE_GOT_VERSIONS_FINALIZATION, StatusCode.FATAL, eventDetails);
        }
    }

    private void storeReportToWorkspace(WorkerParameters param, HandlerIO handler) throws IOException, InvalidParseOperationException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException, LogbookClientException, ProcessingStatusException {
        if (this.deleteGotVersionsReportService.isReportWrittenInWorkspace(param.getContainerName())) {
            return;
        }
        try (InputStream inputRequest = handler.getInputStreamFromWorkspace("deleteGotVersionsRequest");){
            JsonNode result = this.logbookOperationsClient.selectOperationById(param.getContainerName());
            RequestResponseOK logbookOperationVersionModelResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)result);
            LogbookOperation logbookOperationVersionModel = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)logbookOperationVersionModelResponseOK.getFirstResult()), LogbookOperation.class);
            OperationSummary operationSummary = this.getOperationSummary(logbookOperationVersionModel, param.getContainerName());
            String startDate = logbookOperationVersionModel.getEvDateTime();
            String endDate = LocalDateUtil.nowFormatted();
            ReportType reportType = ReportType.DELETE_GOT_VERSIONS;
            ReportResults vitamResults = new ReportResults();
            ObjectNode extendedInfo = JsonHandler.createObjectNode();
            ReportSummary reportSummary = new ReportSummary(startDate, endDate, reportType, vitamResults, (JsonNode)extendedInfo);
            DeleteGotVersionsRequest deleteGotVersionsRequest = (DeleteGotVersionsRequest)JsonHandler.getFromInputStream((InputStream)inputRequest, DeleteGotVersionsRequest.class);
            JsonNode context = JsonHandler.toJsonNode((Object)deleteGotVersionsRequest);
            Report reportInfo = new Report(operationSummary, reportSummary, context);
            this.deleteGotVersionsReportService.storeReportToWorkspace(reportInfo);
        }
    }

    private OperationSummary getOperationSummary(LogbookOperation logbook, String processId) throws InvalidParseOperationException {
        List events = logbook.getEvents();
        List outcomes = events.stream().map(LogbookEvent::getOutcome).collect(Collectors.toList());
        int nbrKo = Collections.frequency(outcomes, StatusCode.KO.name());
        int nbrWarning = Collections.frequency(outcomes, StatusCode.WARNING.name());
        StatusCode globalOutcome = nbrKo > 0 ? StatusCode.KO : (nbrWarning > 0 ? StatusCode.WARNING : StatusCode.OK);
        LogbookEventOperation referenceEvent = (LogbookEventOperation)events.get(events.size() - 2);
        if (!globalOutcome.equals((Object)StatusCode.OK)) {
            List referenceEventsOfOutcome = events.stream().filter(elmt -> elmt.getOutcome().equals(globalOutcome.name())).collect(Collectors.toList());
            referenceEvent = (LogbookEventOperation)referenceEventsOfOutcome.get(1);
        }
        ObjectNode rSI = StringUtils.isNotBlank((CharSequence)logbook.getRightsStatementIdentifier()) ? JsonHandler.getFromString((String)logbook.getRightsStatementIdentifier()) : JsonHandler.createObjectNode();
        ObjectNode evDetData = Objects.isNull(referenceEvent.getEvDetData()) ? JsonHandler.createObjectNode() : JsonHandler.getFromString((String)referenceEvent.getEvDetData());
        return new OperationSummary(VitamThreadUtils.getVitamSession().getTenantId(), processId, referenceEvent.getEvType(), referenceEvent.getOutcome(), referenceEvent.getOutDetail(), referenceEvent.getOutMessg(), (JsonNode)rSI, (JsonNode)evDetData);
    }

    private void storeReportToOffers(String processId) throws ProcessingStatusException {
        this.deleteGotVersionsReportService.storeReportToOffers(processId);
    }

    private void cleanupReport(String processId) throws ProcessingStatusException {
        this.deleteGotVersionsReportService.cleanupReport(processId);
    }
}

