/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.deleteGotVersions.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.ObjectGroupToDeleteReportEntry;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DeleteGotVersionsRequest;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.DbObjectGroupModel;
import fr.gouv.vitam.common.model.objectgroup.DbQualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModelCustomized;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DeleteGotVersionsActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DeleteGotVersionsActionPlugin.class);
    private static final String PLUGIN_NAME = "DELETE_GOT_VERSIONS_ACTION";
    private final MetaDataClientFactory metaDataClientFactory;

    public DeleteGotVersionsActionPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    public DeleteGotVersionsActionPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ItemStatus> executeList(WorkerParameters params, HandlerIO handler) {
        LOGGER.debug("Starting DeleteGotVersionsActionPlugin... ");
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        List gotIds = params.getObjectNameList();
        List objectGroupToDeleteReportEntriesNodes = params.getObjectMetadataList();
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            DeleteGotVersionsRequest deleteGotVersionsRequest = this.loadRequest(handler);
            RequestResponse objectGroupByIdsResponse = metaDataClient.getObjectGroupsByIdsRaw((Collection)gotIds);
            if (!objectGroupByIdsResponse.isOk()) {
                String errorMsg = "A problem occured when getting ObjectGroup by ids ";
                ObjectNode error = JsonHandler.createObjectNode().put("error", "A problem occured when getting ObjectGroup by ids ");
                gotIds.forEach(gotId -> itemStatuses.add(PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error)));
                ArrayList<ItemStatus> arrayList = itemStatuses;
                return arrayList;
            }
            List results = JsonHandler.getFromJsonNodeList((List)((RequestResponseOK)objectGroupByIdsResponse).getResults(), (TypeReference)new TypeReference<DbObjectGroupModel>(){});
            if (results.size() != gotIds.size()) {
                String errorMsg = "The size of Object Groups readed from database is not coherant with object Groups in distribution file";
                ObjectNode error = JsonHandler.createObjectNode().put("error", "The size of Object Groups readed from database is not coherant with object Groups in distribution file");
                gotIds.forEach(gotId -> itemStatuses.add(PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error)));
                ArrayList<ItemStatus> arrayList = itemStatuses;
                return arrayList;
            }
            int i = 0;
            while (i < gotIds.size()) {
                List objectGroupToDeleteReportEntries;
                String objectId = (String)gotIds.get(i);
                List list = objectGroupToDeleteReportEntries = objectGroupToDeleteReportEntriesNodes != null && !objectGroupToDeleteReportEntriesNodes.isEmpty() ? (List)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)objectGroupToDeleteReportEntriesNodes.get(i)), (TypeReference)new TypeReference<List<ObjectGroupToDeleteReportEntry>>(){}) : null;
                if (objectGroupToDeleteReportEntries == null || objectGroupToDeleteReportEntries.isEmpty()) {
                    throw new IllegalStateException(String.format("No objectGroup entries found for Object group %s in distribution file.", objectId));
                }
                DbObjectGroupModel objectGroupToUpdate = results.stream().filter(elmt -> elmt.getId().equals(objectId)).findFirst().orElseThrow(() -> new IllegalStateException("No objectGroup to update found in Database."));
                itemStatuses.add(this.processDeleteGotVersions(objectId, objectGroupToUpdate, objectGroupToDeleteReportEntries, deleteGotVersionsRequest, handler.getContainerName()));
                ++i;
            }
            return itemStatuses;
        }
        catch (InvalidParseOperationException | VitamClientException | ProcessingException e) {
            String errorMsg = "A problem occured while processing the got versions delete.";
            ObjectNode error = JsonHandler.createObjectNode().put("error", "A problem occured while processing the got versions delete.");
            itemStatuses.add(PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error));
        }
        return itemStatuses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemStatus processDeleteGotVersions(String objectGroupId, DbObjectGroupModel dbObjectGroupModel, List<ObjectGroupToDeleteReportEntry> objectGroupToDeleteReportEntries, DeleteGotVersionsRequest deleteGotVersionsRequest, String containerName) {
        StatusCode status = StatusCode.OK;
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            List okEntries;
            if (objectGroupToDeleteReportEntries.stream().anyMatch(elmt -> elmt.getStatus().equals((Object)StatusCode.WARNING))) {
                status = StatusCode.WARNING;
            }
            if (!(okEntries = objectGroupToDeleteReportEntries.stream().filter(elmt -> elmt.getStatus().equals((Object)StatusCode.OK)).collect(Collectors.toList())).isEmpty()) {
                List qualifiers = dbObjectGroupModel.getQualifiers();
                Optional<DbQualifiersModel> optionalQualifierToUpdate = qualifiers.stream().filter(elmt -> elmt.getQualifier().equals(deleteGotVersionsRequest.getUsageName())).findFirst();
                if (optionalQualifierToUpdate.isEmpty()) {
                    LOGGER.warn(String.format("No qualifier of Object group matches with %s usage. Already deleted ?", deleteGotVersionsRequest.getUsageName()));
                    ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK);
                    return itemStatus;
                }
                DbQualifiersModel qualifierToUpdate = optionalQualifierToUpdate.get();
                if (qualifierToUpdate.getVersions() == null || qualifierToUpdate.getVersions().isEmpty()) {
                    LOGGER.warn(String.format("No versions associated to the qualifier of Object group for the %s usage", deleteGotVersionsRequest.getUsageName()));
                    ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK);
                    return itemStatus;
                }
                List versionsToDelete = okEntries.stream().map(ObjectGroupToDeleteReportEntry::getDeletedVersions).flatMap(Collection::stream).collect(Collectors.toList());
                if (!versionsToDelete.isEmpty()) {
                    List dataObjectVersionsToDelete = versionsToDelete.stream().map(VersionsModelCustomized::getDataObjectVersion).collect(Collectors.toList());
                    qualifierToUpdate.getVersions().removeAll(qualifierToUpdate.getVersions().stream().filter(elmt -> dataObjectVersionsToDelete.contains(elmt.getDataObjectVersion())).collect(Collectors.toList()));
                    qualifierToUpdate.setNbc(qualifierToUpdate.getVersions().size());
                    int totalNbc = qualifiers.stream().mapToInt(DbQualifiersModel::getNbc).sum();
                    qualifiers = qualifiers.stream().filter(qualifier -> qualifier.getNbc() > 0).collect(Collectors.toList());
                    HashMap<String, JsonNode> action = new HashMap<String, JsonNode>();
                    action.put(BuilderToken.PROJECTIONARGS.QUALIFIERS.exactToken(), JsonHandler.toJsonNode(qualifiers));
                    SetAction setQualifier = new SetAction(action);
                    UpdateMultiQuery query = new UpdateMultiQuery();
                    query.addHintFilter(new String[]{BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken()});
                    query.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{containerName}), UpdateActionHelper.set((String)VitamFieldsHelper.nbobjects(), (long)totalNbc), setQualifier});
                    metaDataClient.updateObjectGroupById((JsonNode)query.getFinalUpdate(), objectGroupId);
                }
            }
            ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, status);
            return itemStatus;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataExecutionException e) {
            LOGGER.error(String.format("Delete got versions action failed with status [%s]", StatusCode.FATAL), e);
            ObjectNode error = JsonHandler.createObjectNode().put("error", e.getMessage());
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error);
        }
    }

    private DeleteGotVersionsRequest loadRequest(HandlerIO handler) throws ProcessingException, InvalidParseOperationException {
        JsonNode inputRequest = handler.getJsonFromWorkspace("deleteGotVersionsRequest");
        return (DeleteGotVersionsRequest)JsonHandler.getFromJsonNode((JsonNode)inputRequest, DeleteGotVersionsRequest.class);
    }
}

