/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.deleteGotVersions.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.batch.report.model.entry.DeleteGotVersionsComputedDetails;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import io.prometheus.client.Counter;
import java.time.LocalDateTime;
import java.util.List;

public class DeleteGotVersionsAccessionRegisterUpdatePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DeleteGotVersionsAccessionRegisterUpdatePlugin.class);
    private static final String PLUGIN_ID = "DELETE_GOT_VERSIONS_ACCESSION_REGISTER_UPDATE";
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final BatchReportClientFactory batchReportClientFactory;

    public DeleteGotVersionsAccessionRegisterUpdatePlugin() {
        this(AdminManagementClientFactory.getInstance(), BatchReportClientFactory.getInstance());
    }

    @VisibleForTesting
    public DeleteGotVersionsAccessionRegisterUpdatePlugin(AdminManagementClientFactory adminManagementClientFactory, BatchReportClientFactory batchReportClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.batchReportClientFactory = batchReportClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        LOGGER.debug("DeleteGotVersionsAccessionRegisterUpdatePlugin running ...");
        try {
            return this.updateAccessionRegister(params);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Accession register update failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(PLUGIN_ID, e.getStatusCode(), e.getEventDetails());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemStatus updateAccessionRegister(WorkerParameters params) throws ProcessingStatusException {
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            List<DeleteGotVersionsComputedDetails> deleteGotVersionsComputedDetails = this.getDeletedObjectGroups(params.getContainerName());
            if (deleteGotVersionsComputedDetails == null) {
                ItemStatus itemStatus2 = PluginHelper.buildItemStatusWithMessage(PLUGIN_ID, StatusCode.WARNING, "No updates on Access Register");
                return itemStatus2;
            }
            for (DeleteGotVersionsComputedDetails computedDetail : deleteGotVersionsComputedDetails) {
                AccessionRegisterDetailModel accessionRegisterDetail = this.getAccessionRegisterDetail(computedDetail.getOpc());
                long sizeDeletedGots = computedDetail.getTotalSize();
                accessionRegisterDetail.setOperationType(LogbookTypeProcess.DELETE_GOT_VERSIONS.name());
                accessionRegisterDetail.getObjectSize().setIngested(0L);
                accessionRegisterDetail.getObjectSize().setDeleted(sizeDeletedGots);
                accessionRegisterDetail.getObjectSize().setRemained(-1L * accessionRegisterDetail.getObjectSize().getDeleted());
                accessionRegisterDetail.getTotalObjects().setIngested(0L);
                accessionRegisterDetail.getTotalObjects().setDeleted((long)computedDetail.getTotalObjects());
                accessionRegisterDetail.getTotalObjects().setRemained(-1L * accessionRegisterDetail.getTotalObjects().getDeleted());
                accessionRegisterDetail.getTotalObjectsGroups().setIngested(0L);
                accessionRegisterDetail.getTotalObjectsGroups().setDeleted(0L);
                accessionRegisterDetail.getTotalObjectsGroups().setRemained(0L);
                accessionRegisterDetail.getTotalUnits().setIngested(0L);
                accessionRegisterDetail.getTotalUnits().setDeleted(0L);
                accessionRegisterDetail.getTotalUnits().setRemained(0L);
                accessionRegisterDetail.setOpc(params.getContainerName());
                accessionRegisterDetail.setLastUpdate(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.now()));
                adminManagementClient.createOrUpdateAccessionRegister(accessionRegisterDetail);
            }
            ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_ID, StatusCode.OK);
            return itemStatus;
        }
        catch (AdminManagementClientServerException e) {
            ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "AccessionRegister"})).inc();
            throw new ProcessingStatusException(StatusCode.FATAL, "[Consistency ERROR] An error occurred during accession register update", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccessionRegisterDetailModel getAccessionRegisterDetail(String ingestOperationId) throws ProcessingStatusException {
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            Select select = new Select();
            select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"Opi", (String)ingestOperationId), QueryHelper.exists((String)VitamFieldsHelper.id())}));
            RequestResponse accessionRegisterDetail = adminManagementClient.getAccessionRegisterDetail((JsonNode)select.getFinalSelect());
            if (accessionRegisterDetail.isOk()) {
                RequestResponseOK accessionRegisterDetailresponse = (RequestResponseOK)accessionRegisterDetail;
                if (!accessionRegisterDetailresponse.isEmpty()) {
                    AccessionRegisterDetailModel accessionRegisterDetailModel = (AccessionRegisterDetailModel)accessionRegisterDetailresponse.getFirstResult();
                    return accessionRegisterDetailModel;
                }
                throw new ProcessingStatusException(StatusCode.FATAL, String.format("The accessRegisterDetail for the ingest Opi: %s is EMPTY!", ingestOperationId));
            }
            throw new ProcessingStatusException(StatusCode.FATAL, String.format("No accessRegisterDetail available for the ingest Opi: %s", ingestOperationId));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | ReferentialException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not check existing accessing register", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DeleteGotVersionsComputedDetails> getDeletedObjectGroups(String operationId) throws ProcessingStatusException {
        try (BatchReportClient client = this.batchReportClientFactory.getClient();){
            JsonNode resultsNode = client.readComputedDetailsFromReport(ReportType.DELETE_GOT_VERSIONS, operationId);
            if (resultsNode.isEmpty()) {
                List<DeleteGotVersionsComputedDetails> list2 = null;
                return list2;
            }
            List list = (List)JsonHandler.getFromJsonNode((JsonNode)resultsNode, (TypeReference)new TypeReference<List<DeleteGotVersionsComputedDetails>>(){});
            return list;
        }
        catch (Exception e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not find entries from report!", e);
        }
    }
}

