/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.unit.ComputedInheritedRuleModel;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.Properties;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.PropertyValue;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.RuleCategoryInheritanceOrigin;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class InheritedRule {
    private static final String MAX_END_DATE = "MaxEndDate";
    private static final String END_DATES = "EndDates";
    private static final String RULES = "Rules";
    private static final String INHERITANCE_ORIGIN = "InheritanceOrigin";
    private static final String INHERITED_RULE_IDS = "InheritedRuleIds";
    @JsonProperty(value="MaxEndDate")
    private LocalDate maxEndDate;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="InheritanceOrigin")
    private RuleCategoryInheritanceOrigin ruleCategoryInheritanceOrigin;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="InheritedRuleIds")
    private Set<String> inheritedRuleIds;
    @JsonProperty(value="EndDates")
    private Map<String, LocalDate> ruleIdToRule = new HashMap<String, LocalDate>();
    @JsonProperty(value="Rules")
    private List<ComputedInheritedRuleModel> rules = new ArrayList<ComputedInheritedRuleModel>();

    public InheritedRule() {
    }

    public InheritedRule(LocalDate maxEndDate, Map<String, LocalDate> ruleIdToRule, List<ComputedInheritedRuleModel> rules, RuleCategoryInheritanceOrigin ruleCategoryInheritanceOrigin, Set<String> inheritedRuleIds) {
        this.maxEndDate = maxEndDate;
        this.ruleIdToRule = MapUtils.emptyIfNull(ruleIdToRule);
        this.rules = ListUtils.emptyIfNull(rules);
        this.inheritedRuleIds = SetUtils.emptyIfNull(inheritedRuleIds);
        this.ruleCategoryInheritanceOrigin = ruleCategoryInheritanceOrigin;
    }

    public InheritedRule(LocalDate maxEndDate) {
        this.maxEndDate = maxEndDate;
    }

    public LocalDate getMaxEndDate() {
        return this.maxEndDate;
    }

    public void setMaxEndDate(LocalDate maxEndDate) {
        this.maxEndDate = maxEndDate;
    }

    List<String> parsePropertiesByName(String propertyName, Properties properties) {
        PropertyValue property = properties.getPropertyValue(propertyName);
        if (property != null) {
            return property.getValues().stream().map(object -> Objects.toString(object, null)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Map<String, LocalDate> getRuleIdToRule() {
        return this.ruleIdToRule;
    }

    public void setRuleIdToRule(String ruleId, LocalDate ruleMaxEndDate) {
        this.ruleIdToRule.put(ruleId, ruleMaxEndDate);
    }

    public List<ComputedInheritedRuleModel> getRules() {
        return this.rules;
    }

    public void setRules(List<ComputedInheritedRuleModel> rules) {
        this.rules = rules;
    }

    public RuleCategoryInheritanceOrigin getRuleCategoryInheritanceOrigin() {
        return this.ruleCategoryInheritanceOrigin;
    }

    public InheritedRule setRuleCategoryInheritanceOrigin(RuleCategoryInheritanceOrigin ruleCategoryInheritanceOrigin) {
        this.ruleCategoryInheritanceOrigin = ruleCategoryInheritanceOrigin;
        return this;
    }

    public Set<String> getInheritedRuleIds() {
        return this.inheritedRuleIds;
    }

    public InheritedRule setInheritedRuleIds(Set<String> inheritedRuleIds) {
        this.inheritedRuleIds = inheritedRuleIds;
        return this;
    }
}

