/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.AppraisalRule;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.ClassificationRule;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.InheritedRule;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.StorageRule;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ComputedInheritedRules {
    public static final String STORAGE_RULE = "StorageRule";
    public static final String APPRAISAL_RULE = "AppraisalRule";
    public static final String DISSEMINATION_RULE = "DisseminationRule";
    public static final String ACCESS_RULE = "AccessRule";
    public static final String REUSE_RULE = "ReuseRule";
    public static final String HOLD_RULE = "HoldRule";
    public static final String CLASSIFICATION_RULE = "ClassificationRule";
    private static final String NEED_AUTHORIZATION = "NeedAuthorization";
    @JsonProperty(value="StorageRule")
    private StorageRule storageRule;
    @JsonProperty(value="AppraisalRule")
    private AppraisalRule appraisalRule;
    @JsonProperty(value="DisseminationRule")
    private InheritedRule disseminationRule;
    @JsonProperty(value="AccessRule")
    private InheritedRule accessRule;
    @JsonProperty(value="ReuseRule")
    private InheritedRule reuseRule;
    @JsonProperty(value="ClassificationRule")
    private ClassificationRule classificationRule;
    @JsonProperty(value="HoldRule")
    private InheritedRule holdRule;
    @JsonProperty(value="inheritedRulesAPIOutput")
    private JsonNode inheritedRulesAPIOutput;
    @JsonProperty(value="indexationDate")
    private String indexationDate;
    @JsonProperty(value="NeedAuthorization")
    private List<Boolean> needAuthorization;

    public ComputedInheritedRules() {
    }

    public ComputedInheritedRules(Map<String, InheritedRule> inheritedRules, JsonNode inheritedRulesAPIOutput, Map<String, Object> globalInheritedProperties, String indexationDate) {
        this(inheritedRules, indexationDate, globalInheritedProperties);
        this.inheritedRulesAPIOutput = inheritedRulesAPIOutput;
    }

    public ComputedInheritedRules(Map<String, InheritedRule> inheritedRules, String indexationDate, Map<String, Object> globalInheritedProperties) {
        this.storageRule = (StorageRule)inheritedRules.get(STORAGE_RULE);
        this.appraisalRule = (AppraisalRule)inheritedRules.get(APPRAISAL_RULE);
        this.disseminationRule = inheritedRules.get(DISSEMINATION_RULE);
        this.accessRule = inheritedRules.get(ACCESS_RULE);
        this.reuseRule = inheritedRules.get(REUSE_RULE);
        this.classificationRule = (ClassificationRule)inheritedRules.get(CLASSIFICATION_RULE);
        this.holdRule = inheritedRules.get(HOLD_RULE);
        this.indexationDate = indexationDate;
        this.needAuthorization = this.parseNeedAuthorizationProperty(globalInheritedProperties.get(NEED_AUTHORIZATION));
    }

    private List<Boolean> parseNeedAuthorizationProperty(Object needAuthorizationProperty) {
        if (needAuthorizationProperty == null) {
            return null;
        }
        if (needAuthorizationProperty instanceof Boolean) {
            this.needAuthorization = Collections.singletonList((Boolean)needAuthorizationProperty);
            return this.needAuthorization;
        }
        if (needAuthorizationProperty instanceof Collection) {
            this.needAuthorization = (List)needAuthorizationProperty;
            return this.needAuthorization;
        }
        throw new VitamRuntimeException("needAuthorization Type invalide : " + needAuthorizationProperty.getClass());
    }

    public InheritedRule getStorageRule() {
        return this.storageRule;
    }

    public void setStorageRule(StorageRule storageRule) {
        this.storageRule = storageRule;
    }

    public InheritedRule getAppraisalRule() {
        return this.appraisalRule;
    }

    public void setAppraisalRule(AppraisalRule appraisalRule) {
        this.appraisalRule = appraisalRule;
    }

    public InheritedRule getDisseminationRule() {
        return this.disseminationRule;
    }

    public void setDisseminationRule(InheritedRule disseminationRule) {
        this.disseminationRule = disseminationRule;
    }

    public InheritedRule getAccessRule() {
        return this.accessRule;
    }

    public void setAccessRule(InheritedRule accessRule) {
        this.accessRule = accessRule;
    }

    public InheritedRule getReuseRule() {
        return this.reuseRule;
    }

    public void setReuseRule(InheritedRule reuseRule) {
        this.reuseRule = reuseRule;
    }

    public ClassificationRule getClassificationRule() {
        return this.classificationRule;
    }

    public void setClassificationRule(ClassificationRule classificationRule) {
        this.classificationRule = classificationRule;
    }

    public InheritedRule getHoldRule() {
        return this.holdRule;
    }

    public void setHoldRule(InheritedRule holdRule) {
        this.holdRule = holdRule;
    }

    public JsonNode getInheritedRulesAPIOutput() {
        return this.inheritedRulesAPIOutput;
    }

    public void setInheritedRulesAPIOutput(JsonNode inheritedRulesAPIOutput) {
        this.inheritedRulesAPIOutput = inheritedRulesAPIOutput;
    }

    public String getIndexationDate() {
        return this.indexationDate;
    }

    public void setIndexationDate(String indexationDate) {
        this.indexationDate = indexationDate;
    }

    public List<Boolean> getNeedAuthorization() {
        return this.needAuthorization;
    }

    public void setNeedAuthorization(List<Boolean> needAuthorization) {
        this.needAuthorization = needAuthorization;
    }
}

