/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.unit.ComputedInheritedRuleModel;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.InheritedRule;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.Properties;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.RuleCategoryInheritanceOrigin;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassificationRule
extends InheritedRule {
    private static final String CLASSIFICATION_LEVEL = "ClassificationLevel";
    private static final String CLASSIFICATION_AUDIENCE = "ClassificationAudience";
    private static final String CLASSIFICATION_OWNER = "ClassificationOwner";
    private static final String CLASSIFICATION_REASSESSING_DATE = "ClassificationReassessingDate";
    private static final String NEED_REASSESSING_AUTHORIZATION = "NeedReassessingAuthorization";
    @JsonProperty(value="ClassificationAudience")
    private List<String> classificationAudience;
    @JsonProperty(value="ClassificationLevel")
    private List<String> classificationLevel;
    @JsonProperty(value="ClassificationOwner")
    private List<String> classificationOwner;
    @JsonProperty(value="ClassificationReassessingDate")
    private List<String> classificationReassessingDate;
    @JsonProperty(value="NeedReassessingAuthorization")
    private List<String> needReassessingAuthorization;

    public ClassificationRule() {
    }

    public ClassificationRule(LocalDate maxEndDate, Properties properties, Map<String, LocalDate> ruleIdToRule, List<ComputedInheritedRuleModel> rules, RuleCategoryInheritanceOrigin ruleCategoryInheritanceOrigin, Set<String> inheritedRuleIds) {
        super(maxEndDate, ruleIdToRule, rules, ruleCategoryInheritanceOrigin, inheritedRuleIds);
        this.parseClassificationProperties(properties);
    }

    private void parseClassificationProperties(Properties properties) {
        this.classificationLevel = this.parsePropertiesByName(CLASSIFICATION_LEVEL, properties);
        this.classificationOwner = this.parsePropertiesByName(CLASSIFICATION_OWNER, properties);
        this.classificationReassessingDate = this.parsePropertiesByName(CLASSIFICATION_REASSESSING_DATE, properties);
        this.needReassessingAuthorization = this.parsePropertiesByName(NEED_REASSESSING_AUTHORIZATION, properties);
        this.classificationAudience = this.parsePropertiesByName(CLASSIFICATION_AUDIENCE, properties);
    }

    public List<String> getClassificationLevel() {
        return this.classificationLevel;
    }

    public void setClassificationLevel(List<String> classificationLevel) {
        this.classificationLevel = classificationLevel;
    }

    public List<String> getClassificationOwner() {
        return this.classificationOwner;
    }

    public void setClassificationOwner(List<String> classificationOwner) {
        this.classificationOwner = classificationOwner;
    }

    public List<String> getClassificationReassessingDate() {
        return this.classificationReassessingDate;
    }

    public void setClassificationReassessingDate(List<String> classificationReassessingDate) {
        this.classificationReassessingDate = classificationReassessingDate;
    }

    public List<String> getNeedReassessingAuthorization() {
        return this.needReassessingAuthorization;
    }

    public void setNeedReassessingAuthorization(List<String> needReassessingAuthorization) {
        this.needReassessingAuthorization = needReassessingAuthorization;
    }

    public List<String> getClassificationAudience() {
        return this.classificationAudience;
    }

    public void setClassificationAudience(List<String> classificationAudience) {
        this.classificationAudience = classificationAudience;
    }
}

