/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.exception.ComputedInheritedRulesException;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;

public class ComputeInheritedRulesPreparationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ComputeInheritedRulesPreparationPlugin.class);
    private static final String PLUGIN_NAME = "COMPUTE_INHERITED_RULES_PREPARATION";
    private final MetaDataClientFactory metaDataClientFactory;
    static final String UNITS_JSONL_FILE = "units.jsonl";

    public ComputeInheritedRulesPreparationPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    ComputeInheritedRulesPreparationPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        JsonNode dslQuery = handler.getJsonFromWorkspace("query.json");
        try {
            this.process(handler, dslQuery);
        }
        catch (ComputedInheritedRulesException e) {
            LOGGER.error(String.format("ComputeInheritedRules preparation failed with status [%s]", e.getStatusCode()), (Throwable)((Object)e));
            ObjectNode error = JsonHandler.createObjectNode().put("error", e.getMessage());
            return PluginHelper.buildItemStatus(PLUGIN_NAME, e.getStatusCode(), error);
        }
        return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, null);
    }

    private void process(HandlerIO handler, JsonNode dslQuery) throws ComputedInheritedRulesException {
        File unitDistributionFile = null;
        try (MetaDataClient metadataClient = this.metaDataClientFactory.getClient();){
            SelectMultiQuery selectMultiQuery = this.createSelectMultiple(dslQuery);
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(metadataClient, selectMultiQuery);
            SpliteratorIterator unitIterator = new SpliteratorIterator(scrollRequest);
            unitDistributionFile = handler.getNewLocalFile(UNITS_JSONL_FILE);
            try (JsonLineWriter unitWriter = new JsonLineWriter((OutputStream)new FileOutputStream(unitDistributionFile));){
                while (unitIterator.hasNext()) {
                    JsonNode unit = (JsonNode)unitIterator.next();
                    String unitId = unit.get(VitamFieldsHelper.id()).asText();
                    JsonLineModel entry = new JsonLineModel(unitId);
                    unitWriter.addEntry(entry);
                }
            }
            handler.transferFileToWorkspace(UNITS_JSONL_FILE, unitDistributionFile, true, false);
        }
        catch (InvalidParseOperationException | ProcessingException | IOException e) {
            try {
                throw new ComputedInheritedRulesException(StatusCode.FATAL, "Could not generate unit and/or object group distributions", e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(unitDistributionFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)unitDistributionFile);
    }

    private SelectMultiQuery createSelectMultiple(JsonNode initialQuery) throws InvalidParseOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(initialQuery);
        SelectMultiQuery selectMultiQuery = parser.getRequest();
        ObjectNode projectionNode = this.getQueryProjectionToApply();
        selectMultiQuery.setProjection((JsonNode)projectionNode);
        return selectMultiQuery;
    }

    private ObjectNode getQueryProjectionToApply() {
        ObjectNode projectionNode = JsonHandler.createObjectNode();
        ObjectNode fields = JsonHandler.createObjectNode();
        fields.put(ParserTokens.PROJECTIONARGS.ID.exactToken(), 1);
        projectionNode.set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)fields);
        return projectionNode;
    }
}

