/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.List;
import javax.ws.rs.ProcessingException;

public class ComputeInheritedRulesInvalidatorPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ComputeInheritedRulesInvalidatorPlugin.class);
    private static final String PLUGIN_NAME = "COMPUTE_INHERITED_RULES_INVALIDATOR";
    private final MetaDataClientFactory metaDataClientFactory;

    public ComputeInheritedRulesInvalidatorPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    ComputeInheritedRulesInvalidatorPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) {
        LOGGER.debug(String.format("executeList from plugin '%s'", PLUGIN_NAME));
        List units = workerParameters.getObjectNameList();
        UpdateMultiQuery update = new UpdateMultiQuery();
        try (MetaDataClient mdClient = this.metaDataClientFactory.getClient();){
            update.addRoots(units.toArray(new String[0]));
            update.addActions(new Action[]{UpdateActionHelper.set((String)VitamFieldsHelper.validComputedInheritedRules(), (boolean)false), UpdateActionHelper.unset((String[])new String[]{VitamFieldsHelper.computedInheritedRules()})});
            RequestResponse requestResponse = mdClient.updateUnitBulk((JsonNode)update.getFinalUpdate());
            if (!requestResponse.isOk()) {
                throw new ProcessingException("error during bulk update");
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataException e) {
            throw new ProcessingException(e);
        }
        return PluginHelper.buildBulkItemStatus(workerParameters, PLUGIN_NAME, StatusCode.OK);
    }
}

