/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public class ComputeInheritedRulesFinalizationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ComputeInheritedRulesFinalizationPlugin.class);
    private static final String COMPUTE_INHERITED_RULES_FINALIZATION = "COMPUTE_INHERITED_RULES_FINALIZATION";
    private final BatchReportClientFactory batchReportClientFactory;

    public ComputeInheritedRulesFinalizationPlugin() {
        this(BatchReportClientFactory.getInstance());
    }

    @VisibleForTesting
    ComputeInheritedRulesFinalizationPlugin(BatchReportClientFactory batchReportClientFactory) {
        this.batchReportClientFactory = batchReportClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        this.cleanupBatchReport(handler);
        LOGGER.info("Computed inherited rules finalization succeeded");
        return PluginHelper.buildItemStatus(COMPUTE_INHERITED_RULES_FINALIZATION, StatusCode.OK, null);
    }

    private void cleanupBatchReport(HandlerIO handler) throws ProcessingException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            String processId = handler.getContainerName();
            batchReportClient.cleanupReport(processId, ReportType.UNIT_COMPUTED_INHERITED_RULES_INVALIDATION);
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingException("An error occurred during cleanup", (Throwable)e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return COMPUTE_INHERITED_RULES_FINALIZATION;
    }
}

