/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UnsetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.List;

public class ComputeInheritedRulesDeletePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ComputeInheritedRulesDeletePlugin.class);
    private static final String PLUGIN_NAME = "COMPUTE_INHERITED_RULES_DELETE";
    private final MetaDataClientFactory metaDataClientFactory;

    public ComputeInheritedRulesDeletePlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    ComputeInheritedRulesDeletePlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        List<ItemStatus> list;
        block10: {
            LOGGER.debug("execute Compute Inherited Rules Delete Plugin");
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                SelectMultiQuery select = new SelectMultiQuery();
                InQuery query = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])workerParameters.getObjectNameList().toArray(new String[0]));
                select.setQuery((Query)query);
                JsonNode response = metaDataClient.selectUnitsWithInheritedRules((JsonNode)select.getFinalSelect());
                RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)response);
                List archiveWithInheritedRules = requestResponseOK.getResults();
                for (JsonNode archiveUnit : archiveWithInheritedRules) {
                    String unitId = archiveUnit.get(VitamFieldsHelper.id()).textValue();
                    ObjectNode updateMultiQuery = this.getUpdateQuery();
                    metaDataClient.updateUnitById((JsonNode)updateMultiQuery, unitId);
                }
                list = PluginHelper.buildBulkItemStatus(workerParameters, PLUGIN_NAME, StatusCode.OK);
                if (metaDataClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | MetaDataException e) {
                    throw new ProcessingException(e);
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("File couldn't be converted into json", (Throwable)e);
                    return PluginHelper.buildBulkItemStatus(workerParameters, PLUGIN_NAME, StatusCode.KO);
                }
            }
            metaDataClient.close();
        }
        return list;
    }

    private ObjectNode getUpdateQuery() throws InvalidCreateOperationException {
        UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
        updateMultiQuery.addActions(new Action[]{new UnsetAction(new String[]{VitamFieldsHelper.computedInheritedRules()})});
        updateMultiQuery.addActions(new Action[]{new UnsetAction(new String[]{VitamFieldsHelper.validComputedInheritedRules()})});
        return updateMultiQuery.getFinalUpdateById();
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        throw new VitamRuntimeException("Not implemented");
    }
}

