/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.rules.InheritedPropertyResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleCategoryResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleResponseModel;
import fr.gouv.vitam.common.model.rules.UnitInheritedRulesResponseModel;
import fr.gouv.vitam.common.model.unit.ComputedInheritedRuleModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.AppraisalRule;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.ClassificationRule;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.ComputedInheritedRules;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.InheritedRule;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.Properties;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.PropertyValue;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.RuleCategoryInheritanceOrigin;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.model.StorageRule;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ComputeInheritedRulesActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ComputeInheritedRulesActionPlugin.class);
    private static final String PLUGIN_NAME = "COMPUTE_INHERITED_RULES_ACTION_PLUGIN";
    private static final String INHERITED_RULES = "InheritedRules";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final BinaryOperator<LocalDate> DATE_MERGER = (date, date2) -> {
        if (date.isBefore((ChronoLocalDate)date2)) {
            return date2;
        }
        return date;
    };
    private static final BinaryOperator<Object> PROPERTY_MERGER = (property, property2) -> {
        ArrayList<Object> list = new ArrayList<Object>();
        if (property instanceof Collection) {
            list.addAll((Collection)property);
        } else {
            list.add(property);
        }
        list.add(property2);
        return list;
    };
    private final MetaDataClientFactory metaDataClientFactory;

    public ComputeInheritedRulesActionPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    ComputeInheritedRulesActionPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        List<ItemStatus> list;
        block10: {
            LOGGER.debug("execute ComputeInheritedRulesActionPlugin");
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                SelectMultiQuery select = new SelectMultiQuery();
                InQuery query = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])workerParameters.getObjectNameList().toArray(new String[0]));
                select.setQuery((Query)query);
                JsonNode response = metaDataClient.selectUnitsWithInheritedRules((JsonNode)select.getFinalSelect());
                RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)response);
                List archiveWithInheritedRules = requestResponseOK.getResults();
                String tenantId = VitamThreadUtils.getVitamSession().getTenantId().toString();
                boolean isApiIndexable = this.isIndexable(tenantId, VitamConfiguration.getIndexInheritedRulesWithAPIV2OutputByTenant());
                boolean isRuleIndexable = this.isIndexable(tenantId, VitamConfiguration.getIndexInheritedRulesWithRulesIdByTenant());
                for (JsonNode archiveUnit : archiveWithInheritedRules) {
                    UnitInheritedRulesResponseModel unitInheritedResponseModel = (UnitInheritedRulesResponseModel)JsonHandler.getFromJsonNode((JsonNode)archiveUnit.get(INHERITED_RULES), UnitInheritedRulesResponseModel.class);
                    String unitId = archiveUnit.get(VitamFieldsHelper.id()).textValue();
                    Map<String, InheritedRule> inheritedRulesWithAllOption = unitInheritedResponseModel.getRuleCategories().entrySet().stream().map(entry -> this.mapToCategoriesWithEndDateAndProperties((String)entry.getKey(), (InheritedRuleCategoryResponseModel)entry.getValue(), isRuleIndexable)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    Map<String, Object> globalInheritedProperties = unitInheritedResponseModel.getGlobalProperties().stream().collect(Collectors.toMap(InheritedPropertyResponseModel::getPropertyName, InheritedPropertyResponseModel::getPropertyValue, PROPERTY_MERGER));
                    JsonNode inheritedRulesAPIOutput = isApiIndexable ? JsonHandler.toJsonNode((Object)unitInheritedResponseModel) : null;
                    ComputedInheritedRules computedInheritedRules = this.getComputedInheritedRules(inheritedRulesWithAllOption, inheritedRulesAPIOutput, globalInheritedProperties, isApiIndexable);
                    ObjectNode updateMultiQuery = this.getUpdateQuery(computedInheritedRules);
                    metaDataClient.updateUnitById((JsonNode)updateMultiQuery, unitId);
                }
                list = PluginHelper.buildBulkItemStatus(workerParameters, PLUGIN_NAME, StatusCode.OK);
                if (metaDataClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | MetaDataException e) {
                    throw new ProcessingException(e);
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("File couldn't be converted into json", (Throwable)e);
                    return PluginHelper.buildBulkItemStatus(workerParameters, PLUGIN_NAME, StatusCode.KO);
                }
            }
            metaDataClient.close();
        }
        return list;
    }

    private ObjectNode getUpdateQuery(ComputedInheritedRules computedInheritedRules) throws InvalidParseOperationException, InvalidCreateOperationException {
        HashMap<String, JsonNode> action = new HashMap<String, JsonNode>();
        action.put(VitamFieldsHelper.computedInheritedRules(), JsonHandler.toJsonNode((Object)computedInheritedRules));
        action.put(VitamFieldsHelper.validComputedInheritedRules(), JsonHandler.toJsonNode((Object)true));
        SetAction setComputedInheritedRules = new SetAction(action);
        UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
        updateMultiQuery.addActions(new Action[]{setComputedInheritedRules});
        return updateMultiQuery.getFinalUpdateById();
    }

    private boolean isIndexable(String tenant, List<String> indexByTenants) {
        if (indexByTenants == null || indexByTenants.isEmpty()) {
            return false;
        }
        return indexByTenants.contains(tenant);
    }

    private Map.Entry<String, InheritedRule> mapToCategoriesWithEndDateAndProperties(String category, InheritedRuleCategoryResponseModel categoryResponseModel, boolean isRuleIndexable) {
        boolean hasInheritedRules;
        LocalDate maxEndDate = categoryResponseModel.getRules().stream().filter(rule -> rule.getEndDate() != null).map(rule -> this.parseToLocalDate(rule.getEndDate())).max(LocalDate::compareTo).orElse(null);
        Map<String, LocalDate> ruleIdToRuleMaxEndDate = categoryResponseModel.getRules().stream().filter(rule -> rule.getEndDate() != null).collect(Collectors.toMap(InheritedRuleResponseModel::getRuleId, rule -> this.parseToLocalDate(rule.getEndDate()), DATE_MERGER));
        Map<String, PropertyValue> propertyNameToPropertyValue = this.mapInheritedPropertyResponseModelToPropertiesNameValue(categoryResponseModel.getProperties());
        Set<String> inheritedRuleIds = categoryResponseModel.getRules().stream().filter(Predicate.not(this::isRuleLocallyDefined)).map(InheritedRuleResponseModel::getRuleId).collect(Collectors.toSet());
        boolean hasLocalRules = categoryResponseModel.getRules().stream().anyMatch(this::isRuleLocallyDefined);
        boolean bl = hasInheritedRules = !inheritedRuleIds.isEmpty();
        RuleCategoryInheritanceOrigin ruleCategoryInheritanceOrigin = hasLocalRules ? (hasInheritedRules ? RuleCategoryInheritanceOrigin.LOCAL_AND_INHERITED : RuleCategoryInheritanceOrigin.LOCAL) : (hasInheritedRules ? RuleCategoryInheritanceOrigin.INHERITED : null);
        return this.getInheritedRuleByCategory(category, isRuleIndexable, maxEndDate, ruleIdToRuleMaxEndDate, propertyNameToPropertyValue, ruleCategoryInheritanceOrigin, inheritedRuleIds);
    }

    private boolean isRuleLocallyDefined(InheritedRuleResponseModel rule) {
        return rule.getPaths().size() == 1 && ((List)rule.getPaths().get(0)).size() == 1;
    }

    private Map.Entry<String, InheritedRule> getInheritedRuleByCategory(String category, boolean isRuleIndexable, LocalDate maxEndDateByCategory, Map<String, LocalDate> computedInheritedRules, Map<String, PropertyValue> propertyNameToPropertyValue, RuleCategoryInheritanceOrigin ruleCategoryInheritanceOrigin, Set<String> inheritedRuleIds) {
        Properties properties = new Properties(propertyNameToPropertyValue);
        Map<String, LocalDate> ruleIdToRule = isRuleIndexable ? computedInheritedRules : null;
        List<ComputedInheritedRuleModel> rules = ruleIdToRule == null ? Collections.emptyList() : ruleIdToRule.entrySet().stream().map(entry -> new ComputedInheritedRuleModel((String)entry.getKey(), ((LocalDate)entry.getValue()).toString())).collect(Collectors.toList());
        switch (category) {
            case "ClassificationRule": {
                return new AbstractMap.SimpleImmutableEntry<String, InheritedRule>(category, new ClassificationRule(maxEndDateByCategory, properties, ruleIdToRule, rules, ruleCategoryInheritanceOrigin, inheritedRuleIds));
            }
            case "StorageRule": {
                return new AbstractMap.SimpleImmutableEntry<String, InheritedRule>(category, new StorageRule(maxEndDateByCategory, properties, ruleIdToRule, rules, ruleCategoryInheritanceOrigin, inheritedRuleIds));
            }
            case "AppraisalRule": {
                return new AbstractMap.SimpleImmutableEntry<String, InheritedRule>(category, new AppraisalRule(maxEndDateByCategory, properties, ruleIdToRule, rules, ruleCategoryInheritanceOrigin, inheritedRuleIds));
            }
            case "DisseminationRule": 
            case "AccessRule": 
            case "ReuseRule": 
            case "HoldRule": {
                return new AbstractMap.SimpleImmutableEntry<String, InheritedRule>(category, new InheritedRule(maxEndDateByCategory, ruleIdToRule, rules, ruleCategoryInheritanceOrigin, inheritedRuleIds));
            }
        }
        throw new VitamRuntimeException(String.format("Category rule cannot be of type '%s'.", category));
    }

    private LocalDate parseToLocalDate(String dateToParse) {
        if (dateToParse == null) {
            return null;
        }
        return LocalDate.parse(dateToParse, DATE_TIME_FORMATTER);
    }

    private Map<String, PropertyValue> mapInheritedPropertyResponseModelToPropertiesNameValue(List<InheritedPropertyResponseModel> properties) {
        return properties.stream().collect(Collectors.toMap(InheritedPropertyResponseModel::getPropertyName, property -> new PropertyValue(property.getPropertyValue()), PropertyValue::new));
    }

    private ComputedInheritedRules getComputedInheritedRules(Map<String, InheritedRule> inheritedRules, JsonNode inheritedRulesAPIOutput, Map<String, Object> globalInheritedProperties, boolean isApiIndexable) {
        String dateFormatted = Instant.now().atZone(ZoneId.systemDefault()).toLocalDate().format(DATE_TIME_FORMATTER);
        if (isApiIndexable) {
            return new ComputedInheritedRules(inheritedRules, inheritedRulesAPIOutput, globalInheritedProperties, dateFormatted);
        }
        return new ComputedInheritedRules(inheritedRules, dateFormatted, globalInheritedProperties);
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        throw new VitamRuntimeException("Not implemented");
    }

    public static String getId() {
        return PLUGIN_NAME;
    }
}

