/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.computeinheritedrules;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.ReportBody;
import fr.gouv.vitam.batch.report.model.ReportExportRequest;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.batch.report.model.entry.UnitComputedInheritedRulesInvalidationReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.ExistsQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang.StringUtils;

public class ComputeInheritedRuleProgenyIdentifierPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ComputeInheritedRuleProgenyIdentifierPlugin.class);
    private static final String PLUGIN_NAME = "COMPUTE_INHERITED_RULES_PROGENY_IDENTIFIER";
    private static final TypeReference<JsonLineModel> TYPE_REFERENCE = new TypeReference<JsonLineModel>(){};
    static final String UNITS_JSONL_FILE_NAME = "unitsToInvalidate.jsonl";
    private final MetaDataClientFactory metaDataClientFactory;
    private final BatchReportClientFactory batchReportClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final int bulkSize;

    public ComputeInheritedRuleProgenyIdentifierPlugin() {
        this(MetaDataClientFactory.getInstance(), BatchReportClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), VitamConfiguration.getBatchSize());
    }

    @VisibleForTesting
    ComputeInheritedRuleProgenyIdentifierPlugin(MetaDataClientFactory metaDataClientFactory, BatchReportClientFactory batchReportClientFactory, WorkspaceClientFactory workspaceClientFactory, int bulkSize) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.batchReportClientFactory = batchReportClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.bulkSize = bulkSize;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        String processId = handler.getContainerName();
        if (StringUtils.isEmpty((String)processId)) {
            LOGGER.error("processId null or empty.");
            return PluginHelper.buildBulkItemStatus(workerParameters, PLUGIN_NAME, StatusCode.FATAL);
        }
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (workspaceClient.isExistingObject(handler.getContainerName(), UNITS_JSONL_FILE_NAME)) {
                LOGGER.warn("unitsToInvalidate.jsonl already exists. Will be overridden with fresh data");
                workspaceClient.deleteObject(handler.getContainerName(), UNITS_JSONL_FILE_NAME);
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            throw new ProcessingException(e);
        }
        handler.setCurrentObjectId((String)workerParameters.getObjectNameList().get(0));
        try (FileInputStream inputStream = new FileInputStream((File)handler.getInput(0));
             JsonLineGenericIterator lines = new JsonLineGenericIterator((InputStream)inputStream, TYPE_REFERENCE);
             BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();
             MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            UnmodifiableIterator bulkLines = Iterators.partition((Iterator)lines, (int)this.bulkSize);
            bulkLines.forEachRemaining(unitsToBatch -> this.findAndSaveUnitsProgeny(metaDataClient, batchReportClient, (List<JsonLineModel>)unitsToBatch, processId));
            batchReportClient.exportUnitsToInvalidate(processId, new ReportExportRequest(UNITS_JSONL_FILE_NAME));
        }
        catch (VitamClientInternalException | IOException e) {
            throw new ProcessingException(e);
        }
        return PluginHelper.buildBulkItemStatus(workerParameters, PLUGIN_NAME, StatusCode.OK);
    }

    private void findAndSaveUnitsProgeny(MetaDataClient metaDataClient, BatchReportClient batchReportClient, List<JsonLineModel> unitsToBatch, String operationId) {
        String[] parentsIds = (String[])unitsToBatch.stream().map(JsonLineModel::getId).toArray(String[]::new);
        try {
            InQuery childrenUnitsQuery = QueryHelper.in((String)VitamFieldsHelper.allunitups(), (String[])parentsIds);
            InQuery parentsUnitsQuery = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])parentsIds);
            BooleanQuery parentsAndProgenyUnits = QueryHelper.or().add(new Query[]{childrenUnitsQuery, parentsUnitsQuery});
            ExistsQuery unitsToIndex = QueryHelper.exists((String)VitamFieldsHelper.validComputedInheritedRules());
            BooleanQuery unitsToInvalidate = QueryHelper.and().add(new Query[]{unitsToIndex, parentsAndProgenyUnits});
            SelectMultiQuery select = new SelectMultiQuery();
            select.setQuery((Query)unitsToInvalidate);
            select.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            SpliteratorIterator unitIterator = new SpliteratorIterator(ScrollSpliteratorHelper.createUnitScrollSplitIterator(metaDataClient, select));
            Iterator unitIdIterator = IteratorUtils.transformedIterator((Iterator)unitIterator, result -> Objects.requireNonNull(result.get(VitamFieldsHelper.id()).asText()));
            Iterators.partition((Iterator)unitIdIterator, (int)VitamConfiguration.getBatchSize()).forEachRemaining(unitsIds -> this.appendUnitIdsToBatchReport(batchReportClient, operationId, (List<String>)unitsIds));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new VitamRuntimeException(e);
        }
    }

    private void appendUnitIdsToBatchReport(BatchReportClient batchReportClient, String operationId, List<String> unitsIds) {
        try {
            List entries = unitsIds.stream().distinct().map(UnitComputedInheritedRulesInvalidationReportEntry::new).collect(Collectors.toList());
            ReportBody report = new ReportBody(operationId, ReportType.UNIT_COMPUTED_INHERITED_RULES_INVALIDATION, entries);
            batchReportClient.appendReportEntries(report);
        }
        catch (VitamClientInternalException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }
}

