/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.common;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.ProcessingRetryAsyncException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectAvailabilityRequest;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectAvailabilityResponse;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public abstract class CheckResourceAvailability
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckResourceAvailability.class);
    private final StorageClientFactory storageClientFactory;

    protected CheckResourceAvailability(StorageClientFactory storage) {
        this.storageClientFactory = storage;
    }

    protected void checkResourcesAvailabilityByTypes(Map<DataCategory, Map<AccessRequestContext, List<String>>> objectIdsByContextbyType) throws StorageServerClientException, ProcessingRetryAsyncException {
        LOGGER.info("Check if resources are available for multiple categories.");
        HashMap<AccessRequestContext, List> accessRequestsCreated = new HashMap<AccessRequestContext, List>();
        for (DataCategory type : objectIdsByContextbyType.keySet()) {
            MultiValuedMap<AccessRequestContext, String> unavailableResources = this.extractUnavailableResources(objectIdsByContextbyType.get(type), type);
            if (unavailableResources.isEmpty()) continue;
            LOGGER.info("Some resources are unavailable, creation of accessRequests.");
            Map<AccessRequestContext, List<String>> createAccessRequestsForType = this.createAccessRequests(unavailableResources, type);
            for (AccessRequestContext context : createAccessRequestsForType.keySet()) {
                accessRequestsCreated.computeIfAbsent(context, x -> new ArrayList()).addAll((Collection)createAccessRequestsForType.get(context));
            }
        }
        if (!accessRequestsCreated.isEmpty()) {
            throw new ProcessingRetryAsyncException(accessRequestsCreated);
        }
    }

    protected void checkResourcesAvailability(Map<AccessRequestContext, List<String>> objectIdsByContext, DataCategory type) throws StorageServerClientException, ProcessingRetryAsyncException {
        LOGGER.info("Check if resources are available.");
        MultiValuedMap<AccessRequestContext, String> unavailableResources = this.extractUnavailableResources(objectIdsByContext, type);
        if (!unavailableResources.isEmpty()) {
            LOGGER.info("Some resources are unavailable, creation of accessRequests.");
            Map<AccessRequestContext, List<String>> accessRequestsCreated = this.createAccessRequests(unavailableResources, type);
            throw new ProcessingRetryAsyncException(accessRequestsCreated);
        }
    }

    private MultiValuedMap<AccessRequestContext, String> extractUnavailableResources(Map<AccessRequestContext, List<String>> objectIdsByContext, DataCategory type) throws StorageServerClientException {
        LOGGER.debug("Extract the resources that are unavailable");
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            ArrayListValuedHashMap unavailableObjects = new ArrayListValuedHashMap();
            for (AccessRequestContext context : objectIdsByContext.keySet()) {
                Collection objectIds = objectIdsByContext.get(context);
                UnmodifiableIterator objectIdsIterator = Iterators.partition(objectIds.iterator(), (int)VitamConfiguration.getBatchSize());
                while (objectIdsIterator.hasNext()) {
                    List objectIdsBulk = (List)objectIdsIterator.next();
                    BulkObjectAvailabilityRequest request = new BulkObjectAvailabilityRequest(type, objectIdsBulk);
                    BulkObjectAvailabilityResponse response = storageClient.checkBulkObjectAvailability(context.getStrategyId(), context.getOfferId(), request);
                    if (response.getAreObjectsAvailable()) continue;
                    for (String objectName : request.getObjectNames()) {
                        unavailableObjects.put((Object)context, (Object)objectName);
                    }
                }
            }
            ArrayListValuedHashMap arrayListValuedHashMap = unavailableObjects;
            return arrayListValuedHashMap;
        }
    }

    private Map<AccessRequestContext, List<String>> createAccessRequests(MultiValuedMap<AccessRequestContext, String> objectIdsByContext, DataCategory type) throws StorageServerClientException {
        LOGGER.debug("Create access requests if required");
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            HashMap accessRequests = new HashMap();
            for (AccessRequestContext context : objectIdsByContext.keySet()) {
                Collection objectIds = objectIdsByContext.get((Object)context);
                UnmodifiableIterator objectIdsIterator = Iterators.partition(objectIds.iterator(), (int)VitamConfiguration.getBatchSize());
                while (objectIdsIterator.hasNext()) {
                    List objectIdsBulk = (List)objectIdsIterator.next();
                    objectIdsBulk.forEach(item -> LOGGER.debug("Create access requests if required for " + context.getStrategyId() + " " + context.getOfferId() + " " + type + " " + item));
                    Optional accessRequestId = storageClient.createAccessRequestIfRequired(context.getStrategyId(), context.getOfferId(), type, objectIdsBulk);
                    accessRequestId.ifPresentOrElse(id -> accessRequests.computeIfAbsent(context, x -> new ArrayList()).add(id), () -> LOGGER.warn("Access Request was not created"));
                }
            }
            HashMap hashMap = accessRequests;
            return hashMap;
        }
    }
}

