/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.massprocessing.QueryType;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public abstract class CheckDistributionThresholdBase
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);
    private static final int QUERY_TYPE_IN_RANK = 0;
    private static final int QUERY_URI_IN_RANK = 1;
    private final MetaDataClientFactory metaDataClientFactory;

    protected CheckDistributionThresholdBase(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ItemStatus checkThreshold(HandlerIO handler, long defaultThreshold, String action) throws ProcessingException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            long threshold;
            String queryType = (String)handler.getInput(0);
            String queryUri = (String)handler.getInput(1);
            JsonNode queryNode = handler.getJsonFromWorkspace(queryUri);
            RequestMultiple multiQuery = this.getRequestMultiple(queryNode, queryType);
            SelectMultiQuery selectMultiQuery = this.getSelectCountFromQuery(multiQuery);
            ObjectNode finalSelect = selectMultiQuery.getFinalSelect();
            JsonNode response = client.selectUnits((JsonNode)finalSelect);
            RequestResponseOK responseOK = RequestResponseOK.getFromJsonNode((JsonNode)response);
            long total = responseOK.getHits().getTotal();
            Long requestThreshold = multiQuery.getThreshold();
            long l = threshold = requestThreshold != null ? requestThreshold : defaultThreshold;
            if (total > threshold) {
                ObjectNode eventDetails = JsonHandler.createObjectNode();
                eventDetails.put("error", "Too many units found. Threshold=" + threshold + ", found=" + total);
                ItemStatus itemStatus = PluginHelper.buildItemStatus(action, StatusCode.KO, eventDetails);
                return itemStatus;
            }
            if (total > defaultThreshold) {
                ObjectNode eventDetails = JsonHandler.createObjectNode();
                String errorMessage = String.format("Unit count exceeds default threshold. Default threshold=%d, found=%d", defaultThreshold, total);
                eventDetails.put("warning", errorMessage);
                ItemStatus itemStatus = PluginHelper.buildItemStatus(action, StatusCode.WARNING, eventDetails);
                return itemStatus;
            }
            ItemStatus itemStatus = PluginHelper.buildItemStatus(action, StatusCode.OK, null);
            return itemStatus;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            LOGGER.error(e);
            return PluginHelper.buildItemStatus(action, StatusCode.FATAL, null);
        }
    }

    private RequestMultiple getRequestMultiple(JsonNode queryNode, String queryTypeString) throws InvalidParseOperationException {
        SelectParserMultiple parser;
        QueryType queryType = QueryType.valueOf(queryTypeString);
        switch (queryType) {
            case SELECT: {
                parser = new SelectParserMultiple();
                break;
            }
            case UPDATE: {
                parser = new UpdateParserMultiple();
                break;
            }
            default: {
                throw new IllegalArgumentException(queryType.name());
            }
        }
        parser.parse(queryNode);
        return parser.getRequest();
    }

    public SelectMultiQuery getSelectCountFromQuery(RequestMultiple multiQuery) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
        String[] roots = multiQuery.getRoots().toArray(new String[0]);
        selectMultiQuery.addRoots(roots);
        Query[] queries = multiQuery.getQueries().toArray(new Query[0]);
        selectMultiQuery.addQueries(queries);
        selectMultiQuery.setLimitFilter(0L, 1L);
        selectMultiQuery.trackTotalHits(true);
        selectMultiQuery.setProjection(JsonHandler.getFromString((String)"{\"$fields\": { \"#id\": 1}}"));
        return selectMultiQuery;
    }
}

