/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.bulkatomicupdate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.ReportBody;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.batch.report.model.entry.BulkUpdateUnitMetadataReportEntry;
import fr.gouv.vitam.common.InternalActionKeysRetriever;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.utils.AccessContractRestrictionHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.utils.BufferedConsumer;
import fr.gouv.vitam.metadata.api.utils.BulkAtomicUpdateModelUtils;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryParallelProcessor;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryResultFailure;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryResultOK;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.QueryRestrictionConverter;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class PrepareBulkAtomicUpdate
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PrepareBulkAtomicUpdate.class);
    public static final String PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME = "PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST";
    private static final String ORIGIN_QUERY_KEY = "originQuery";
    private static final String QUERY_INDEX_KEY = "queryIndex";
    private static final String QUERY_NAME_IN = "query.json";
    private static final String ACCESS_CONTRACT_NAME_IN = "accessContract.json";
    private static final int DISTRIBUTION_FILE_RANK = 0;
    private final MetaDataClientFactory metaDataClientFactory;
    private final BatchReportClientFactory batchReportClientFactory;
    private final InternalActionKeysRetriever internalActionKeysRetriever;
    private final int batchSize;
    private final int threadPoolSize;
    private final int threadPoolQueueSize;

    public PrepareBulkAtomicUpdate() {
        this(MetaDataClientFactory.getInstance(), BatchReportClientFactory.getInstance(), new InternalActionKeysRetriever(), VitamConfiguration.getBulkAtomicUpdateBatchSize(), VitamConfiguration.getBulkAtomicUpdateThreadPoolSize(), VitamConfiguration.getBulkAtomicUpdateThreadPoolQueueSize());
    }

    @VisibleForTesting
    PrepareBulkAtomicUpdate(MetaDataClientFactory metaDataClientFactory, BatchReportClientFactory batchReportClientFactory, InternalActionKeysRetriever internalActionKeysRetriever, int batchSize, int threadPoolSize, int threadPoolQueueSize) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.batchReportClientFactory = batchReportClientFactory;
        this.internalActionKeysRetriever = internalActionKeysRetriever;
        this.batchSize = batchSize;
        this.threadPoolSize = threadPoolSize;
        this.threadPoolQueueSize = threadPoolQueueSize;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            ItemStatus itemStatus;
            AccessContractModel accessContractModel = this.loadAccessContract(handler);
            Iterator<JsonNode> queryIterator = this.loadQueries(handler);
            String distributionFileName = handler.getOutput(0).getPath();
            File distributionFile = handler.getNewLocalFile(distributionFileName);
            try (JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)new FileOutputStream(distributionFile));
                 MetaDataClient metadataClient = this.metaDataClientFactory.getClient();
                 BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
                itemStatus = this.processQueries(metadataClient, batchReportClient, accessContractModel, queryIterator, jsonLineWriter);
            }
            handler.transferFileToWorkspace(distributionFileName, distributionFile, true, false);
            return new ItemStatus(PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME).setItemsStatus(PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME, itemStatus);
        }
        catch (ProcessingException | IOException | RuntimeException e) {
            LOGGER.error("Bulk atomic update preparation failed", e);
            return this.buildFatalItemStatus(StatusCode.FATAL);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Bulk atomic update preparation failed", (Throwable)e);
            return this.buildFatalItemStatus(e.getStatusCode());
        }
    }

    private ItemStatus buildFatalItemStatus(StatusCode statusCode) {
        ItemStatus itemStatus = new ItemStatus(PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME);
        itemStatus.increment(statusCode);
        return new ItemStatus(PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME).setItemsStatus(PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME, itemStatus);
    }

    private AccessContractModel loadAccessContract(HandlerIO handler) throws ProcessingStatusException {
        try {
            JsonNode accessContractNode = handler.getJsonFromWorkspace(ACCESS_CONTRACT_NAME_IN);
            return (AccessContractModel)JsonHandler.getFromJsonNode((JsonNode)accessContractNode, AccessContractModel.class);
        }
        catch (InvalidParseOperationException | ProcessingException ex) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load access contract", ex);
        }
    }

    private Iterator<JsonNode> loadQueries(HandlerIO handler) throws ProcessingStatusException {
        try {
            JsonNode queryNodes = handler.getJsonFromWorkspace(QUERY_NAME_IN);
            return BulkAtomicUpdateModelUtils.getQueries((JsonNode)queryNodes).iterator();
        }
        catch (ProcessingException ex) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load queries", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ItemStatus processQueries(MetaDataClient metadataClient, BatchReportClient batchReportClient, AccessContractModel accessContractModel, Iterator<JsonNode> queryIterator, JsonLineWriter jsonLineWriter) throws ProcessingStatusException {
        try (BufferedConsumer<BulkSelectQueryResultOK> successReporter = PrepareBulkAtomicUpdate.createSuccessReporter(jsonLineWriter);){
            ItemStatus itemStatus;
            block16: {
                BufferedConsumer<BulkSelectQueryResultFailure> failureReporter = PrepareBulkAtomicUpdate.createFailureReporter(batchReportClient);
                try {
                    BulkSelectQueryParallelProcessor bulkSelectQueryParallelProcessor = new BulkSelectQueryParallelProcessor(metadataClient, this.internalActionKeysRetriever, this.threadPoolSize, this.threadPoolQueueSize, this.batchSize, successReporter, failureReporter, PrepareBulkAtomicUpdate.createAccessContractRestrictionConverter(accessContractModel), false);
                    bulkSelectQueryParallelProcessor.processQueries(queryIterator);
                    ItemStatus itemStatus2 = new ItemStatus(PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME);
                    if (bulkSelectQueryParallelProcessor.getNbOKs() > 0) {
                        itemStatus2.increment(StatusCode.OK, bulkSelectQueryParallelProcessor.getNbOKs());
                    }
                    if (bulkSelectQueryParallelProcessor.getNbWarnings() > 0) {
                        itemStatus2.increment(StatusCode.WARNING, bulkSelectQueryParallelProcessor.getNbWarnings());
                    }
                    itemStatus = itemStatus2;
                    if (failureReporter == null) break block16;
                }
                catch (Throwable throwable) {
                    if (failureReporter != null) {
                        try {
                            failureReporter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                failureReporter.close();
            }
            return itemStatus;
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.KO, "Query processing failed with KO", e);
        }
    }

    private static BufferedConsumer<BulkSelectQueryResultOK> createSuccessReporter(JsonLineWriter jsonLineWriter) {
        return new BufferedConsumer(VitamConfiguration.getBatchSize(), entries -> {
            List lines = entries.stream().map(PrepareBulkAtomicUpdate::createJsonLineEntry).collect(Collectors.toList());
            try {
                jsonLineWriter.addEntries(lines);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static JsonLineModel createJsonLineEntry(BulkSelectQueryResultOK bulkSelectQueryResultOK) {
        ObjectNode params = JsonHandler.createObjectNode();
        params.set(ORIGIN_QUERY_KEY, bulkSelectQueryResultOK.getQuery());
        params.put(QUERY_INDEX_KEY, bulkSelectQueryResultOK.getQueryIndex());
        return new JsonLineModel(bulkSelectQueryResultOK.getUnitId(), null, (JsonNode)params);
    }

    private static BufferedConsumer<BulkSelectQueryResultFailure> createFailureReporter(BatchReportClient batchReportClient) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String processId = VitamThreadUtils.getVitamSession().getRequestId();
        return new BufferedConsumer(VitamConfiguration.getBatchSize(), entries -> {
            List bufferedReportEntries = entries.stream().map(entry -> new BulkUpdateUnitMetadataReportEntry(Integer.valueOf(tenantId), processId, Integer.toString(entry.getQueryIndex()), JsonHandler.unprettyPrint((Object)entry.getQuery()), null, entry.getBulkUpdateUnitReportKey().name(), StatusCode.WARNING, String.format("%s.%s", PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST_PLUGIN_NAME, StatusCode.WARNING), entry.getMessage())).collect(Collectors.toList());
            try {
                ReportBody reportBody = new ReportBody();
                reportBody.setProcessId(processId);
                reportBody.setReportType(ReportType.BULK_UPDATE_UNIT);
                reportBody.setEntries(new ArrayList(bufferedReportEntries));
                batchReportClient.appendReportEntries(reportBody);
            }
            catch (VitamClientInternalException e) {
                throw new VitamRuntimeException((Throwable)e);
            }
        });
    }

    private static QueryRestrictionConverter createAccessContractRestrictionConverter(AccessContractModel accessContractModel) {
        return originalQuery -> AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)originalQuery, (AccessContractModel)accessContractModel);
    }
}

