/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.bulkatomicupdate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.utils.BulkAtomicUpdateModelUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public class CheckQueriesThreshold
extends ActionHandler {
    private final long DEFAULT_THRESHOLD = VitamConfiguration.getQueriesThreshold();
    private static final String CHECK_QUERIES_THRESHOLD_PLUGIN_NAME = "CHECK_QUERIES_THRESHOLD";
    private static final String QUERY_NAME_IN = "query.json";

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        long threshold;
        JsonNode queryNode = handler.getJsonFromWorkspace(QUERY_NAME_IN);
        Long queryThreshold = BulkAtomicUpdateModelUtils.getQueryThreshold((JsonNode)queryNode);
        long total = BulkAtomicUpdateModelUtils.queryCount((JsonNode)queryNode);
        long l = threshold = queryThreshold != null ? queryThreshold : this.DEFAULT_THRESHOLD;
        if (total > threshold) {
            ObjectNode eventDetails = JsonHandler.createObjectNode();
            eventDetails.put("error", String.format("Too many queries found. Threshold=%d, found=%d", threshold, total));
            return PluginHelper.buildItemStatus(CHECK_QUERIES_THRESHOLD_PLUGIN_NAME, StatusCode.KO, eventDetails);
        }
        if (total > this.DEFAULT_THRESHOLD) {
            ObjectNode eventDetails = JsonHandler.createObjectNode();
            eventDetails.put("warning", String.format("Queries count exceeds default threshold. Default threshold=%d, found=%d", this.DEFAULT_THRESHOLD, total));
            return PluginHelper.buildItemStatus(CHECK_QUERIES_THRESHOLD_PLUGIN_NAME, StatusCode.WARNING, eventDetails);
        }
        return PluginHelper.buildItemStatus(CHECK_QUERIES_THRESHOLD_PLUGIN_NAME, StatusCode.OK, null);
    }
}

