/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.bulkatomicupdate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.entry.BulkUpdateUnitMetadataReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.MetadataStorageHelper;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.model.logbook.LogbookLifecycle;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.api.model.UpdateUnit;
import fr.gouv.vitam.metadata.api.model.UpdateUnitKey;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkUpdateUnitReportKey;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.StoreMetadataObjectActionHandler;
import fr.gouv.vitam.worker.core.plugin.bulkatomicupdate.BulkAtomicUpdateQueryProcessItem;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.WorkspaceClientServerException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BulkAtomicUpdateProcess
extends StoreMetadataObjectActionHandler {
    public static final String BULK_ATOMIC_UPDATE_UNITS_PLUGIN_NAME = "BULK_ATOMIC_UPDATE_UNITS";
    public static final String ORIGINAL_QUERY_ROOT_KEY = "originQuery";
    public static final String QUERY_INDEX_KEY = "queryIndex";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);
    private static final String UNIT_METADATA_UPDATE = "UNIT_METADATA_UPDATE";
    private static final int METADATA_UPDATE_BATCH_SIZE = 8;
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory lfcClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final BatchReportClientFactory batchReportClientFactory;

    public BulkAtomicUpdateProcess() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance(), BatchReportClientFactory.getInstance());
    }

    public BulkAtomicUpdateProcess(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory lfcClientFactory, StorageClientFactory storageClientFactory, BatchReportClientFactory batchReportClientFactory) {
        super(storageClientFactory);
        this.metaDataClientFactory = metaDataClientFactory;
        this.lfcClientFactory = lfcClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.batchReportClientFactory = batchReportClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new IllegalStateException("UnsupportedOperation");
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            UnmodifiableIterator unitsIterator = Iterators.partition(workerParameters.getObjectNameList().iterator(), (int)8);
            ArrayList<ItemStatus> itemsStatus = new ArrayList<ItemStatus>();
            int batchOffset = 0;
            while (unitsIterator.hasNext()) {
                List bulkUnits = (List)unitsIterator.next();
                itemsStatus.addAll(this.executeBulk(workerParameters, handler, bulkUnits, batchOffset));
                batchOffset += 8;
            }
            return itemsStatus;
        }
        catch (BadRequestException e) {
            LOGGER.error("Client error while executing update requests", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private List<ItemStatus> executeBulk(WorkerParameters workerParameters, HandlerIO handler, List<String> bulkUnits, int batchOffset) throws BadRequestException, ProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean lfcAlreadyWrittenInMongo(LogbookLifeCyclesClient lfcClient, String unitId, String currentOperationId) throws VitamException {
        JsonNode lfc = lfcClient.getRawUnitLifeCycleById(unitId);
        LogbookLifecycle unitLFC = (LogbookLifecycle)JsonHandler.getFromJsonNode((JsonNode)lfc, LogbookLifecycle.class);
        return unitLFC.getEvents().stream().anyMatch(e -> e.getEvIdProc().equals(currentOperationId));
    }

    private void writeLfcToMongo(LogbookLifeCyclesClient lfcClient, WorkerParameters param, String unitId, String diff) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException, InvalidParseOperationException, InvalidGuidOperationException {
        LogbookLifeCycleUnitParameters logbookLfcParam = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()), (String)VitamLogbookMessages.getEventTypeLfc((String)UNIT_METADATA_UPDATE), (GUID)GUIDReader.getGUID((String)param.getContainerName()), (LogbookTypeProcess)param.getLogbookTypeProcess(), (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)UNIT_METADATA_UPDATE, (StatusCode)StatusCode.OK), (String)VitamLogbookMessages.getCodeLfc((String)UNIT_METADATA_UPDATE, (StatusCode)StatusCode.OK), (GUID)GUIDReader.getGUID((String)unitId));
        logbookLfcParam.putParameterValue(LogbookParameterName.eventDetailData, this.getEvDetDataForDiff(diff));
        lfcClient.update((LogbookLifeCycleParameters)logbookLfcParam, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
    }

    private String getEvDetDataForDiff(String diff) throws InvalidParseOperationException {
        if (diff == null) {
            return "";
        }
        ObjectNode diffObject = JsonHandler.createObjectNode();
        diffObject.put("diff", diff);
        diffObject.put("version", VitamConfiguration.getDiffVersion());
        return JsonHandler.writeAsString((Object)diffObject);
    }

    private void storeUnitAndLfcToOffer(MetaDataClient mdClient, LogbookLifeCyclesClient lfcClient, StorageClient storageClient, HandlerIO handler, WorkerParameters params, String guid, String fileName) throws VitamException {
        JsonNode unit = this.selectMetadataDocumentRawById(guid, DataCategory.UNIT, mdClient);
        String strategyId = MetadataDocumentHelper.getStrategyIdFromRawUnitOrGot((JsonNode)unit);
        MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)unit);
        JsonNode lfc = this.getRawLogbookLifeCycleById(guid, DataCategory.UNIT, lfcClient);
        JsonNode docWithLfc = MetadataStorageHelper.getUnitWithLFC((JsonNode)unit, (JsonNode)lfc);
        try {
            InputStream is = CanonicalJsonFormatter.serialize((JsonNode)docWithLfc);
            handler.transferInputStreamToWorkspace("Units/" + fileName, is, null, false);
        }
        catch (ProcessingException e) {
            LOGGER.error(params.getObjectName(), (Throwable)e);
            throw new WorkspaceClientServerException((Throwable)e);
        }
        String uri = "Units" + File.separator + fileName;
        ObjectDescription description = new ObjectDescription(DataCategory.UNIT, params.getContainerName(), fileName, uri);
        storageClient.storeFileFromWorkspace(strategyId, description.getType(), description.getObjectName(), description);
    }

    private void generateUpdateQuery(BulkAtomicUpdateQueryProcessItem item) throws InvalidParseOperationException, InvalidCreateOperationException {
        UpdateParserMultiple parser = new UpdateParserMultiple();
        parser.parse(item.getOriginalQuery());
        UpdateMultiQuery multiQuery = parser.getRequest();
        multiQuery.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{VitamThreadUtils.getVitamSession().getRequestId()})});
        multiQuery.resetQueries();
        multiQuery.resetRoots().addRoots(new String[]{item.getUnitId()});
        item.setFinalQuery((JsonNode)multiQuery.getFinalUpdate());
    }

    private void buildReport(WorkerParameters workerParameters, String key, StatusCode status, String message, BulkAtomicUpdateQueryProcessItem item) {
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        StatusCode reportStatus = status;
        if (UpdateUnitKey.UNIT_METADATA_NO_NEW_DATA.name().equals(key)) {
            reportStatus = StatusCode.WARNING;
        }
        BulkUpdateUnitMetadataReportEntry entry = new BulkUpdateUnitMetadataReportEntry(vitamSession.getTenantId(), workerParameters.getContainerName(), Integer.toString(item.getQueryIndex()), JsonHandler.unprettyPrint((Object)item.getOriginalQuery()), item.getUnitId(), key, reportStatus, String.format("%s.%s", this.getPluginId(), reportStatus), message);
        item.setReportEntry(entry);
    }

    private void checkUnitUpdateResponse(WorkerParameters workerParameters, HandlerIO handler, MetaDataClient mdClient, LogbookLifeCyclesClient lfcClient, StorageClient storageClient, BulkAtomicUpdateQueryProcessItem item, JsonNode updateResult) throws InvalidParseOperationException {
        RequestResponseOK responseOK;
        UpdateUnit updateUnit;
        if (RequestResponse.isRequestResponseOk((JsonNode)updateResult) && (updateUnit = (UpdateUnit)(responseOK = RequestResponseOK.getFromJsonNode((JsonNode)updateResult, UpdateUnit.class)).getFirstResult()) != null) {
            ItemStatus itemStatus = this.postUpdate(workerParameters, handler, mdClient, lfcClient, storageClient, item, updateUnit);
            item.setStatus(itemStatus);
            return;
        }
        VitamError error = VitamError.getFromJsonNode((JsonNode)updateResult);
        this.buildReport(workerParameters, BulkUpdateUnitReportKey.ERROR_METADATA_UPDATE.name(), StatusCode.KO, error.getDescription(), item);
        item.setStatus(PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.KO, PluginHelper.EventDetails.of(error.getDescription())));
    }

    private ItemStatus postUpdate(WorkerParameters workerParameters, HandlerIO handler, MetaDataClient mdClient, LogbookLifeCyclesClient lfcClient, StorageClient storageClient, BulkAtomicUpdateQueryProcessItem item, UpdateUnit unitNode) {
        String unitId = unitNode.getUnitId();
        String key = unitNode.getKey().name();
        String statusAsString = unitNode.getStatus().name();
        StatusCode status = StatusCode.valueOf((String)statusAsString);
        String message = unitNode.getMessage();
        String diff = unitNode.getDiff();
        if (!(StatusCode.KO.equals((Object)status) || StatusCode.FATAL.equals((Object)status) || StatusCode.OK.equals((Object)status))) {
            throw new VitamRuntimeException(String.format("Status must be of type KO, FATAL or OK here '%s'.", status));
        }
        this.buildReport(workerParameters, key, status, message, item);
        if (StatusCode.KO.equals((Object)status) || StatusCode.FATAL.equals((Object)status)) {
            return PluginHelper.buildItemStatus(this.getPluginId(), status, PluginHelper.EventDetails.of(message));
        }
        if (UpdateUnitKey.UNIT_METADATA_NO_CHANGES.name().equals(key)) {
            try {
                if (this.lfcAlreadyWrittenInMongo(lfcClient, unitId, workerParameters.getContainerName())) {
                    LOGGER.warn(String.format("There is no changes on the unit '%s', and LFC already written in mongo, this unit will be save in offer.", unitId));
                    this.storeUnitAndLfcToOffer(mdClient, lfcClient, storageClient, handler, workerParameters, unitId, unitId + ".json");
                    return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.OK, PluginHelper.EventDetails.of("Bulk atomic update OK"));
                }
            }
            catch (VitamException e) {
                LOGGER.error((Throwable)e);
                return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("Error while storing UNIT with LFC '%s'.", e.getMessage())));
            }
        }
        if (UpdateUnitKey.UNIT_METADATA_NO_NEW_DATA.name().equals(key)) {
            return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.WARNING, PluginHelper.EventDetails.of("Bulk atomic update WARNING"));
        }
        try {
            this.writeLfcToMongo(lfcClient, workerParameters, unitId, diff);
        }
        catch (InvalidGuidOperationException | InvalidParseOperationException | LogbookClientNotFoundException | LogbookClientServerException e) {
            LOGGER.error(e);
            return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("Error '%s' while updating UNIT LFC.", e.getMessage())));
        }
        catch (LogbookClientBadRequestException e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.KO, PluginHelper.EventDetails.of(String.format("Error '%s' while updating UNIT LFC.", e.getMessage())));
        }
        try {
            this.storeUnitAndLfcToOffer(mdClient, lfcClient, storageClient, handler, workerParameters, unitId, unitId + ".json");
        }
        catch (VitamException e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("Error while storing UNIT with LFC '%s'.", e.getMessage())));
        }
        return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.OK, PluginHelper.EventDetails.of("Bulk atomic update OK"));
    }

    protected String getPluginId() {
        return BULK_ATOMIC_UPDATE_UNITS_PLUGIN_NAME;
    }
}

