/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.bulkatomicupdate;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.worker.core.plugin.UpdateUnitFinalize;
import java.util.Map;
import java.util.Optional;

public class BulkAtomicUpdateFinalize
extends UpdateUnitFinalize {
    private static final String BULK_ATOMIC_UPDATE_FINALIZE_PLUGIN_NAME = "BULK_ATOMIC_UPDATE_FINALIZE";

    public BulkAtomicUpdateFinalize() {
        this(BatchReportClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance(), StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    private BulkAtomicUpdateFinalize(BatchReportClientFactory batchReportClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, StorageClientFactory storageClientFactory) {
        super(batchReportClientFactory, logbookOperationsClientFactory, storageClientFactory);
    }

    @Override
    protected ReportSummary getReport(LogbookOperation logbook) {
        int nbWarning;
        Optional<LogbookEventOperation> logbookEventPrepare = logbook.getEvents().stream().filter(e -> e.getEvType().startsWith("PREPARE_BULK_ATOMIC_UPDATE_UNIT_LIST")).reduce((a, b) -> b);
        Optional<LogbookEventOperation> logbookEventUpdate = logbook.getEvents().stream().filter(e -> e.getEvType().startsWith("BULK_ATOMIC_UPDATE_UNITS")).reduce((a, b) -> b);
        String startDate = logbook.getEvDateTime();
        String endDate = LocalDateUtil.nowFormatted();
        if (logbookEventPrepare.isEmpty()) {
            return new ReportSummary(startDate, endDate, ReportType.BULK_UPDATE_UNIT, null, null);
        }
        Map<StatusCode, Integer> codesNumberPrepare = this.getStatusStatistic((LogbookEvent)logbookEventPrepare.get());
        int nbOk = 0;
        int nbKo = codesNumberPrepare.get(StatusCode.KO) == null ? 0 : codesNumberPrepare.get(StatusCode.KO);
        int n = nbWarning = codesNumberPrepare.get(StatusCode.WARNING) == null ? 0 : codesNumberPrepare.get(StatusCode.WARNING);
        if (logbookEventUpdate.isEmpty()) {
            ReportResults results = new ReportResults(Integer.valueOf(nbOk), Integer.valueOf(nbKo), Integer.valueOf(nbWarning));
            return new ReportSummary(startDate, endDate, ReportType.BULK_UPDATE_UNIT, results, null);
        }
        Map<StatusCode, Integer> codesNumber = this.getStatusStatistic((LogbookEvent)logbookEventUpdate.get());
        nbOk = codesNumber.get(StatusCode.OK) == null ? nbOk : nbOk + codesNumber.get(StatusCode.OK);
        nbKo = codesNumber.get(StatusCode.KO) == null ? nbKo : nbKo + codesNumber.get(StatusCode.KO);
        nbWarning = codesNumber.get(StatusCode.WARNING) == null ? nbWarning : nbWarning + codesNumber.get(StatusCode.WARNING);
        ReportResults results = new ReportResults(Integer.valueOf(nbOk), Integer.valueOf(nbKo), Integer.valueOf(nbWarning));
        return new ReportSummary(startDate, endDate, ReportType.BULK_UPDATE_UNIT, results, null);
    }

    @Override
    protected String getPluginId() {
        return BULK_ATOMIC_UPDATE_FINALIZE_PLUGIN_NAME;
    }

    @Override
    protected String getUpdateType() {
        return "BulkAtomicUpdate";
    }

    @Override
    protected String getUpdateActionKey() {
        return "BULK_ATOMIC_UPDATE_UNITS";
    }

    @Override
    protected ReportType getReportType() {
        return ReportType.BULK_UPDATE_UNIT;
    }
}

