/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObject;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObjectGroup;
import fr.gouv.vitam.worker.core.utils.GroupByObjectIterator;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AuditPreparePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditPreparePlugin.class);
    private static final String AUDIT_PREPARATION = "LIST_OBJECTGROUP_ID";
    protected static final String OBJECT_GROUPS_TO_AUDIT_JSONL = "AUDIT_OG";
    private final MetaDataClientFactory metaDataClientFactory;

    public AuditPreparePlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    AuditPreparePlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        ItemStatus itemStatus;
        block8: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                boolean isInternalAudit = handler.isExistingFileInWorkspace("scheduler_audit");
                JsonNode initialQuery = handler.getJsonFromWorkspace("query.json");
                SelectMultiQuery query = this.generateAuditQuery(initialQuery);
                this.computePreparation(query, handler, metaDataClient);
                ObjectNode evDetData = isInternalAudit ? this.computeEventData(initialQuery) : JsonHandler.createObjectNode();
                itemStatus = PluginHelper.buildItemStatus(AUDIT_PREPARATION, StatusCode.OK, evDetData);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable isInternalAudit) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable) {
                            isInternalAudit.addSuppressed(throwable);
                        }
                    }
                    throw isInternalAudit;
                }
                catch (InvalidParseOperationException | ProcessingException | IOException e) {
                    LOGGER.error(String.format("Audit action failed with status [%s]", StatusCode.FATAL), e);
                    ObjectNode error = JsonHandler.createObjectNode().put("error", e.getMessage());
                    return PluginHelper.buildItemStatus(AUDIT_PREPARATION, StatusCode.FATAL, error);
                }
            }
            metaDataClient.close();
        }
        return itemStatus;
    }

    private JsonNode computeEventData(JsonNode initialQuery) {
        ObjectNode objectNode;
        block9: {
            MetaDataClient client = this.metaDataClientFactory.getClient();
            try {
                SelectParserMultiple parser = new SelectParserMultiple();
                parser.parse(initialQuery);
                SelectMultiQuery request = parser.getRequest();
                request.addOrderByDescFilter(new String[]{VitamFieldsHelper.approximateUpdateDate()});
                request.setLimitFilter(0L, 1L);
                request.addUsedProjection(new String[]{VitamFieldsHelper.approximateUpdateDate()});
                JsonNode jsonNode = client.selectUnits((JsonNode)request.getFinalSelect());
                RequestResponseOK fromJsonNode = RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
                JsonNode lastUnit = (JsonNode)fromJsonNode.getFirstResult();
                if (lastUnit == null) {
                    throw new VitamRuntimeException("Could not find unit");
                }
                String date = lastUnit.get(VitamFieldsHelper.approximateUpdateDate()).asText();
                objectNode = JsonHandler.createObjectNode().put("Last_Update_Date", date);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            client.close();
        }
        return objectNode;
    }

    private void computePreparation(SelectMultiQuery selectMultiQuery, HandlerIO handler, MetaDataClient metaDataClient) throws IOException, InvalidParseOperationException, ProcessingException {
        ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(metaDataClient, selectMultiQuery);
        SpliteratorIterator iterator = new SpliteratorIterator(scrollRequest);
        Iterator<Pair<String, String>> gotIdUnitIdIterator = this.getGotIdUnitIdIterator((Iterator<JsonNode>)iterator);
        GroupByObjectIterator unitsByObjectGroupIterator = new GroupByObjectIterator(gotIdUnitIdIterator);
        UnmodifiableIterator unitsByObjectGroupBulkIterator = Iterators.partition((Iterator)unitsByObjectGroupIterator, (int)VitamConfiguration.getBatchSize());
        File objectGroupsToAudit = handler.getNewLocalFile(OBJECT_GROUPS_TO_AUDIT_JSONL);
        try (FileOutputStream outputStream = new FileOutputStream(objectGroupsToAudit);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)outputStream);){
            while (unitsByObjectGroupBulkIterator.hasNext()) {
                List bulkToProcess = (List)unitsByObjectGroupBulkIterator.next();
                this.processBulk(bulkToProcess, writer);
            }
        }
        handler.transferFileToWorkspace(OBJECT_GROUPS_TO_AUDIT_JSONL, objectGroupsToAudit, true, false);
    }

    private void processBulk(List<Pair<String, List<String>>> unitsByObjectGroupBulkIterator, JsonLineWriter writer) throws InvalidParseOperationException, IOException {
        HashMap tempUnitsByObjectGroupMap = new HashMap();
        unitsByObjectGroupBulkIterator.forEach(item -> tempUnitsByObjectGroupMap.put((String)item.getKey(), (List)item.getValue()));
        List<ObjectGroupResponse> objectModelsForUnitResults = this.getObjectModelsForUnitResults(tempUnitsByObjectGroupMap.keySet());
        for (ObjectGroupResponse objectGroup : objectModelsForUnitResults) {
            List unitIds = (List)tempUnitsByObjectGroupMap.get(objectGroup.getId());
            AuditObjectGroup auditDistributionLine = this.createAuditDistributionLine(unitIds, objectGroup);
            writer.addEntry(new JsonLineModel(auditDistributionLine.getId(), null, JsonHandler.toJsonNode((Object)auditDistributionLine)));
        }
    }

    private SelectMultiQuery generateAuditQuery(JsonNode initialQuery) {
        try {
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(initialQuery);
            SelectMultiQuery selectMultiQuery = parser.getRequest();
            ObjectNode projectionNode = this.getQueryProjectionToApply();
            selectMultiQuery.setProjection((JsonNode)projectionNode);
            selectMultiQuery.addOrderByAscFilter(new String[]{ParserTokens.PROJECTIONARGS.OBJECT.exactToken()});
            ArrayList queryList = new ArrayList(parser.getRequest().getQueries());
            if (queryList.isEmpty()) {
                selectMultiQuery.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ParserTokens.PROJECTIONARGS.OBJECT.exactToken())}).setDepthLimit(0)});
                return selectMultiQuery;
            }
            for (int i = 0; i < queryList.size(); ++i) {
                Query query = (Query)queryList.get(i);
                BooleanQuery restrictedQuery = QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ParserTokens.PROJECTIONARGS.OBJECT.exactToken()), query});
                parser.getRequest().getQueries().set(i, restrictedQuery);
            }
            return selectMultiQuery;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private Iterator<Pair<String, String>> getGotIdUnitIdIterator(Iterator<JsonNode> iterator) {
        return IteratorUtils.transformedIterator(iterator, item -> new ImmutablePair((Object)item.get(ParserTokens.PROJECTIONARGS.OBJECT.exactToken()).asText(), (Object)item.get(ParserTokens.PROJECTIONARGS.ID.exactToken()).asText()));
    }

    private ObjectNode getQueryProjectionToApply() {
        ObjectNode projectionNode = JsonHandler.createObjectNode();
        ObjectNode fields = JsonHandler.createObjectNode();
        fields.put(ParserTokens.PROJECTIONARGS.ID.exactToken(), 1);
        fields.put(ParserTokens.PROJECTIONARGS.OBJECT.exactToken(), 1);
        projectionNode.set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)fields);
        return projectionNode;
    }

    private List<ObjectGroupResponse> getObjectModelsForUnitResults(Collection<String> objectGroupIds) {
        try {
            Select select = new Select();
            String[] ids = objectGroupIds.toArray(new String[0]);
            select.setQuery((Query)QueryHelper.in((String)"#id", (String[])ids));
            ObjectNode finalSelect = select.getFinalSelect();
            JsonNode response = this.metaDataClientFactory.getClient().selectObjectGroups((JsonNode)finalSelect);
            JsonNode results = response.get("$results");
            return (List)JsonHandler.getFromStringAsTypeReference((String)results.toString(), (TypeReference)new TypeReference<List<ObjectGroupResponse>>(){});
        }
        catch (InvalidFormatException | InvalidCreateOperationException | VitamException e) {
            throw new IllegalStateException(e);
        }
    }

    private AuditObjectGroup createAuditDistributionLine(List<String> unitUps, ObjectGroupResponse objectGroup) {
        AuditObjectGroup auditDistributionLine = new AuditObjectGroup();
        auditDistributionLine.setId(objectGroup.getId());
        auditDistributionLine.setOpi(objectGroup.getOpi());
        auditDistributionLine.setSp(objectGroup.getOriginatingAgency());
        auditDistributionLine.setUnitUps(unitUps);
        auditDistributionLine.setObjects(new ArrayList<AuditObject>());
        auditDistributionLine.setStorage(objectGroup.getStorage());
        for (QualifiersModel qualifier : objectGroup.getQualifiers()) {
            for (VersionsModel version : qualifier.getVersions()) {
                AuditObject binaryObject = new AuditObject();
                binaryObject.setId(version.getId());
                binaryObject.setOpi(version.getOpi());
                binaryObject.setAlgorithm(version.getAlgorithm());
                binaryObject.setMessageDigest(version.getMessageDigest());
                binaryObject.setQualifier(qualifier.getQualifier());
                binaryObject.setVersion(version.getDataObjectVersion());
                binaryObject.setStorage(version.getStorage());
                auditDistributionLine.getObjects().add(binaryObject);
            }
        }
        return auditDistributionLine;
    }
}

