/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.StorageJson;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyNotFoundException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyUtils;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditCheckObjectGroupResult;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditCheckObjectResult;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObject;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObjectGroup;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AuditIntegrityService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditIntegrityService.class);
    public static final String CHECK_INTEGRITY_ID = "AUDIT_FILE_INTEGRITY";
    private static final String PHYSICAL_MASTER = "PhysicalMaster";
    private static final String DIGEST = "digest";
    private static final String PROBLEM_OCCURED_MSG = "A problem occured when checking information from offer : ";
    private final StorageClientFactory storageClientFactory;

    public AuditIntegrityService() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public AuditIntegrityService(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public AuditCheckObjectGroupResult check(AuditObjectGroup gotDetail, List<StorageStrategy> storageStrategies) throws ProcessingStatusException {
        AuditCheckObjectGroupResult result = new AuditCheckObjectGroupResult();
        result.setIdObjectGroup(gotDetail.getId());
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            for (AuditObject object : gotDetail.getObjects()) {
                if (PHYSICAL_MASTER.equals(object.getQualifier())) {
                    LOGGER.info(String.format("Skip checking object %s due to its Physical Master type.", object.getId()));
                    continue;
                }
                AuditCheckObjectResult auditCheckObjectResult = new AuditCheckObjectResult();
                auditCheckObjectResult.setIdObject(object.getId());
                StorageJson storageInformation = object.getStorage();
                List offerIds = StorageStrategyUtils.loadOfferIds((String)storageInformation.getStrategyId(), storageStrategies);
                JsonNode offerToMetadata = storageClient.getInformation(storageInformation.getStrategyId(), DataCategory.OBJECT, object.getId(), offerIds, true);
                for (String offerId : offerIds) {
                    JsonNode metadata = offerToMetadata.findValue(offerId);
                    if (object.getMessageDigest() == null || metadata == null || !metadata.has(DIGEST)) {
                        LOGGER.warn(String.format("A problem occured when checking information from offer : Object Digest is %s and metadata size is  %s", object.getMessageDigest(), metadata == null ? 0 : metadata.size()));
                        auditCheckObjectResult.getOfferStatuses().put(offerId, StatusCode.KO);
                        continue;
                    }
                    String digest = metadata.get(DIGEST).asText();
                    if (StringUtils.equals((String)object.getMessageDigest(), (String)digest)) {
                        auditCheckObjectResult.getOfferStatuses().put(offerId, StatusCode.OK);
                        continue;
                    }
                    LOGGER.warn(String.format("A problem occured when checking information from offer : Object Digest %s is different then object metadata digest %s", object.getMessageDigest(), digest));
                    auditCheckObjectResult.getOfferStatuses().put(offerId, StatusCode.KO);
                }
                result.getObjectStatuses().add(auditCheckObjectResult);
            }
            result.setStatus(result.getObjectsGlobalStatus());
        }
        catch (StorageClientException | StorageStrategyNotFoundException e) {
            LOGGER.error("Storage server errors : ", e);
            throw new ProcessingStatusException(StatusCode.FATAL, String.format("Storage server errors : %s", e));
        }
        if (result.getStatus() == null) {
            result.setStatus(StatusCode.OK);
        }
        return result;
    }
}

