/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.audit.AuditReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Map;

public class AuditFinalizePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditFinalizePlugin.class);
    private static final String OBJECT_AUDIT_FINALIZE = "REPORT_AUDIT";
    private final AuditReportService auditReportService;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public AuditFinalizePlugin() {
        this(new AuditReportService(), LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    AuditFinalizePlugin(AuditReportService auditReportService, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.auditReportService = auditReportService;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.generateAuditReportToWorkspace(param, handler);
            this.storeReportToOffers(param.getContainerName());
            this.cleanupReport(param);
            LOGGER.info("Audit object finalization succeeded");
            return PluginHelper.buildItemStatus(OBJECT_AUDIT_FINALIZE, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Audit object  finalization failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(OBJECT_AUDIT_FINALIZE, e.getStatusCode(), null);
        }
    }

    private void generateAuditReportToWorkspace(WorkerParameters param, HandlerIO handler) throws ProcessingStatusException, ProcessingException {
        if (this.auditReportService.isReportWrittenInWorkspace(param.getContainerName())) {
            return;
        }
        Map mapParameters = param.getMapParameters();
        JsonNode initialQuery = handler.getJsonFromWorkspace("query.json");
        JsonNode logbookOperation = this.getLogbookOperation(param.getContainerName());
        OperationSummary operationSummary = this.computeLogbookInformation(param.getContainerName(), logbookOperation);
        ReportSummary reportSummary = this.computeReportSummary(logbookOperation);
        ObjectNode context = JsonHandler.createObjectNode();
        context.put(WorkerParameterName.auditActions.name(), (String)mapParameters.get(WorkerParameterName.auditActions));
        context.put("auditType", (String)mapParameters.get(WorkerParameterName.auditType));
        if (mapParameters.containsKey(WorkerParameterName.objectId)) {
            context.put("objectId", (String)mapParameters.get(WorkerParameterName.objectId));
        }
        context.set("query", initialQuery);
        Report reportInfo = new Report(operationSummary, reportSummary, (JsonNode)context);
        this.auditReportService.storeReportToWorkspace(reportInfo);
    }

    private OperationSummary computeLogbookInformation(String processId, JsonNode logbookOperation) throws ProcessingStatusException {
        try {
            if (!logbookOperation.has("events") || !logbookOperation.get("events").isArray()) {
                throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate report summary : no events");
            }
            ArrayNode events = (ArrayNode)logbookOperation.get("events");
            if (events.size() <= 2) {
                throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate report summary : not enougth events");
            }
            JsonNode lastEvent = events.get(events.size() - 2);
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            String evId = processId;
            String evType = logbookOperation.get("evType").asText();
            String outcome = lastEvent.get("outcome").asText();
            String outDetail = lastEvent.get("outDetail").asText();
            String outMsg = lastEvent.get("outMessg").asText();
            JsonNode evDetData = JsonHandler.getFromString((String)lastEvent.get("evDetData").asText());
            JsonNode rSI = JsonHandler.getFromString((String)logbookOperation.get("rightsStatementIdentifier").asText());
            OperationSummary operationSummary = new OperationSummary(tenantId, evId, evType, outcome, outDetail, outMsg, rSI, evDetData);
            return operationSummary;
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate report", e);
        }
    }

    private ReportSummary computeReportSummary(JsonNode logbookOperation) {
        String startDate = logbookOperation.get("evDateTime").asText();
        String endDate = LocalDateUtil.nowFormatted();
        ReportType reportType = ReportType.AUDIT;
        ReportResults vitamResults = new ReportResults();
        ObjectNode extendedInfo = JsonHandler.createObjectNode();
        return new ReportSummary(startDate, endDate, reportType, vitamResults, (JsonNode)extendedInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode getLogbookOperation(String operationId) throws ProcessingStatusException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            JsonNode logbookResponse = client.selectOperationById(operationId);
            if (!logbookResponse.has("$results")) throw new ProcessingStatusException(StatusCode.FATAL, "Could not find operation in logbook");
            if (!logbookResponse.get("$results").isArray()) throw new ProcessingStatusException(StatusCode.FATAL, "Could not find operation in logbook");
            ArrayNode results = (ArrayNode)logbookResponse.get("$results");
            if (results.size() <= 0) throw new ProcessingStatusException(StatusCode.FATAL, "Could not find operation in logbook");
            JsonNode jsonNode = results.get(0);
            return jsonNode;
        }
        catch (InvalidParseOperationException | LogbookClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Error while retrieving logbook operation", e);
        }
    }

    private void storeReportToOffers(String containerName) throws ProcessingStatusException {
        this.auditReportService.storeReportToOffers(containerName);
    }

    private void cleanupReport(WorkerParameters param) throws ProcessingStatusException {
        this.auditReportService.cleanupReport(param.getContainerName());
    }
}

