/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.audit;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.StorageRacineModel;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyNotFoundException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyUtils;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditCheckObjectGroupResult;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditCheckObjectResult;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObject;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObjectGroup;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

public class AuditExistenceService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditExistenceService.class);
    public static final String CHECK_EXISTENCE_ID = "AUDIT_FILE_EXISTING";
    private static final String PHYSICAL_MASTER = "PhysicalMaster";
    private final StorageClientFactory storageClientFactory;

    public AuditExistenceService() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public AuditExistenceService(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public AuditCheckObjectGroupResult check(AuditObjectGroup gotDetail, List<StorageStrategy> storageStrategies) throws ProcessingStatusException {
        AuditCheckObjectGroupResult result = new AuditCheckObjectGroupResult();
        result.setIdObjectGroup(gotDetail.getId());
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            for (AuditObject object : gotDetail.getObjects()) {
                Map existsResult;
                List offerIds;
                StorageRacineModel storageInformation;
                AuditCheckObjectResult auditCheckObjectResult = new AuditCheckObjectResult();
                auditCheckObjectResult.setIdObject(object.getId());
                if (PHYSICAL_MASTER.equals(object.getQualifier())) {
                    storageInformation = gotDetail.getStorage();
                    offerIds = StorageStrategyUtils.loadOfferIds((String)storageInformation.getStrategyId(), storageStrategies);
                    existsResult = storageClient.exists(storageInformation.getStrategyId(), DataCategory.OBJECT, object.getId(), offerIds);
                    auditCheckObjectResult.getOfferStatuses().putAll(existsResult.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> BooleanUtils.isTrue((Boolean)((Boolean)e.getValue())) ? StatusCode.KO : StatusCode.OK)));
                } else {
                    storageInformation = object.getStorage();
                    offerIds = StorageStrategyUtils.loadOfferIds((String)storageInformation.getStrategyId(), storageStrategies);
                    existsResult = storageClient.exists(storageInformation.getStrategyId(), DataCategory.OBJECT, object.getId(), offerIds);
                    auditCheckObjectResult.getOfferStatuses().putAll(existsResult.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> BooleanUtils.isTrue((Boolean)((Boolean)e.getValue())) ? StatusCode.OK : StatusCode.KO)));
                }
                result.getObjectStatuses().add(auditCheckObjectResult);
            }
            result.setStatus(result.getObjectsGlobalStatus());
        }
        catch (StorageClientException | StorageStrategyNotFoundException e2) {
            LOGGER.error("Storage server errors : ", e2);
            throw new ProcessingStatusException(StatusCode.FATAL, String.format("Storage server errors : %s", e2));
        }
        if (result.getStatus() == null) {
            result.setStatus(StatusCode.OK);
        }
        return result;
    }
}

