/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.audit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.ReportItemStatus;
import fr.gouv.vitam.batch.report.model.ReportStatus;
import fr.gouv.vitam.batch.report.model.entry.AuditObjectGroupReportEntry;
import fr.gouv.vitam.batch.report.model.entry.AuditObjectVersion;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.audit.AuditExistenceService;
import fr.gouv.vitam.worker.core.plugin.audit.AuditIntegrityService;
import fr.gouv.vitam.worker.core.plugin.audit.AuditReportService;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditCheckObjectGroupResult;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditCheckObjectResult;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObject;
import fr.gouv.vitam.worker.core.plugin.audit.model.AuditObjectGroup;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;

public class AuditCheckObjectPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditCheckObjectPlugin.class);
    public static final String AUDIT_CHECK_OBJECT = "AUDIT_CHECK_OBJECT";
    private static final int STRATEGIES_IN_RANK = 0;
    private final AuditExistenceService auditExistenceService;
    private final AuditIntegrityService auditIntegrityService;
    private final AuditReportService auditReportService;

    public AuditCheckObjectPlugin() {
        this(new AuditExistenceService(), new AuditIntegrityService(), new AuditReportService());
    }

    @VisibleForTesting
    AuditCheckObjectPlugin(AuditExistenceService auditExistenceService, AuditIntegrityService auditIntegrityService, AuditReportService auditReportService) {
        this.auditExistenceService = auditExistenceService;
        this.auditIntegrityService = auditIntegrityService;
        this.auditReportService = auditReportService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        LOGGER.debug("Starting audit");
        try {
            return this.executeAudit(param, handler);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Audit action failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(AUDIT_CHECK_OBJECT, e.getStatusCode(), null);
        }
    }

    private ItemStatus executeAudit(WorkerParameters param, HandlerIO handler) throws ProcessingStatusException {
        ItemStatus itemStatus = new ItemStatus(AUDIT_CHECK_OBJECT);
        Map mapParameters = param.getMapParameters();
        String action = (String)mapParameters.get(WorkerParameterName.auditActions);
        AuditObjectGroup gotDetail = this.loadAuditLine(param);
        List<StorageStrategy> storageStrategies = this.loadStorageStrategies(handler);
        String actionType = null;
        AuditCheckObjectGroupResult result = null;
        if ("AUDIT_FILE_EXISTING".equals(action)) {
            result = this.auditExistenceService.check(gotDetail, storageStrategies);
            actionType = "AUDIT_FILE_EXISTING";
        } else if ("AUDIT_FILE_INTEGRITY".equals(action)) {
            result = this.auditIntegrityService.check(gotDetail, storageStrategies);
            actionType = "AUDIT_FILE_INTEGRITY";
        }
        this.addReportEntry(param.getContainerName(), this.createAuditObjectGroupReportEntry(gotDetail, result, actionType));
        itemStatus.setItemsStatus(actionType, PluginHelper.buildItemStatus(actionType, result.getStatus(), null));
        if (actionType != null && itemStatus.getGlobalStatus().isGreaterOrEqualToKo()) {
            itemStatus.setGlobalOutcomeDetailSubcode(actionType);
        }
        return new ItemStatus(AUDIT_CHECK_OBJECT).setItemsStatus(AUDIT_CHECK_OBJECT, itemStatus);
    }

    private AuditObjectGroup loadAuditLine(WorkerParameters param) throws ProcessingStatusException {
        AuditObjectGroup auditDistributionLine;
        try {
            auditDistributionLine = (AuditObjectGroup)JsonHandler.getFromJsonNode((JsonNode)param.getObjectMetadata(), AuditObjectGroup.class);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load audit object group data", e);
        }
        return auditDistributionLine;
    }

    private List<StorageStrategy> loadStorageStrategies(HandlerIO handler) throws ProcessingStatusException {
        try {
            return (List)JsonHandler.getFromFileAsTypeReference((File)((File)handler.getInput(0)), (TypeReference)new TypeReference<List<StorageStrategy>>(){});
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load storage strategies datas", e);
        }
    }

    private AuditObjectGroupReportEntry createAuditObjectGroupReportEntry(AuditObjectGroup gotDetail, AuditCheckObjectGroupResult result, String outcome) {
        AuditObjectGroupReportEntry auditObjectGroupReportEntry = new AuditObjectGroupReportEntry(gotDetail.getId(), gotDetail.getUnitUps(), gotDetail.getSp(), gotDetail.getOpi(), new ArrayList(), ReportStatus.parseFromStatusCode((StatusCode)result.getStatus()), outcome);
        for (AuditCheckObjectResult objectResult : result.getObjectStatuses()) {
            AuditObject auditObject = (AuditObject)IterableUtils.find(gotDetail.getObjects(), object -> object.getId().equals(objectResult.getIdObject()));
            String strategyId = null;
            if (auditObject.getStorage() != null) {
                strategyId = auditObject.getStorage().getStrategyId();
            }
            AuditObjectVersion objectVersion = new AuditObjectVersion(auditObject.getId(), auditObject.getOpi(), auditObject.getQualifier(), auditObject.getVersion(), strategyId, objectResult.getOfferStatuses().entrySet().stream().map(e -> new ReportItemStatus((String)e.getKey(), ReportStatus.parseFromStatusCode((StatusCode)((StatusCode)e.getValue())))).collect(Collectors.toList()), ReportStatus.parseFromStatusCode((StatusCode)objectResult.getGlobalStatus()));
            auditObjectGroupReportEntry.getObjectVersions().add(objectVersion);
        }
        return auditObjectGroupReportEntry;
    }

    private void addReportEntry(String processId, AuditObjectGroupReportEntry entry) throws ProcessingStatusException {
        this.auditReportService.appendEntries(processId, Arrays.asList(entry));
    }
}

