/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class UpdateUnitFinalize
extends ActionHandler {
    static final String JSONL_EXTENSION = ".jsonl";
    static final String WORKSPACE_REPORT_URI = "report.jsonl";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UpdateUnitFinalize.class);
    private static final String DETAILS = " Detail= ";
    private final BatchReportClientFactory batchReportClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final StorageClientFactory storageClientFactory;

    public UpdateUnitFinalize() {
        this(BatchReportClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance(), StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    protected UpdateUnitFinalize(BatchReportClientFactory batchReportClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, StorageClientFactory storageClientFactory) {
        this.batchReportClientFactory = batchReportClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            ReportResults reportResult = this.storeReportToWorkspace(param, handler);
            this.storeReportToOffers(param);
            this.cleanupReport(param);
            if (reportResult == null) {
                return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.WARNING, PluginHelper.EventDetails.of(this.getUpdateType() + " report generation WARNING. Vitam results are absent, seems to be not logbook events..."));
            }
            if (reportResult.getNbKo() != 0 || reportResult.getNbWarning() != 0) {
                return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.WARNING, PluginHelper.EventDetails.of(this.getUpdateType() + " report generation WARNING. Some update operations have a KO or WARNING status."));
            }
            if (reportResult.getTotal() == 0 || reportResult.getNbOk() == 0) {
                return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.KO, PluginHelper.EventDetails.of(this.getUpdateType() + " report generation KO. No update done."));
            }
            return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.OK, PluginHelper.EventDetails.of(this.getUpdateType() + " report generation OK."));
        }
        catch (InvalidParseOperationException | VitamClientInternalException | LogbookClientException | StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException e) {
            LOGGER.error(e);
            return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.FATAL, PluginHelper.EventDetails.of("Client error when generating report."));
        }
    }

    private ReportResults storeReportToWorkspace(WorkerParameters param, HandlerIO handler) throws ProcessingException, InvalidParseOperationException, LogbookClientException, VitamClientInternalException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            if (handler.isExistingFileInWorkspace(WORKSPACE_REPORT_URI)) {
                JsonNode report = handler.getJsonFromWorkspace(WORKSPACE_REPORT_URI);
                ReportResults reportResults = ((Report)JsonHandler.getFromJsonNode((JsonNode)report, Report.class)).getReportSummary().getVitamResults();
                return reportResults;
            }
            Report reportInfo = this.generateReport(param);
            batchReportClient.storeReportToWorkspace(reportInfo);
            ReportResults reportResults = reportInfo.getReportSummary().getVitamResults();
            return reportResults;
        }
    }

    protected ReportSummary getReport(LogbookOperation logbook) {
        Optional<LogbookEventOperation> logbookEvent = logbook.getEvents().stream().filter(e -> e.getEvType().startsWith(this.getUpdateActionKey())).reduce((a, b) -> b);
        String startDate = logbook.getEvDateTime();
        String endDate = LocalDateUtil.nowFormatted();
        if (logbookEvent.isEmpty()) {
            return new ReportSummary(startDate, endDate, ReportType.UPDATE_UNIT, null, null);
        }
        Map<StatusCode, Integer> codesNumber = this.getStatusStatistic((LogbookEvent)logbookEvent.get());
        int nbOk = codesNumber.get(StatusCode.OK) == null ? 0 : codesNumber.get(StatusCode.OK);
        int nbKo = codesNumber.get(StatusCode.KO) == null ? 0 : codesNumber.get(StatusCode.KO);
        int nbWarning = codesNumber.get(StatusCode.WARNING) == null ? 0 : codesNumber.get(StatusCode.WARNING);
        ReportResults results = new ReportResults(Integer.valueOf(nbOk), Integer.valueOf(nbKo), Integer.valueOf(nbWarning));
        return new ReportSummary(startDate, endDate, ReportType.UPDATE_UNIT, results, null);
    }

    private Report generateReport(WorkerParameters param) throws InvalidParseOperationException, LogbookClientException {
        LogbookOperation logbook = this.getLogbookInformation(param);
        OperationSummary operationSummary = this.getOperationSummary(logbook, param.getContainerName());
        ReportSummary reportSummary = this.getReport(logbook);
        if (reportSummary.getVitamResults() != null && reportSummary.getVitamResults().getNbKo() > 0 && StatusCode.WARNING.name().equals(param.getWorkflowStatusKo())) {
            operationSummary.setOutcome(operationSummary.getOutcome().replace(StatusCode.KO.name(), param.getWorkflowStatusKo()));
            operationSummary.setOutDetail(operationSummary.getOutDetail().replace(StatusCode.KO.name(), param.getWorkflowStatusKo()));
        }
        ObjectNode context = JsonHandler.createObjectNode();
        return new Report(operationSummary, reportSummary, (JsonNode)context);
    }

    private void storeReportToOffers(WorkerParameters param) throws StorageNotFoundClientException, StorageServerClientException, StorageAlreadyExistsClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(param.getContainerName());
            description.setWorkspaceObjectURI(WORKSPACE_REPORT_URI);
            storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.REPORT, param.getContainerName() + JSONL_EXTENSION, description);
        }
    }

    private void cleanupReport(WorkerParameters param) throws VitamClientInternalException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            batchReportClient.cleanupReport(param.getContainerName(), this.getReportType());
        }
    }

    private LogbookOperation getLogbookInformation(WorkerParameters params) throws InvalidParseOperationException, LogbookClientException {
        try (LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();){
            JsonNode response = logbookClient.selectOperationById(params.getContainerName());
            RequestResponseOK logbookResponse = RequestResponseOK.getFromJsonNode((JsonNode)response);
            LogbookOperation logbookOperation = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)logbookResponse.getFirstResult()), LogbookOperation.class);
            return logbookOperation;
        }
    }

    private OperationSummary getOperationSummary(LogbookOperation logbook, String processId) throws InvalidParseOperationException {
        List events = logbook.getEvents();
        LogbookEventOperation lastEvent = (LogbookEventOperation)events.get(events.size() - 2);
        ObjectNode rSI = StringUtils.isNotBlank((CharSequence)logbook.getRightsStatementIdentifier()) ? JsonHandler.getFromString((String)logbook.getRightsStatementIdentifier()) : JsonHandler.createObjectNode();
        ObjectNode evDetData = Objects.isNull(lastEvent.getEvDetData()) ? JsonHandler.createObjectNode() : JsonHandler.getFromString((String)lastEvent.getEvDetData());
        return new OperationSummary(VitamThreadUtils.getVitamSession().getTenantId(), processId, lastEvent.getEvType(), lastEvent.getOutcome(), lastEvent.getOutDetail(), lastEvent.getOutMessg(), (JsonNode)rSI, (JsonNode)evDetData);
    }

    protected Map<StatusCode, Integer> getStatusStatistic(LogbookEvent logbookEvent) {
        String outMessg = logbookEvent.getOutMessg();
        if (StringUtils.isBlank((CharSequence)outMessg)) {
            return Collections.emptyMap();
        }
        String[] splitedMessage = outMessg.split(DETAILS);
        if (splitedMessage.length != 2) {
            return Collections.emptyMap();
        }
        return Stream.of(splitedMessage).reduce((first, second) -> second).map(last -> Stream.of(last.split("\\s")).filter(StringUtils::isNotBlank).collect(Collectors.toMap(s -> StatusCode.valueOf((String)s.split(":")[0]), s -> Integer.valueOf(s.split(":")[1])))).orElse(Collections.emptyMap());
    }

    protected abstract String getPluginId();

    protected abstract String getUpdateType();

    protected abstract String getUpdateActionKey();

    protected abstract ReportType getReportType();
}

