/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.List;

public class UpdateObjectGroupPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UpdateObjectGroupPlugin.class);
    private static final String OBJECT_GROUP_UPDATE = "OBJECT_GROUP_UPDATE";

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(OBJECT_GROUP_UPDATE);
        try {
            JsonNode existingGot = handlerIO.getJsonFromWorkspace("UpdateObjectGroup/" + params.getObjectName());
            List diffList = VitamDocument.getConcernedDiffLines((List)VitamDocument.getUnifiedDiff((String)" {}", (String)(" " + existingGot.get("_work").get("_existing").toString())));
            ObjectNode diffObject = JsonHandler.createObjectNode();
            diffObject.put("diff", String.join((CharSequence)"\n", diffList));
            diffObject.put("version", VitamConfiguration.getDiffVersion());
            try {
                itemStatus.setEvDetailData(JsonHandler.writeAsString((Object)diffObject));
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error((Throwable)e);
                itemStatus.increment(StatusCode.FATAL);
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(OBJECT_GROUP_UPDATE).setItemsStatus(OBJECT_GROUP_UPDATE, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

