/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.SedaConstants;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.model.unit.ManagementModel;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.FileRules;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.InvalidRuleException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UnitsRulesComputePlugin
extends ActionHandler {
    private static final String WORKSPACE_SERVER_ERROR = "Workspace Server Error";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UnitsRulesComputePlugin.class);
    private static final String CHECK_RULES_TASK_ID = "UNITS_RULES_COMPUTE";
    private static final String FILE_COULD_NOT_BE_DELETED_MSG = "File could not be deleted";
    private static final String AU_PREFIX_WITH_END_DATE = "WithEndDte_";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private static final String CHECKS_RULES = "Rules checks problem: missing parameters";
    private static final String NON_EXISTING_RULE = "Rule %s does not exist";
    private static final String BAD_CATEGORY_RULE = "Rule %s don't match expected category %s but was %s";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final int UNIT_INPUT_RANK = 0;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public UnitsRulesComputePlugin() {
        this(AdminManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    public UnitsRulesComputePlugin(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        LOGGER.debug("UNITS_RULES_COMPUTE in execute");
        long time = System.currentTimeMillis();
        ItemStatus itemStatus = new ItemStatus(CHECK_RULES_TASK_ID);
        try {
            this.calculateMaturityDate(params, itemStatus, handler);
            itemStatus.increment(StatusCode.OK);
        }
        catch (InvalidRuleException e) {
            itemStatus.increment(StatusCode.KO);
            UnitRulesComputeStatus status = e.getUnitRulesComputeStatus();
            switch (status) {
                case REF_INCONSISTENCY: {
                    itemStatus.setGlobalOutcomeDetailSubcode(status.name());
                    itemStatus.setEvDetailData(e.getMessage());
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case UNKNOWN: 
                case CONSISTENCY: {
                    itemStatus.setGlobalOutcomeDetailSubcode(status.name());
                    itemStatus.increment(StatusCode.KO);
                    ItemStatus is = new ItemStatus(status.name());
                    is.setEvDetailData(e.getMessage());
                    is.increment(StatusCode.KO);
                    itemStatus.setSubTaskStatus(e.getObjectId(), is);
                    itemStatus.setItemId(status.name());
                    return new ItemStatus(itemStatus.getItemId()).setItemsStatus(itemStatus.getItemId(), itemStatus);
                }
            }
        }
        catch (ProcessingException e) {
            LOGGER.debug((Throwable)e);
            ObjectNode object = JsonHandler.createObjectNode();
            object.put("UnitRuleCompute", e.getMessage());
            itemStatus.setEvDetailData(object.toString());
            itemStatus.increment(StatusCode.KO);
        }
        LOGGER.debug("[exit] execute... /Elapsed Time:" + (System.currentTimeMillis() - time) / 1000L + "s");
        return new ItemStatus(CHECK_RULES_TASK_ID).setItemsStatus(CHECK_RULES_TASK_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    private void calculateMaturityDate(WorkerParameters params, ItemStatus itemStatus, HandlerIO handlerIO) throws ProcessingException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
        String containerId = params.getContainerName();
        String objectName = params.getObjectName();
        try {
            JsonNode archiveUnit = null;
            if (handlerIO.getInput().size() > 0) {
                archiveUnit = (JsonNode)handlerIO.getInput(0);
            } else {
                try (InputStream inputStream = handlerIO.getInputStreamFromWorkspace("Units/" + objectName);){
                    archiveUnit = JsonHandler.getFromInputStream((InputStream)inputStream);
                }
            }
            this.parseRulesAndUpdateEndDate(archiveUnit, objectName, containerId, handlerIO);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(WORKSPACE_SERVER_ERROR, e);
            throw new ProcessingException(e);
        }
    }

    private JsonNode findRulesValueQueryBuilders(Set<String> rulesId) throws InvalidCreateOperationException, InvalidParseOperationException, IOException, ProcessingException {
        JsonNode jsonNode;
        block9: {
            Select select = new Select();
            select.addOrderByDescFilter(new String[]{"RuleId"});
            BooleanQuery query = QueryHelper.or();
            for (String ruleId : rulesId) {
                query.add(new Query[]{QueryHelper.eq((String)"RuleId", (String)ruleId)});
            }
            select.setQuery((Query)query);
            AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();
            try {
                jsonNode = adminManagementClient.getRules((JsonNode)select.getFinalSelect());
                if (adminManagementClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (adminManagementClient != null) {
                        try {
                            adminManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamException e) {
                    throw new ProcessingException((Throwable)e);
                }
            }
            adminManagementClient.close();
        }
        return jsonNode;
    }

    private void parseRulesAndUpdateEndDate(JsonNode archiveUnit, String objectName, String containerName, HandlerIO handlerIO) throws IOException, ProcessingException {
        File fileWithEndDate = handlerIO.getNewLocalFile(AU_PREFIX_WITH_END_DATE + objectName);
        try {
            JsonNode archiveUnitNode = archiveUnit.get("ArchiveUnit");
            JsonNode workNode = archiveUnit.get("_work");
            JsonNode managementNode = archiveUnitNode.get("_mgt");
            JsonNode unitTileNode = archiveUnitNode.get("Title");
            JsonNode unitIdNode = archiveUnitNode.get("_id");
            String unitTile = "";
            if (null != unitTileNode) {
                unitTile = archiveUnitNode.asText();
            }
            String unitId = "";
            if (null != unitIdNode) {
                unitId = unitIdNode.asText();
            }
            this.validatePreventRuleCategory(unitTile, managementNode);
            HashSet rulesToApply = new HashSet();
            if (workNode.get("RulesToApply") != null) {
                if (workNode.get("RulesToApply").isArray()) {
                    ArrayNode rulesToApplyArray = (ArrayNode)workNode.get("RulesToApply");
                    if (rulesToApplyArray.size() > 0) {
                        rulesToApply = Sets.newHashSet((Iterable)Splitter.on((String)";").omitEmptyStrings().split((CharSequence)((JsonNode)rulesToApplyArray.iterator().next()).asText()));
                    }
                } else {
                    rulesToApply = Sets.newHashSet((Iterable)Splitter.on((String)";").split((CharSequence)workNode.get("RulesToApply").asText()));
                }
            }
            if (rulesToApply.isEmpty()) {
                LOGGER.debug("Archive unit does not have rules");
                return;
            }
            JsonNode rulesResults = this.findRulesValueQueryBuilders(rulesToApply);
            LOGGER.debug("rulesResults for archive unit id: " + objectName + " && containerName is :" + containerName + " is:" + rulesResults);
            for (String ruleType : SedaConstants.getSupportedRules()) {
                JsonNode ruleTypeNode = managementNode.get(ruleType);
                if (ruleTypeNode == null || ruleTypeNode.get("Rules") == null || ruleTypeNode.get("Rules").size() == 0 || ruleTypeNode.get("Rules").findValues("Rule").size() == 0) {
                    LOGGER.debug("no rules of type " + ruleType + " found");
                    continue;
                }
                if (ruleTypeNode.get("Rules").isArray()) {
                    ArrayNode ruleNodes = (ArrayNode)ruleTypeNode.get("Rules");
                    for (JsonNode ruleNode : ruleNodes) {
                        this.computeRuleNode((ObjectNode)ruleNode, rulesResults, ruleType, unitId);
                    }
                    continue;
                }
                LOGGER.debug("ruleTypeNode of type " + ruleType + ".Rules should be an array");
                throw new ProcessingException("ruleTypeNode.Rules should be an array");
            }
            JsonHandler.writeAsFile((Object)archiveUnit, (File)fileWithEndDate);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(e);
            throw new ProcessingException(e);
        }
        try {
            handlerIO.transferFileToWorkspace("Units" + File.separator + objectName, fileWithEndDate, true, false);
        }
        catch (ProcessingException e) {
            LOGGER.error("Can not write to workspace ", (Throwable)e);
            if (!fileWithEndDate.delete()) {
                LOGGER.warn(FILE_COULD_NOT_BE_DELETED_MSG);
            }
            throw e;
        }
    }

    private void validatePreventRuleCategory(String unit, JsonNode managementNode) throws InvalidParseOperationException, InvalidFormatException, ProcessingException {
        if (null == managementNode || !managementNode.elements().hasNext()) {
            return;
        }
        StringBuffer report = new StringBuffer();
        ManagementModel managementModel = (ManagementModel)JsonHandler.getFromJsonNode((JsonNode)managementNode, ManagementModel.class);
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            if (null != managementModel.getAccess() && null != managementModel.getAccess().getInheritance() && null != managementModel.getAccess().getInheritance().getPreventRulesId()) {
                this.validatePreventRuleCategory(unit, "AccessRule", report, managementModel.getAccess().getInheritance().getPreventRulesId(), adminManagementClient);
            }
            if (null != managementModel.getAppraisal() && null != managementModel.getAppraisal().getInheritance() && null != managementModel.getAppraisal().getInheritance().getPreventRulesId()) {
                this.validatePreventRuleCategory(unit, "AppraisalRule", report, managementModel.getAppraisal().getInheritance().getPreventRulesId(), adminManagementClient);
            }
            if (null != managementModel.getDissemination() && null != managementModel.getDissemination().getInheritance() && null != managementModel.getDissemination().getInheritance().getPreventRulesId()) {
                this.validatePreventRuleCategory(unit, "DisseminationRule", report, managementModel.getDissemination().getInheritance().getPreventRulesId(), adminManagementClient);
            }
            if (null != managementModel.getStorage() && null != managementModel.getStorage().getInheritance() && null != managementModel.getStorage().getInheritance().getPreventRulesId()) {
                this.validatePreventRuleCategory(unit, "StorageRule", report, managementModel.getStorage().getInheritance().getPreventRulesId(), adminManagementClient);
            }
            if (null != managementModel.getReuse() && null != managementModel.getReuse().getInheritance() && null != managementModel.getReuse().getInheritance().getPreventRulesId()) {
                this.validatePreventRuleCategory(unit, "ReuseRule", report, managementModel.getReuse().getInheritance().getPreventRulesId(), adminManagementClient);
            }
            if (null != managementModel.getClassification() && null != managementModel.getClassification().getInheritance() && null != managementModel.getClassification().getInheritance().getPreventRulesId()) {
                this.validatePreventRuleCategory(unit, "ClassificationRule", report, managementModel.getClassification().getInheritance().getPreventRulesId(), adminManagementClient);
            }
            if (null != managementModel.getHold() && null != managementModel.getHold().getInheritance() && null != managementModel.getHold().getInheritance().getPreventRulesId()) {
                this.validatePreventRuleCategory(unit, "HoldRule", report, managementModel.getHold().getInheritance().getPreventRulesId(), adminManagementClient);
            }
        }
        catch (VitamException e) {
            throw new ProcessingException((Throwable)e);
        }
        String errors = report.toString();
        if (ParametersChecker.isNotEmpty((String[])new String[]{errors})) {
            ObjectNode json = JsonHandler.createObjectNode();
            json.put("evDetTechData", errors);
            throw new InvalidRuleException(UnitRulesComputeStatus.REF_INCONSISTENCY, JsonHandler.unprettyPrint((Object)json));
        }
    }

    private void validatePreventRuleCategory(String unit, String ruleType, StringBuffer report, Collection<String> ruleIds, AdminManagementClient adminManagementClient) throws FileRulesException, InvalidParseOperationException, InvalidFormatException, AdminManagementClientServerException {
        if (null == ruleIds) {
            return;
        }
        for (String ruleId : ruleIds) {
            JsonNode rulesInDB = adminManagementClient.getRuleByID(ruleId);
            if (null == rulesInDB) {
                report.append("In the unit ").append(unit).append(" the rule id ").append(ruleId).append(" in the RuleType ").append(ruleType).append(" is not found in db ; ");
                continue;
            }
            RequestResponse fr = (RequestResponse)JsonHandler.getFromStringAsTypeReference((String)rulesInDB.toString(), (TypeReference)new TypeReference<RequestResponseOK<FileRules>>(){});
            if (fr.isOk()) {
                RequestResponseOK frok = (RequestResponseOK)fr;
                Iterator it = frok.getResults().iterator();
                if (it.hasNext()) {
                    RuleType rr = ((FileRules)it.next()).getRuletype();
                    if (ruleType.equals(rr.name())) continue;
                    report.append("In the unit ").append(unit).append(" the rule id ").append(ruleId).append(" is in the wrong RuleType ").append(" it should be in the RuleType ").append(ruleType).append(" ; ");
                    continue;
                }
                report.append("In the unit ").append(unit).append(" the rule id ").append(ruleId).append(" not found in db").append(" ; ");
                continue;
            }
            VitamError vr = (VitamError)fr;
            report.append("In the unit ").append(unit).append(" error while getting rule id : ").append(ruleId).append(" : ").append(vr.getMessage()).append(" : ").append(vr.getDescription()).append(" ; ");
        }
    }

    private void computeRuleNode(ObjectNode ruleNode, JsonNode rulesResults, String ruleType, String unitId) throws ProcessingException {
        String ruleId = ruleNode.get("Rule").asText();
        String startDate = ruleNode.hasNonNull("StartDate") ? ruleNode.get("StartDate").asText() : null;
        String holdEndDate = ruleNode.hasNonNull("HoldEndDate") ? ruleNode.get("HoldEndDate").asText() : null;
        JsonNode referencedRule = this.checkRuleNodeByID(ruleId, ruleType, rulesResults, unitId);
        if (this.hasUndefinedHoldRuleDuration(ruleType, referencedRule)) {
            this.ensureStartDateIsBeforeHoldEndDate(startDate, holdEndDate, unitId, ruleId);
            this.computeEndDateForUndefinedHoldRuleDuration(ruleNode, ruleType, unitId, ruleId, holdEndDate);
            return;
        }
        this.ensureHoldEndRuleNotDefined(unitId, ruleId, holdEndDate);
        LocalDate endDate = this.computeEndDateForRuleWithDuration(startDate, ruleId, ruleType, referencedRule);
        if (endDate != null) {
            ruleNode.put("EndDate", endDate.format(DATE_TIME_FORMATTER));
        }
    }

    private void ensureHoldEndRuleNotDefined(String unitId, String ruleId, String holdEndDate) throws InvalidRuleException {
        if (holdEndDate != null) {
            String errorMessage = String.format("Cannot set %s for rule %s with defined duration.", "HoldEndDate", ruleId);
            ObjectNode json = JsonHandler.createObjectNode();
            json.put("evDetTechData", errorMessage);
            throw new InvalidRuleException(UnitRulesComputeStatus.CONSISTENCY, JsonHandler.unprettyPrint((Object)json), unitId);
        }
    }

    private boolean hasUndefinedHoldRuleDuration(String ruleType, JsonNode referencedRule) {
        return "HoldRule".equals(ruleType) && !referencedRule.hasNonNull("RuleDuration");
    }

    private void computeEndDateForUndefinedHoldRuleDuration(ObjectNode ruleNode, String ruleType, String unitId, String ruleId, String holdEndDate) {
        if (holdEndDate == null) {
            LOGGER.debug(String.format("EndDate cannot be computed for %s rule %s for unit %s since no HoldEndDate provided & rule has no defined duration", ruleType, ruleId, unitId));
            return;
        }
        LOGGER.debug(String.format("EndDate will be set to HoldEndDate for %s rule %s for unit %s since hold rule has no defined duration", ruleType, ruleId, unitId));
        ruleNode.put("EndDate", holdEndDate);
    }

    private void ensureStartDateIsBeforeHoldEndDate(String startDate, String holdEndDate, String unitId, String ruleId) throws InvalidRuleException {
        if (startDate != null && holdEndDate != null) {
            LocalDate localStartDate = LocalDate.parse(startDate, DATE_TIME_FORMATTER);
            LocalDate localHoldEndDate = LocalDate.parse(holdEndDate, DATE_TIME_FORMATTER);
            if (localHoldEndDate.isBefore(localStartDate)) {
                String errorMessage = "Illegal HoldEndDate(" + holdEndDate + ") for " + ruleId + ". Cannot be lower than StartDate(" + startDate + ")";
                ObjectNode json = JsonHandler.createObjectNode();
                json.put("evDetTechData", errorMessage);
                throw new InvalidRuleException(UnitRulesComputeStatus.CONSISTENCY, JsonHandler.unprettyPrint((Object)json), unitId);
            }
        }
    }

    private JsonNode checkRuleNodeByID(String ruleId, String ruleType, JsonNode jsonResult, String unitId) throws InvalidRuleException {
        ObjectNode json;
        String errorMessage;
        String ruleTypeWithWrongCategory = null;
        if (jsonResult != null && ParametersChecker.isNotEmpty((String[])new String[]{ruleId, ruleType})) {
            ArrayNode rulesResult = (ArrayNode)jsonResult.get("$results");
            for (JsonNode rule : rulesResult) {
                if (rule.get("RuleId") == null || rule.get("RuleType") == null) continue;
                String ruleIdFromList = rule.get("RuleId").asText();
                String ruleTypeFromList = rule.get("RuleType").asText();
                if (!ruleId.equals(ruleIdFromList)) continue;
                if (ruleType.equals(ruleTypeFromList)) {
                    return rule;
                }
                ruleTypeWithWrongCategory = ruleTypeFromList;
            }
        }
        if (ruleTypeWithWrongCategory != null) {
            errorMessage = String.format(BAD_CATEGORY_RULE, ruleId, ruleType, ruleTypeWithWrongCategory);
            json = JsonHandler.createObjectNode();
            json.put("evDetTechData", errorMessage);
            throw new InvalidRuleException(UnitRulesComputeStatus.CONSISTENCY, JsonHandler.unprettyPrint((Object)json), unitId);
        }
        errorMessage = String.format(NON_EXISTING_RULE, ruleId);
        json = JsonHandler.createObjectNode();
        json.put("evDetTechData", errorMessage);
        throw new InvalidRuleException(UnitRulesComputeStatus.UNKNOWN, JsonHandler.unprettyPrint((Object)json), unitId);
    }

    private LocalDate computeEndDateForRuleWithDuration(String startDateString, String ruleId, String currentRuleType, JsonNode ruleNode) throws ProcessingException {
        if (!ParametersChecker.isNotEmpty((String[])new String[]{startDateString})) {
            return null;
        }
        if (ParametersChecker.isNotEmpty((String[])new String[]{ruleId, currentRuleType})) {
            LocalDate startDate = LocalDate.parse(startDateString, DATE_TIME_FORMATTER);
            if (this.checkRulesParameters(ruleNode)) {
                String duration = ruleNode.get("RuleDuration").asText();
                String measurement = ruleNode.get("RuleMeasurement").asText();
                if (duration.equalsIgnoreCase("unlimited")) {
                    return null;
                }
                RuleMeasurementEnum ruleMeasurement = RuleMeasurementEnum.getEnumFromType((String)measurement);
                return startDate.plus(Integer.parseInt(duration), ruleMeasurement.getTemporalUnit());
            }
            throw new ProcessingException(CHECKS_RULES);
        }
        return null;
    }

    private boolean checkRulesParameters(JsonNode ruleNode) {
        return ruleNode != null && ruleNode.get("RuleDuration") != null && ruleNode.get("RuleMeasurement") != null;
    }

    public static enum UnitRulesComputeStatus {
        UNKNOWN,
        REF_INCONSISTENCY,
        CONSISTENCY;

    }
}

