/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectStoreResponse;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.MapOfObjects;
import fr.gouv.vitam.worker.core.plugin.StoreObjectActionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class StoreObjectGroupActionPlugin
extends StoreObjectActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StoreObjectGroupActionPlugin.class);
    public static final String STORING_OBJECT_TASK_ID = "OBJECT_STORAGE_SUB_TASK";
    private static final String SIP = "SIP/";
    private static final int OG_OUT_RANK = 0;

    public StoreObjectGroupActionPlugin() {
        this(StorageClientFactory.getInstance());
    }

    public StoreObjectGroupActionPlugin(StorageClientFactory storageClientFactory) {
        super(storageClientFactory);
    }

    public List<ItemStatus> executeList(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ArrayList<ItemStatus> itemStatusList = new ArrayList<ItemStatus>();
        ArrayList<Map<String, ItemStatus>> itemStatusByObjectList = new ArrayList<Map<String, ItemStatus>>();
        try {
            this.checkMandatoryIOParameter(handlerIO);
            LinkedHashSet<String> strategies = new LinkedHashSet<String>();
            HashMap<String, String> strategiesByObjectId = new HashMap<String, String>();
            ArrayListValuedHashMap workspaceObjectURIsByStrategies = new ArrayListValuedHashMap();
            ArrayListValuedHashMap objectNamesByStrategies = new ArrayListValuedHashMap();
            ArrayList<MapOfObjects> mapOfObjectsList = new ArrayList<MapOfObjects>();
            for (Object objectName : params.getObjectNameList()) {
                MapOfObjects mapOfObjects = this.getMapOfObjectsIdsAndUris(params.getContainerName(), (String)objectName, handlerIO);
                HashMap<String, ItemStatus> itemStatusByObject = new HashMap<String, ItemStatus>();
                for (Map.Entry<String, String> objectGuid : mapOfObjects.getBinaryObjectsToStore().entrySet()) {
                    itemStatusByObject.put(objectGuid.getKey(), new ItemStatus(STORING_OBJECT_TASK_ID));
                    String strategyId = mapOfObjects.getObjectStorageInfos().get(objectGuid.getKey()).get("strategyId").asText();
                    strategies.add(strategyId);
                    workspaceObjectURIsByStrategies.put((Object)strategyId, (Object)(SIP + objectGuid.getValue()));
                    objectNamesByStrategies.put((Object)strategyId, (Object)objectGuid.getKey());
                    strategiesByObjectId.put(objectGuid.getKey(), strategyId);
                }
                itemStatusByObjectList.add(itemStatusByObject);
                itemStatusList.add(new ItemStatus(STORING_OBJECT_TASK_ID));
                mapOfObjectsList.add(mapOfObjects);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Pre OG: {}", (Object)JsonHandler.prettyPrint((Object)mapOfObjects.getJsonOG()));
            }
            if (objectNamesByStrategies.values().isEmpty()) {
                return Arrays.asList(new ItemStatus(STORING_OBJECT_TASK_ID).setItemsStatus(STORING_OBJECT_TASK_ID, new ItemStatus().increment(StatusCode.OK)));
            }
            LinkedHashMap<String, BulkObjectStoreResponse> resultByStrategy = new LinkedHashMap<String, BulkObjectStoreResponse>();
            for (String strategy : strategies) {
                List workspaceObjectURIs = workspaceObjectURIsByStrategies.get((Object)strategy);
                List objectNames = objectNamesByStrategies.get((Object)strategy);
                BulkObjectStoreRequest bulkObjectStoreRequest = new BulkObjectStoreRequest(params.getContainerName(), workspaceObjectURIs, DataCategory.OBJECT, objectNames);
                BulkObjectStoreResponse result = this.storeObjects(strategy, bulkObjectStoreRequest);
                resultByStrategy.put(strategy, result);
            }
            this.updateSubTasksAndTasksFromStorageInfos(resultByStrategy, itemStatusByObjectList, itemStatusList);
            this.storeStorageInfos(mapOfObjectsList, resultByStrategy, strategiesByObjectId);
            for (int i = 0; i < mapOfObjectsList.size(); ++i) {
                handlerIO.transferJsonToWorkspace("ObjectGroup", (String)params.getObjectNameList().get(i), ((MapOfObjects)mapOfObjectsList.get(i)).getJsonOG(), false, false);
            }
        }
        catch (ProcessingException e) {
            LOGGER.error(params.getObjectName(), (Throwable)e);
            return Arrays.asList(new ItemStatus(STORING_OBJECT_TASK_ID).setItemsStatus(STORING_OBJECT_TASK_ID, new ItemStatus().increment(StatusCode.FATAL)));
        }
        catch (StorageClientException e) {
            LOGGER.error((Throwable)e);
            return Arrays.asList(new ItemStatus(STORING_OBJECT_TASK_ID).setItemsStatus(STORING_OBJECT_TASK_ID, new ItemStatus().increment(StatusCode.FATAL)));
        }
        return this.getFinalResult(itemStatusList);
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new ProcessingException("No need to implements method");
    }

    private MapOfObjects getMapOfObjectsIdsAndUris(String containerId, String objectName, HandlerIO handlerIO) throws ProcessingException {
        MapOfObjects mapOfObjects = new MapOfObjects();
        mapOfObjects.setBinaryObjectsToStore(new HashMap<String, String>());
        mapOfObjects.setObjectJsonMap(new HashMap<String, JsonNode>());
        mapOfObjects.setObjectStorageInfos(new HashMap<String, JsonNode>());
        ParametersChecker.checkParameter((String)"Container id is a mandatory parameter", (String[])new String[]{containerId});
        ParametersChecker.checkParameter((String)"ObjectName id is a mandatory parameter", (String[])new String[]{objectName});
        mapOfObjects.setJsonOG(handlerIO.getJsonFromWorkspace("ObjectGroup/" + objectName));
        handlerIO.setCurrentObjectId(objectName);
        handlerIO.addOutputResult(0, (Object)mapOfObjects.getJsonOG(), true, false);
        JsonNode original = mapOfObjects.getJsonOG().get("_qualifiers");
        JsonNode work = mapOfObjects.getJsonOG().get("_work");
        JsonNode qualifiers = work.get("_qualifiers");
        if (qualifiers == null) {
            return mapOfObjects;
        }
        List originalVersions = original.findValues("versions");
        List versions = qualifiers.findValues("versions");
        if (versions == null || versions.isEmpty()) {
            return mapOfObjects;
        }
        for (JsonNode version : versions) {
            for (JsonNode binaryObject : version) {
                if (binaryObject.get("PhysicalId") != null) continue;
                String id = binaryObject.get("_id").asText();
                mapOfObjects.getBinaryObjectsToStore().put(id, binaryObject.get("Uri").asText());
                for (JsonNode version2 : originalVersions) {
                    for (JsonNode binaryObject2 : version2) {
                        if (binaryObject2.get("PhysicalId") != null || !binaryObject2.get("_id").asText().equals(id)) continue;
                        mapOfObjects.getObjectJsonMap().put(id, binaryObject2);
                        mapOfObjects.getObjectStorageInfos().put(id, binaryObject.get("_storage"));
                    }
                }
            }
        }
        return mapOfObjects;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    private List<ItemStatus> getFinalResult(List<ItemStatus> itemStatusList) {
        ArrayList<ItemStatus> finalItemStatusList = new ArrayList<ItemStatus>();
        for (ItemStatus itemStatus : itemStatusList) {
            finalItemStatusList.add(new ItemStatus(STORING_OBJECT_TASK_ID).setItemsStatus(STORING_OBJECT_TASK_ID, itemStatus));
        }
        return finalItemStatusList;
    }
}

