/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectStoreResponse;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.MapOfObjects;
import java.util.List;
import java.util.Map;

public abstract class StoreObjectActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StoreObjectActionHandler.class);
    private static final String FILE_NAME = "FileName";
    private static final String OFFERS = "Offers";
    private static final String ALGORITHM = "Algorithm";
    private static final String DIGEST = "MessageDigest";
    private final StorageClientFactory storageClientFactory;

    public StoreObjectActionHandler(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    protected StoredInfoResult storeObject(String strategyId, ObjectDescription description, ItemStatus itemStatus) {
        block11: {
            StoredInfoResult storedInfoResult;
            block10: {
                StorageClient storageClient = this.storageClientFactory.getClient();
                try {
                    storedInfoResult = storageClient.storeFileFromWorkspace(strategyId, description.getType(), description.getObjectName(), description);
                    if (storageClient == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (storageClient != null) {
                            try {
                                storageClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (StorageAlreadyExistsClientException e) {
                        LOGGER.error((Throwable)e);
                        itemStatus.increment(StatusCode.KO);
                        break block11;
                    }
                    catch (StorageNotFoundClientException e) {
                        LOGGER.error((Throwable)e);
                        itemStatus.increment(StatusCode.FATAL);
                        break block11;
                    }
                    catch (StorageServerClientException e) {
                        LOGGER.error((Throwable)e);
                        itemStatus.increment(StatusCode.FATAL);
                    }
                }
                storageClient.close();
            }
            return storedInfoResult;
        }
        return null;
    }

    protected BulkObjectStoreResponse storeObjects(String startegy, BulkObjectStoreRequest bulkObjectStoreRequest) throws StorageNotFoundClientException, StorageServerClientException, StorageAlreadyExistsClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            BulkObjectStoreResponse bulkObjectStoreResponse = storageClient.bulkStoreFilesFromWorkspace(startegy, bulkObjectStoreRequest);
            return bulkObjectStoreResponse;
        }
    }

    protected void storeStorageInfos(List<MapOfObjects> mapOfObjectsList, Map<String, BulkObjectStoreResponse> resultByStrategy, Map<String, String> strategiesByObjectId) {
        LOGGER.debug("DEBUG storeStorageInfos");
        for (MapOfObjects mapOfObjects : mapOfObjectsList) {
            Map<String, JsonNode> nodes = mapOfObjects.getObjectJsonMap();
            for (Map.Entry<String, String> objectGuid : mapOfObjects.getBinaryObjectsToStore().entrySet()) {
                String strategy = strategiesByObjectId.get(objectGuid.getKey());
                BulkObjectStoreResponse result = resultByStrategy.get(strategy);
                LOGGER.debug("DEBUG strategy: {}", (Object)strategy);
                LOGGER.debug("DEBUG result: {}", (Object)result);
                ObjectNode storage = JsonHandler.createObjectNode();
                storage.put("strategyId", strategy);
                ((ObjectNode)nodes.get(objectGuid.getKey())).set("_storage", (JsonNode)storage);
                LOGGER.debug("DEBUG node: {}", (Object)nodes.get(objectGuid.getKey()));
            }
        }
    }

    protected void updateSubTasksAndTasksFromStorageInfos(Map<String, BulkObjectStoreResponse> resultsByStrategy, List<Map<String, ItemStatus>> itemStatusByObjectList, List<ItemStatus> itemStatusList) {
        for (BulkObjectStoreResponse result : resultsByStrategy.values()) {
            for (Map.Entry objectDigest : result.getObjectDigests().entrySet()) {
                int pos = this.getElementPositionForObjectName((String)objectDigest.getKey(), itemStatusByObjectList);
                Map<String, ItemStatus> itemStatusByObject = itemStatusByObjectList.get(pos);
                ItemStatus itemStatus = itemStatusList.get(pos);
                ObjectNode object = JsonHandler.createObjectNode();
                object.put(FILE_NAME, (String)objectDigest.getKey());
                object.put(ALGORITHM, result.getDigestType());
                object.put(DIGEST, (String)objectDigest.getValue());
                object.put(OFFERS, result.getOfferIds() != null ? String.join((CharSequence)",", result.getOfferIds()) : "");
                itemStatusByObject.get(objectDigest.getKey()).increment(StatusCode.OK);
                itemStatusByObject.get(objectDigest.getKey()).setEvDetailData(JsonHandler.unprettyPrint((Object)object));
                itemStatus.setSubTaskStatus((String)objectDigest.getKey(), itemStatusByObject.get(objectDigest.getKey())).increment(itemStatusByObject.get(objectDigest.getKey()).getGlobalStatus());
            }
        }
    }

    private int getElementPositionForObjectName(String objectName, List<Map<String, ItemStatus>> itemStatusByObjectList) {
        for (int i = 0; i < itemStatusByObjectList.size(); ++i) {
            if (!itemStatusByObjectList.get(i).containsKey(objectName)) continue;
            return i;
        }
        return -1;
    }
}

