/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.core.plugin.StoreObjectActionHandler;

public abstract class StoreMetadataObjectActionHandler
extends StoreObjectActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StoreMetadataObjectActionHandler.class);
    private static final String $RESULTS = "$results";
    private static final String DOCUMENT_NOT_FOUND = "Document not found";

    public StoreMetadataObjectActionHandler(StorageClientFactory storageClientFactory) {
        super(storageClientFactory);
    }

    protected JsonNode selectMetadataDocumentRawById(String idDocument, DataCategory dataCategory, MetaDataClient metaDataClient) throws VitamException {
        JsonNode jsonResponse;
        ParametersChecker.checkParameter((String)"Data category ", (Object[])new Object[]{dataCategory});
        ParametersChecker.checkParameter((String)"idDocument is empty", (String[])new String[]{idDocument});
        try {
            RequestResponse requestResponse;
            switch (dataCategory) {
                case UNIT: {
                    requestResponse = metaDataClient.getUnitByIdRaw(idDocument);
                    break;
                }
                case OBJECTGROUP: {
                    requestResponse = metaDataClient.getObjectGroupByIdRaw(idDocument);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported category " + dataCategory);
                }
            }
            if (!requestResponse.isOk()) {
                throw new ProcessingException(DOCUMENT_NOT_FOUND);
            }
            jsonResponse = requestResponse.toJsonNode();
        }
        catch (VitamClientException e) {
            LOGGER.error((Throwable)e);
            throw e;
        }
        return this.extractNodeFromResponse(jsonResponse, DOCUMENT_NOT_FOUND);
    }

    protected JsonNode getRawLogbookLifeCycleById(String idDocument, DataCategory dataCategory, LogbookLifeCyclesClient logbookClient) throws VitamException {
        switch (dataCategory) {
            case UNIT: {
                return logbookClient.getRawUnitLifeCycleById(idDocument);
            }
            case OBJECTGROUP: {
                return logbookClient.getRawObjectGroupLifeCycleById(idDocument);
            }
        }
        throw new IllegalArgumentException("Unsupported category " + dataCategory);
    }

    private JsonNode extractNodeFromResponse(JsonNode jsonResponse, String error) throws VitamException {
        if (jsonResponse == null) {
            LOGGER.error(error);
            throw new ProcessingException(error);
        }
        JsonNode jsonNode = jsonResponse.get($RESULTS);
        if (jsonNode == null || jsonNode.size() == 0) {
            LOGGER.error(error);
            throw new VitamException(error);
        }
        return jsonNode.get(0);
    }
}

