/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.MetadataStorageHelper;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.WorkspaceClientServerException;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class StoreMetaDataUnitActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StoreMetaDataUnitActionPlugin.class);
    private static final String JSON = ".json";
    private static final String UNIT_METADATA_STORAGE = "UNIT_METADATA_STORAGE";
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final StorageClientFactory storageClientFactory;

    public StoreMetaDataUnitActionPlugin() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    StoreMetaDataUnitActionPlugin(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, StorageClientFactory storageClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters params, HandlerIO handlerIO) {
        List<String> unitIds = params.getObjectNameList().stream().map(metadataFilename -> StringUtils.substringBeforeLast((String)metadataFilename, (String)".")).collect(Collectors.toList());
        try {
            this.storeDocumentsWithLfc(params, handlerIO, unitIds);
            return this.getItemStatuses(unitIds, StatusCode.OK);
        }
        catch (VitamException e) {
            LOGGER.error("An error occurred during unit storage", (Throwable)e);
            return this.getItemStatuses(unitIds, StatusCode.FATAL);
        }
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        throw new IllegalStateException("Not implemented.");
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public void storeDocumentsWithLfc(WorkerParameters params, HandlerIO handlerIO, List<String> unitIds) throws VitamException {
        MultiValuedMap<String, String> unitIdsByStrategies = this.saveDocumentWithLfcInWorkspace(handlerIO, unitIds);
        this.saveDocumentWithLfcInStorage(params.getContainerName(), unitIdsByStrategies);
    }

    private MultiValuedMap<String, String> saveDocumentWithLfcInWorkspace(HandlerIO handlerIO, List<String> unitIds) throws VitamException {
        Stopwatch loadAU = Stopwatch.createStarted();
        HashSetValuedHashMap unitIdsByStrategie = new HashSetValuedHashMap();
        Map<String, JsonNode> units = this.getUnitsByIdsRaw(unitIds);
        for (JsonNode unit : units.values()) {
            MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)unit);
            String strategyId = MetadataDocumentHelper.getStrategyIdFromRawUnitOrGot((JsonNode)unit);
            unitIdsByStrategie.put((Object)strategyId, (Object)unit.get("_id").asText());
        }
        PerformanceLogger.getInstance().log("STP_UNIT_STORING", UNIT_METADATA_STORAGE, "loadAU", loadAU.elapsed(TimeUnit.MILLISECONDS));
        Stopwatch loadLFC = Stopwatch.createStarted();
        Map<String, JsonNode> lfc = this.getRawLogbookLifeCycleByIds(unitIds);
        PerformanceLogger.getInstance().log("STP_UNIT_STORING", UNIT_METADATA_STORAGE, "loadLFC", loadLFC.elapsed(TimeUnit.MILLISECONDS));
        for (String guid : unitIds) {
            JsonNode docWithLfc = MetadataStorageHelper.getUnitWithLFC((JsonNode)units.get(guid), (JsonNode)lfc.get(guid));
            String fileName = guid + JSON;
            try {
                InputStream is = CanonicalJsonFormatter.serialize((JsonNode)docWithLfc);
                Stopwatch storeWorkspace = Stopwatch.createStarted();
                handlerIO.transferInputStreamToWorkspace("Units/" + fileName, is, null, false);
                PerformanceLogger.getInstance().log("STP_UNIT_STORING", UNIT_METADATA_STORAGE, "storeWorkspace", storeWorkspace.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (ProcessingException e) {
                throw new WorkspaceClientServerException("Could not backup file for " + guid, (Throwable)e);
            }
        }
        return unitIdsByStrategie;
    }

    private Map<String, JsonNode> getUnitsByIdsRaw(List<String> documentIds) throws VitamException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            RequestResponse requestResponse = metaDataClient.getUnitsByIdsRaw(documentIds);
            if (!requestResponse.isOk()) {
                throw new ProcessingException("Documents not found " + documentIds);
            }
            List results = ((RequestResponseOK)requestResponse).getResults();
            if (results.size() != documentIds.size()) {
                throw new ProcessingException("Documents not found " + documentIds);
            }
            Map<String, JsonNode> map = this.mapById(results);
            return map;
        }
    }

    private Map<String, JsonNode> getRawLogbookLifeCycleByIds(Collection<String> documentIds) throws VitamException {
        try (LogbookLifeCyclesClient logbookClient = this.logbookLifeCyclesClientFactory.getClient();){
            List results = logbookClient.getRawUnitLifeCycleByIds((List)Lists.newArrayList(documentIds));
            Map<String, JsonNode> map = this.mapById(results);
            return map;
        }
    }

    private void saveDocumentWithLfcInStorage(String containerName, MultiValuedMap<String, String> unitIdsByStrategies) throws VitamException {
        Stopwatch storeStorage = Stopwatch.createStarted();
        for (String strategy : unitIdsByStrategies.keySet()) {
            ArrayList<CallSite> workspaceURIs = new ArrayList<CallSite>();
            ArrayList<CallSite> objectNames = new ArrayList<CallSite>();
            Collection unitIds = unitIdsByStrategies.get((Object)strategy);
            for (String unitId : unitIds) {
                String filename = unitId + JSON;
                String workspaceURI = "Units" + File.separator + filename;
                workspaceURIs.add((CallSite)((Object)workspaceURI));
                objectNames.add((CallSite)((Object)filename));
            }
            BulkObjectStoreRequest request = new BulkObjectStoreRequest(containerName, workspaceURIs, DataCategory.UNIT, objectNames);
            try {
                StorageClient storageClient = this.storageClientFactory.getClient();
                try {
                    storageClient.bulkStoreFilesFromWorkspace(strategy, request);
                }
                finally {
                    if (storageClient == null) continue;
                    storageClient.close();
                }
            }
            catch (StorageAlreadyExistsClientException | StorageNotFoundClientException e) {
                throw new ProcessingException("Bulk storage failed", e);
            }
        }
        PerformanceLogger.getInstance().log("STP_UNIT_STORING", UNIT_METADATA_STORAGE, "storeStorage", storeStorage.elapsed(TimeUnit.MILLISECONDS));
    }

    private List<ItemStatus> getItemStatuses(List<String> unitIds, StatusCode statusCode) {
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        for (String unitId : unitIds) {
            itemStatuses.add(PluginHelper.buildItemStatus(UNIT_METADATA_STORAGE, statusCode, null));
        }
        return itemStatuses;
    }

    private Map<String, JsonNode> mapById(List<JsonNode> results) {
        return results.stream().collect(Collectors.toMap(entry -> entry.get("_id").textValue(), entry -> entry));
    }
}

